/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.peatfarm;

import com.lothrazar.cyclic.block.PeatFuelBlock;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.peatfarm.ContainerPeatFarm;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.util.ShapeUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePeatFarm
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final int SIZE = 6;
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static final int CAPACITY = 64000;
    static final int MAX = 64000;
    public static final int TIMER_FULL = 10;
    private static final int PER_TICK = 1;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(6){

        public boolean isItemValid(int slot, ItemStack stack) {
            return Block.m_49814_((Item)stack.m_41720_()) == BlockRegistry.PEAT_UNBAKED.get();
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int blockPointer = 0;
    List<BlockPos> outer = null;

    public Component m_5446_() {
        return ((Block)BlockRegistry.PEAT_FARM.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerPeatFarm(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TilePeatFarm e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TilePeatFarm e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            this.blockPointer = 0;
            return;
        }
        this.setLitProperty(true);
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if (this.outer == null) {
            this.outer = this.getShape();
            List waterShape = ShapeUtil.squareHorizontalHollow((BlockPos)this.m_58899_(), (int)6);
            this.outer.addAll(waterShape);
        }
        for (int i = 0; i < 1; ++i) {
            if (this.blockPointer < this.outer.size()) {
                boolean placeWater;
                BlockPos target = this.outer.get(this.blockPointer);
                boolean bl = placeWater = (target.m_123341_() - this.f_58858_.m_123341_()) % 3 == 0 && (target.m_123343_() - this.f_58858_.m_123343_()) % 3 == 0;
                if (placeWater) {
                    if (this.tryPlaceWater(target)) {
                        this.energy.extractEnergy(cost, false);
                    }
                } else if (this.tryPlacePeat(target)) {
                    this.energy.extractEnergy(cost, false);
                }
                ++this.blockPointer;
                continue;
            }
            this.blockPointer = 0;
        }
        this.timer = 10;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
            }
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public TilePeatFarm(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.PEAT_FARM.get(), pos, state);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return Block.m_49814_((Item)stack.m_41720_()) == BlockRegistry.PEAT_UNBAKED.get();
    }

    public List<BlockPos> getShapeHollow() {
        return this.getShape();
    }

    List<BlockPos> getShape() {
        List outer = ShapeUtil.squareHorizontalHollow((BlockPos)this.f_58858_, (int)7);
        outer.addAll(ShapeUtil.squareHorizontalHollow((BlockPos)this.f_58858_, (int)5));
        return outer;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public float getCapacity() {
        return 64000.0f;
    }

    private boolean tryPlacePeat(BlockPos target) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            BlockState state = Block.m_49814_((Item)itemStack.m_41720_()).m_49966_();
            if (itemStack.m_41613_() == 0) continue;
            if (this.f_58857_.m_8055_(target).m_60734_() instanceof PeatFuelBlock) {
                this.f_58857_.m_46961_(target, true);
            }
            if (!this.f_58857_.m_46859_(target) && this.f_58857_.m_6425_(target).m_76152_() != Fluids.f_76193_ && this.f_58857_.m_6425_(target).m_76152_() != Fluids.f_76192_ || !this.f_58857_.m_46597_(target, state)) continue;
            itemStack.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean tryPlaceWater(BlockPos target) {
        if (this.f_58857_.m_8055_(target).m_60722_((Fluid)Fluids.f_76193_) && this.f_58857_.m_8055_(target).m_60734_() != Blocks.f_49990_ && this.tank.getFluidAmount() >= 1000 && this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE) != null) {
            this.f_58857_.m_46597_(target, Blocks.f_49990_.m_49966_());
            return true;
        }
        return false;
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    static enum Fields {
        REDSTONE,
        RENDER;

    }
}

