/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.user;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.user.ContainerUser;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.cap.ItemStackHandlerWrapper;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TileUser
extends TileBlockEntityCyclic
implements MenuProvider,
WorldlyContainer {
    public static ForgeConfigSpec.IntValue POWERCONF;
    static final int MAX = 640000;
    ItemStackHandler userSlots = new ItemStackHandler(1);
    ItemStackHandler outputSlots = new ItemStackHandler(4);
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.userSlots, this.outputSlots);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private int timerDelay = 20;
    boolean doHitBreak = false;
    boolean entities = false;

    public TileUser(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.USER.get(), pos, state);
        this.needsRedstone = 1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileUser e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileUser e) {
        e.tick();
    }

    public void tick() {
        int repair;
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = this.timerDelay;
        if (this.fakePlayer == null) {
            this.fakePlayer = this.setupBeforeTrigger((ServerLevel)this.f_58857_, "user");
        }
        if ((repair = ((Integer)POWERCONF.get()).intValue()) > 0) {
            if (this.energy.getEnergyStored() < repair) {
                return;
            }
            this.energy.extractEnergy(repair, false);
        }
        try {
            boolean mainhandChanged;
            ItemCooldowns cooldowns = ((FakePlayer)this.fakePlayer.get()).m_36335_();
            TileBlockEntityCyclic.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, InteractionHand.MAIN_HAND);
            Item item = ((FakePlayer)this.fakePlayer.get()).m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            Item oldItem = item.m_5456_();
            if (cooldowns.m_41519_(item)) {
                cooldowns.m_41527_(item);
            }
            BlockPos target = this.f_58858_.m_121945_(this.getCurrentFacing());
            if (this.entities) {
                this.interactEntities(target);
            } else if (this.doHitBreak) {
                TileBlockEntityCyclic.playerAttackBreakBlock(this.fakePlayer, this.f_58857_, target, InteractionHand.MAIN_HAND, this.getCurrentFacing());
            } else {
                TileBlockEntityCyclic.interactUseOnBlock(this.fakePlayer, this.f_58857_, target, InteractionHand.MAIN_HAND, null);
            }
            boolean bl = mainhandChanged = oldItem != this.userSlots.getStackInSlot(0).m_41720_();
            if (mainhandChanged) {
                this.depositOutputMainhand();
            }
            TileBlockEntityCyclic.syncEquippedItem(this.userSlots, this.fakePlayer, 0, InteractionHand.MAIN_HAND);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("User action item error", e);
        }
        boolean dropItemsOnGround = false;
        this.tryDumpFakePlayerInvo(this.fakePlayer, this.outputSlots, false);
    }

    private void depositOutputMainhand() {
        ItemStack usedItem = ((FakePlayer)this.fakePlayer.get()).m_21120_(InteractionHand.MAIN_HAND);
        for (int slotId = 0; slotId < this.outputSlots.getSlots(); ++slotId) {
            if (usedItem.m_41619_() || !this.outputSlots.insertItem(slotId, usedItem.m_41777_(), true).m_41619_()) continue;
            usedItem = this.outputSlots.insertItem(slotId, usedItem.m_41777_(), false);
            TileBlockEntityCyclic.tryEquipItem(usedItem, this.fakePlayer, InteractionHand.MAIN_HAND);
        }
    }

    private void interactEntities(BlockPos target) {
        AABB ab = this.getEntityRange(target);
        this.f_58857_.m_6249_((Entity)this.fakePlayer.get(), ab, EntitySelector.f_20408_).forEach(entityFound -> {
            if (this.doHitBreak) {
                ((FakePlayer)this.fakePlayer.get()).m_5706_(entityFound);
            } else {
                InteractionResult res = ((FakePlayer)this.fakePlayer.get()).m_36157_(entityFound, InteractionHand.MAIN_HAND);
                if (res.m_19077_()) {
                    ModCyclic.LOGGER.info(this.f_58858_ + "| entity consume result detected " + res);
                }
            }
        });
    }

    private AABB getEntityRange(BlockPos target) {
        boolean r = true;
        AABB ab = new AABB((double)(target.m_123341_() + 1), (double)target.m_123342_(), (double)(target.m_123343_() + 1), (double)(target.m_123341_() - 1), (double)(target.m_123342_() + 1), (double)(target.m_123343_() - 1));
        return ab;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TIMERDEL: {
                this.timerDelay = value;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case INTERACTTYPE: {
                this.doHitBreak = value == 1;
                break;
            }
            case ENTITIES: {
                this.entities = value == 1;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case TIMERDEL: {
                return this.timerDelay;
            }
            case RENDER: {
                return this.render;
            }
            case INTERACTTYPE: {
                return this.doHitBreak ? 1 : 0;
            }
            case ENTITIES: {
                return this.entities ? 1 : 0;
            }
        }
        return 0;
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.timerDelay = tag.m_128451_("delay");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.userSlots.deserializeNBT(tag.m_128469_("inv"));
        this.doHitBreak = tag.m_128471_("doBreakBlock");
        this.entities = tag.m_128471_("entities");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("delay", this.timerDelay);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.userSlots.serializeNBT());
        tag.m_128379_("doBreakBlock", this.doHitBreak);
        tag.m_128379_("entities", this.entities);
        super.m_183515_(tag);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.USER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerUser(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int[] m_7071_(Direction direction) {
        return this.inventory.getSlotsForFace(direction);
    }

    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return this.inventory.canPlaceItemThroughFace(i, itemStack, direction);
    }

    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return this.inventory.canTakeItemThroughFace(i, itemStack, direction);
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        TIMERDEL,
        RENDER,
        INTERACTTYPE,
        ENTITIES;

    }
}

