/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.crusher.RecipeCrusher;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.library.gui.EnergyBar;
import com.lothrazar.library.util.ChatUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CrusherRecipeCategory
implements IRecipeCategory<RecipeCrusher> {
    private static final int FONT = -1;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "crusher");
    static final RecipeType<RecipeCrusher> TYPE = new RecipeType(ID, RecipeCrusher.class);
    private IDrawable gui;
    private IDrawable icon;
    private Font font;
    private EnergyBar bar;

    public CrusherRecipeCategory(IGuiHelper helper) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/crusher.png"), 0, 0, 155, 49).setTextureSize(155, 49).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.CRUSHER.get()));
        this.bar = new EnergyBar(this.font, 64000);
        this.bar.setHeight(48);
        this.bar.guiLeft = -16;
        this.bar.guiTop = -8;
    }

    public Component getTitle() {
        return ChatUtil.ilang((String)((Block)BlockRegistry.CRUSHER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public RecipeType<RecipeCrusher> getRecipeType() {
        return TYPE;
    }

    public void draw(RecipeCrusher recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics ms, double mouseX, double mouseY) {
        int x = 78;
        if (recipe.energy.getTicks() < 40) {
            ms.m_280488_(this.font, recipe.energy.getTicks() + " t", x, 6, -1);
        } else {
            int sec = recipe.energy.getTicks() / 20;
            ms.m_280488_(this.font, sec + " s", x, 6, -1);
        }
        ms.m_280488_(this.font, recipe.energy.getRfPertick() + " RF/t", x, 16, -1);
        if (!recipe.randOutput.bonus.m_41619_() && recipe.randOutput.percent > 0) {
            ms.m_280488_(this.font, recipe.randOutput.percent + "%", 56, 36, -1);
        }
        this.bar.draw(ms, (float)recipe.energy.getEnergyTotal());
        this.bar.renderHoveredToolTip(ms, (int)mouseX, (int)mouseY, recipe.energy.getEnergyTotal());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeCrusher recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 14).addIngredients(recipe.at(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 35, 6).addItemStack(recipe.result);
        if (!recipe.randOutput.bonus.m_41619_() && recipe.randOutput.percent > 0) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 34, 31).addItemStack(recipe.randOutput.bonus);
        }
    }
}

