/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.util.GrowthUtil;
import com.lothrazar.library.enchant.EnchantmentFlib;
import com.lothrazar.library.util.ItemStackUtil;
import com.lothrazar.library.util.ShapeUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowthEnchant
extends EnchantmentFlib {
    public static final String ID = "growth";
    public static ForgeConfigSpec.BooleanValue CFG;
    public static ForgeConfigSpec.BooleanValue PLAYER_ONLY;
    public static ForgeConfigSpec.IntValue RADIUS_FACTOR;
    public static ForgeConfigSpec.IntValue LIMIT_FACTOR;
    public static ForgeConfigSpec.IntValue HEIGHT;
    public static ForgeConfigSpec.IntValue ODDS;

    public GrowthEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack) && stack.m_41720_() instanceof HoeItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 3;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        Level level;
        Player player;
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player ? (player = (Player)entity).m_5833_() || !player.m_6084_() : (Boolean)PLAYER_ONLY.get() != false) {
            return;
        }
        int level2 = this.getCurrentLevelTool(entity.m_21120_(InteractionHand.MAIN_HAND));
        if (level2 > 0 && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)level;
            int growthLimit = level2 * (Integer)LIMIT_FACTOR.get() + (entity.m_9236_().m_46471_() ? 4 : 0);
            int radius = 1 + level2 * (Integer)RADIUS_FACTOR.get();
            double odds = (double)((Integer)ODDS.get()).intValue() / 100.0;
            int grown = 0;
            List shape = ShapeUtil.squareHorizontalFull((BlockPos)entity.m_20183_().m_7495_(), (int)radius);
            shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)((Integer)HEIGHT.get()));
            Collections.shuffle(shape);
            for (int i = 0; i < shape.size() && grown < growthLimit; ++i) {
                if (!GrowthUtil.tryGrow(sw, (BlockPos)shape.get(i), odds)) continue;
                ++grown;
            }
            if (grown > 0) {
                ItemStackUtil.damageItem((LivingEntity)entity, (ItemStack)entity.m_21120_(InteractionHand.MAIN_HAND));
            }
        }
    }
}

