/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.util.ChatUtil;
import com.lothrazar.library.util.ItemStackUtil;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.ShapeUtil;
import com.lothrazar.library.util.TagDataUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;

public class OreProspector
extends ItemBaseCyclic {
    private static final int CD = 10;
    private static final String ORESIZE = "oresize";
    private static final String NBT_DIM = "dim";
    public static ForgeConfigSpec.IntValue RANGE;
    public static ForgeConfigSpec.IntValue HEIGHT;

    public OreProspector(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (player.m_6047_()) {
            ItemStackUtil.deleteTag((ItemStack)itemstack);
            player.m_6674_(handIn);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack held = player.m_21120_(hand);
        if (player.m_36335_().m_41519_(held.m_41720_())) {
            return InteractionResult.PASS;
        }
        player.m_36335_().m_41524_(held.m_41720_(), 10);
        held.m_41751_(null);
        BlockPos pos = context.m_8083_();
        List shape = ShapeUtil.cubeSquareBase((BlockPos)pos.m_7495_(), (int)((Integer)RANGE.get()), (int)((Integer)HEIGHT.get()));
        ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
        Level world = context.m_43725_();
        for (BlockPos p : shape) {
            if (!world.m_8055_(p).m_204336_(Tags.Blocks.ORES)) continue;
            ores.add(p);
        }
        held.m_41784_().m_128359_(NBT_DIM, LevelWorldUtil.dimensionToString((Level)player.m_9236_()));
        int i = 0;
        for (BlockPos p : ores) {
            CompoundTag tag = new CompoundTag();
            TagDataUtil.putBlockPos((CompoundTag)tag, (BlockPos)p);
            held.m_41783_().m_128365_("tag" + i, (Tag)tag);
            ++i;
        }
        held.m_41783_().m_128405_(ORESIZE, i);
        player.m_6674_(hand);
        ItemStackUtil.damageItem((LivingEntity)player, (ItemStack)held);
        ChatUtil.sendStatusMessage((Player)player, (String)("" + i));
        return InteractionResult.SUCCESS;
    }

    public static ItemStack getIfHeld(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof OreProspector) {
            return heldItem;
        }
        heldItem = player.m_21206_();
        if (heldItem.m_41720_() instanceof OreProspector) {
            return heldItem;
        }
        return ItemStack.f_41583_;
    }

    public static ArrayList<BlockPosDim> getPosition(ItemStack item) {
        ArrayList<BlockPosDim> list = new ArrayList<BlockPosDim>();
        if (!item.m_41782_() || !item.m_41783_().m_128441_(ORESIZE)) {
            return list;
        }
        int size = item.m_41783_().m_128451_(ORESIZE);
        String dim = item.m_41783_().m_128461_(NBT_DIM);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = TagDataUtil.getBlockPos((CompoundTag)item.m_41783_().m_128469_("tag" + i));
            list.add(new BlockPosDim(pos, dim, item.m_41783_()));
        }
        return list;
    }
}

