/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.content.items;

import com.portingdeadmods.cable_facades.CFConfig;
import com.portingdeadmods.cable_facades.events.ClientStuff;
import com.portingdeadmods.cable_facades.registries.CFItemTags;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class FacadeItem
extends Item {
    public static final String FACADE_BLOCK = "facade_block";

    public FacadeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        if (!level.m_5776_() && itemStack.m_41782_() && !FacadeUtils.hasFacade((BlockGetter)level, pos)) {
            CompoundTag tag = itemStack.m_41783_();
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_(FACADE_BLOCK)));
            Block targetBlock = context.m_43725_().m_8055_(pos).m_60734_();
            boolean noFacadeTag = context.m_43725_().m_8055_(pos).m_204343_().noneMatch(blockTagKey -> blockTagKey.equals(CFItemTags.SUPPORTS_FACADE));
            if (!CFConfig.isBlockAllowed(targetBlock) && noFacadeTag) {
                return InteractionResult.FAIL;
            }
            if (targetBlock == block || CFConfig.isBlockDisallowed(block)) {
                if (targetBlock == block) {
                    context.m_43723_().m_5661_((Component)Component.m_237113_((String)"Cannot facade block with itself").m_130940_(ChatFormatting.RED), true);
                } else {
                    context.m_43723_().m_5661_((Component)Component.m_237113_((String)"This block cannot be used as a cover (disabled by config)").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            FacadeUtils.addFacade(level, pos, block.m_5573_(new BlockPlaceContext(context)));
            if (!context.m_43723_().m_7500_() && CFConfig.consumeFacade) {
                itemStack.m_41774_(1);
            }
        }
        FacadeUtils.updateBlocks(level, pos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public Component m_7626_(ItemStack itemStack) {
        CompoundTag tag;
        Block block;
        Item item;
        if (itemStack.m_41782_() && (item = (block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation((tag = itemStack.m_41783_()).m_128461_(FACADE_BLOCK)))).m_5456_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return Component.m_237113_((String)("Facade - " + blockItem.m_41466_().getString()));
        }
        return Component.m_237113_((String)"Facade - Empty");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientStuff.FACADE_ITEM_RENDERER;
            }
        });
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && Boolean.TRUE.equals(tag.m_128471_("has_facade_remainder"))) {
            return this.m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack createFacade(Block block) {
        ItemStack facadeStack = new ItemStack((ItemLike)CFItems.FACADE.get());
        CompoundTag nbtData = new CompoundTag();
        nbtData.m_128359_(FACADE_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        facadeStack.m_41751_(nbtData);
        return facadeStack;
    }
}

