/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.events;

import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.data.CableFacadeSavedData;
import com.portingdeadmods.cable_facades.data.helper.ChunkFacadeMap;
import com.portingdeadmods.cable_facades.networking.CFMessages;
import com.portingdeadmods.cable_facades.networking.s2c.AddFacadedBlocksPacket;
import com.portingdeadmods.cable_facades.networking.s2c.RemoveFacadedBlocksPacket;
import com.portingdeadmods.cable_facades.networking.s2c.SyncFacadedBlocks;
import com.portingdeadmods.cable_facades.registries.CFItemTags;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cable_facades")
public final class GameEvents {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().m_9236_();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (!level.m_5776_() && FacadeUtils.hasFacade((BlockGetter)level, pos)) {
            BlockState facade = FacadeUtils.getFacade((BlockGetter)level, pos);
            FacadeUtils.removeFacade(level, pos);
            if (!player.m_7500_()) {
                ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facade.m_60734_());
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)facadeStack);
            }
            event.setCanceled(true);
        }
        FacadeUtils.updateBlocks(level, pos);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        BlockState facadeState = FacadeUtils.getFacade((BlockGetter)level, pos);
        if (player.m_6144_() && player.m_21120_(hand).m_204117_(CFItemTags.WRENCHES) && facadeState != null) {
            if (!level.m_5776_()) {
                FacadeUtils.removeFacade(level, pos);
                if (!player.m_7500_()) {
                    ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facadeState.m_60734_());
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)facadeStack);
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                }
            }
            player.m_6674_(hand);
            GameEvents.updateBlocks(level, pos);
            event.setCanceled(true);
        } else if (player.m_21120_(hand).m_204117_(CFItemTags.WRENCHES) && facadeState != null) {
            if (!level.m_5776_()) {
                if (facadeState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    Direction direction = (Direction)facadeState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                    BlockState newFacadeState = facadeState;
                    if (facadeState.m_61138_((Property)BlockStateProperties.f_61402_) && direction == Direction.WEST) {
                        Half half = (Half)facadeState.m_61143_((Property)BlockStateProperties.f_61402_);
                        newFacadeState = (BlockState)newFacadeState.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(half == Half.BOTTOM ? Half.TOP : Half.BOTTOM));
                    }
                    newFacadeState = (BlockState)newFacadeState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction.m_122427_());
                    FacadeUtils.removeFacade(level, pos);
                    FacadeUtils.addFacade(level, pos, newFacadeState);
                } else if (facadeState.m_61138_((Property)DirectionalBlock.f_52588_)) {
                    Direction direction = (Direction)facadeState.m_61143_((Property)DirectionalBlock.f_52588_);
                    BlockState newFacadeState = (BlockState)facadeState.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)GameEvents.rotate(direction));
                    FacadeUtils.removeFacade(level, pos);
                    FacadeUtils.addFacade(level, pos, newFacadeState);
                } else if (facadeState.m_61138_((Property)BlockStateProperties.f_61397_)) {
                    SlabType slab = (SlabType)facadeState.m_61143_((Property)BlockStateProperties.f_61397_);
                    BlockState newFacadeState = (BlockState)facadeState.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)GameEvents.nextSlab(slab));
                    FacadeUtils.removeFacade(level, pos);
                    FacadeUtils.addFacade(level, pos, newFacadeState);
                }
            }
            player.m_6674_(hand);
            GameEvents.updateBlocks(level, pos);
            event.setCanceled(true);
        }
    }

    public static void updateBlocks(Level level, BlockPos pos) {
        level.m_5518_().m_7174_(pos);
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 3);
        level.m_46672_(pos, state.m_60734_());
    }

    @SubscribeEvent
    public static void loadChunk(ChunkWatchEvent.Watch event) {
        LevelChunk chunk = event.getChunk();
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        ServerLevel serverLevel = event.getLevel();
        ChunkFacadeMap facadeMapForChunk = CableFacadeSavedData.get(serverLevel).getFacadeMapForChunk(chunkPos);
        if (facadeMapForChunk != null) {
            CFMessages.sendToChunk(new AddFacadedBlocksPacket(chunkPos, facadeMapForChunk.getChunkMap()), chunk);
        }
    }

    @SubscribeEvent
    public static void unloadChunk(ChunkWatchEvent.UnWatch event) {
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        CFMessages.sendToPlayer(new RemoveFacadedBlocksPacket(chunkPos), serverPlayer);
    }

    private static Direction rotate(Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> Direction.NORTH;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.NORTH -> Direction.EAST;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.UP -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            default -> direction;
        };
    }

    private static SlabType nextSlab(SlabType slab) {
        return switch (slab) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.BOTTOM -> SlabType.TOP;
            case SlabType.TOP -> SlabType.DOUBLE;
            case SlabType.DOUBLE -> SlabType.BOTTOM;
        };
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer serverPlayer;
        ServerLevel newLevel;
        CableFacadeSavedData savedData;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && !(savedData = CableFacadeSavedData.get(newLevel = (serverPlayer = (ServerPlayer)player).m_284548_())).isEmpty()) {
            CFMessages.sendToPlayer(new SyncFacadedBlocks(savedData.getLevelFacadeMap().getAllFacades()), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer;
        ServerLevel level;
        CableFacadeSavedData savedData;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && !(savedData = CableFacadeSavedData.get(level = (serverPlayer = (ServerPlayer)player).m_284548_())).isEmpty()) {
            CFMessages.sendToPlayer(new SyncFacadedBlocks(savedData.getLevelFacadeMap().getAllFacades()), serverPlayer);
        }
    }
}

