/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.utils;

import com.portingdeadmods.cable_facades.data.CableFacadeSavedData;
import com.portingdeadmods.cable_facades.networking.CFMessages;
import com.portingdeadmods.cable_facades.networking.s2c.AddFacadePacket;
import com.portingdeadmods.cable_facades.networking.s2c.RemoveFacadePacket;
import com.portingdeadmods.cable_facades.utils.ClientFacadeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FacadeUtils {
    public static boolean hasFacade(BlockGetter level, BlockPos pos) {
        return FacadeUtils.getFacade(level, pos) != null;
    }

    @Nullable
    public static BlockState getFacade(BlockGetter level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return CableFacadeSavedData.get(serverLevel).getFacade(pos);
        }
        return ClientFacadeManager.FACADED_BLOCKS.get(pos);
    }

    public static void addFacade(Level level, BlockPos pos, BlockState blockState) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CableFacadeSavedData.get(serverLevel).addFacade(pos, blockState);
        }
        CFMessages.sendToChunk(new AddFacadePacket(pos, blockState), level.m_46745_(pos));
    }

    public static void removeFacade(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CableFacadeSavedData.get(serverLevel).removeFacade(pos);
        }
        CFMessages.sendToChunk(new RemoveFacadePacket(pos), level.m_46745_(pos));
    }

    public static void updateBlocks(Level level, BlockPos pos) {
        if (level.m_46739_(pos)) {
            BlockState state = level.m_8055_(pos);
            level.m_7260_(pos, state, state, 3);
            level.m_46672_(pos, state.m_60734_());
            level.m_5518_().m_7174_(pos);
        }
    }
}

