/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.network.FilterGhostSlotPacket;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ScreenFilter
extends ScreenBase<ContainerFilter> {
    private static final ResourceLocation background = BloodMagic.rl("textures/gui/routingfilter.png");
    public InventoryFilter filterInventory;
    private EditBox textBox;

    public ScreenFilter(ContainerFilter container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.filterInventory = container.inventoryFilter;
        this.f_97726_ = 176;
        this.f_97727_ = 187;
    }

    private void sendButtonClick(int buttonId) {
        Minecraft.m_91087_().f_91072_.m_105208_(((ContainerFilter)this.container).f_38840_, buttonId);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.f_97731_ = this.f_97727_ - 94;
        this.textBox = new EditBox(Minecraft.m_91087_().f_91062_, this.f_97735_ + 23, this.f_97736_ + 19, 70, 12, (Component)Component.m_237113_((String)"itemGroup.search"));
        this.textBox.m_94182_(false);
        this.textBox.m_94199_(50);
        this.textBox.m_94194_(true);
        this.textBox.m_94202_(0xFFFFFF);
        this.textBox.m_94144_("");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.sendButtonClick(0)).m_252794_(this.f_97735_ + 7, this.f_97736_ + 32).m_253046_(20, 20).m_253136_());
        if (((ContainerFilter)this.container).isTag) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.sendButtonClick(1)).m_252794_(this.f_97735_ + 27, this.f_97736_ + 32).m_253046_(20, 20).m_253136_());
        } else if (((ContainerFilter)this.container).isEnchant) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.sendButtonClick(2)).m_252794_(this.f_97735_ + 27, this.f_97736_ + 32).m_253046_(20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)""), button -> this.sendButtonClick(3)).m_252794_(this.f_97735_ + 47, this.f_97736_ + 32).m_253046_(20, 20).m_253136_());
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.textBox.m_94120_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String str;
        if (this.textBox.m_93696_() && (keyCode == 259 || keyCode == 261) && ((ContainerFilter)this.container).getData(0) != -1 && (str = this.textBox.m_94155_()) != null && str.length() > 0) {
            str = str.substring(0, str.length() - 1);
            this.textBox.m_94144_(str);
            int amount = 0;
            if (str.length() > 0) {
                try {
                    Integer testVal = Integer.decode(str);
                    if (testVal != null) {
                        amount = testVal;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.setValueOfGhostItemInSlot(((ContainerFilter)this.container).getData(0), amount);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void setValueOfGhostItemInSlot(int slot, int amount) {
        ItemStack stack = ((ContainerFilter)this.container).m_38853_(slot).m_7993_();
        GhostItemHelper.setItemGhostAmount(stack, amount);
        BloodMagic.packetHandler.sendToServer(new FilterGhostSlotPacket(slot, stack));
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        block8: {
            try {
                Integer charVal = Integer.decode("" + typedChar);
                if (charVal == null) break block8;
                if (this.textBox.m_5534_(typedChar, keyCode)) {
                    if (((ContainerFilter)this.container).getData(0) != -1) {
                        String str = this.textBox.m_94155_();
                        int amount = 0;
                        if (!str.isEmpty()) {
                            try {
                                Integer testVal = Integer.decode(str);
                                if (testVal != null) {
                                    amount = testVal;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        this.setValueOfGhostItemInSlot(((ContainerFilter)this.container).getData(0), amount);
                    }
                    return true;
                }
                return super.m_5534_(typedChar, keyCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.m_5534_(typedChar, keyCode);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean testBool = super.m_6375_(mouseX, mouseY, mouseButton);
        if (((ContainerFilter)this.container).getData(0) != -1) {
            if (this.textBox.m_6375_(mouseX, mouseY, mouseButton)) {
                this.textBox.m_93692_(true);
                return true;
            }
            if (this.textBox.m_5953_(mouseX, mouseY) && mouseButton == 1) {
                this.textBox.m_94144_("");
                this.setValueOfGhostItemInSlot(((ContainerFilter)this.container).getData(0), 0);
                this.textBox.m_93692_(true);
                return true;
            }
        }
        this.textBox.m_93692_(false);
        if (((ContainerFilter)this.container).getData(0) != -1) {
            Slot slot = ((ContainerFilter)this.container).m_38853_(((ContainerFilter)this.container).getData(0));
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount == 0) {
                    this.textBox.m_94144_("");
                } else {
                    this.textBox.m_94144_("" + amount);
                }
            } else {
                this.textBox.m_94144_("");
            }
        }
        return true;
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int bwState = ((ContainerFilter)this.container).getData(1);
        guiGraphics.m_280218_(background, 7, 32, 176, bwState == 0 ? 0 : 20, 20, 20);
        int offset = ((ContainerFilter)this.container).getData(0);
        if (((ContainerFilter)this.container).isTag) {
            int tagState = ((ContainerFilter)this.container).getData(2 + offset);
            guiGraphics.m_280218_(background, 27, 32, 196, tagState == 0 ? 20 : 0, 20, 20);
        }
        if (((ContainerFilter)this.container).isEnchant) {
            int enchantState = ((ContainerFilter)this.container).getData(11 + offset);
            int enchantButton = enchantState == 0 ? 0 : (enchantState == 1 ? 20 : 40);
            guiGraphics.m_280218_(background, 27, 32, 216, enchantButton, 20, 20);
            int levelState = ((ContainerFilter)this.container).getData(20 + offset);
            guiGraphics.m_280218_(background, 47, 32, 236, levelState == 0 ? 0 : 20, 20, 20);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280218_(background, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int ghostSlot = ((ContainerFilter)this.container).getData(0);
        if (ghostSlot >= 0) {
            guiGraphics.m_280218_(background, 106 + this.f_97735_ + 21 * (ghostSlot % 3), this.f_97736_ + 11 + 21 * (ghostSlot / 3), 0, 187, 24, 24);
        }
    }

    private static Component translate(String name) {
        return Component.m_237115_((String)("filter.bloodmagic." + name));
    }

    private List<Component> getTagText() {
        int index = ((ContainerFilter)this.container).getData(0);
        int buttonState = ((ContainerFilter)this.container).getData(2 + index);
        if (index == -1) {
            return List.of(ScreenFilter.translate("novalidtag"));
        }
        ItemStack ghostStack = ((ContainerFilter)this.container).m_38853_(index).m_7993_();
        if (ghostStack.m_41619_()) {
            return List.of(ScreenFilter.translate("novalidtag"));
        }
        ArrayList<Component> componentList = new ArrayList<Component>();
        if (buttonState == 0) {
            Stream stream = ghostStack.m_204131_();
            ArrayList locations = new ArrayList();
            stream.forEach(a -> locations.add(a.f_203868_()));
            if (!locations.isEmpty()) {
                componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.anytag"));
                for (ResourceLocation rl : locations) {
                    componentList.add((Component)Component.m_237113_((String)rl.toString()));
                }
            } else {
                componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.novalidtag"));
            }
        } else {
            CompoundTag ghostTag = ghostStack.m_41784_();
            String tagname = ghostTag.m_128461_("tag");
            ResourceLocation rl = new ResourceLocation(tagname);
            componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.specifiedtag"));
            componentList.add((Component)Component.m_237113_((String)rl.toString()));
        }
        return componentList;
    }

    private List<Component> getEnchantText() {
        int index = ((ContainerFilter)this.container).getData(0);
        int state = ((ContainerFilter)this.container).getData(11 + index);
        if (index == -1) {
            return List.of(ScreenFilter.translate("noenchant"));
        }
        ItemStack ghostStack = ((ContainerFilter)this.container).m_38853_(index).m_7993_();
        if (ghostStack.m_41619_()) {
            return List.of(ScreenFilter.translate("noenchant"));
        }
        ArrayList<Component> componentList = new ArrayList<Component>();
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)ghostStack);
        if (enchants.isEmpty()) {
            return List.of(ScreenFilter.translate("noenchant"));
        }
        if (state == 0 || state == 1) {
            if (state == 0) {
                componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.anyenchant"));
            } else {
                componentList.add((Component)Component.m_237115_((String)"filter.bloodmagic.allenchant"));
            }
            for (Map.Entry entry : enchants.entrySet()) {
                componentList.add(((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue()));
            }
        } else {
            ArrayList enchantList = new ArrayList(enchants.entrySet());
            Map.Entry selected = (Map.Entry)enchantList.get(state - 2);
            componentList.add(((Enchantment)selected.getKey()).m_44700_(((Integer)selected.getValue()).intValue()));
        }
        return componentList;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.textBox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseY >= this.f_97736_ + 32 && mouseY < this.f_97736_ + 52) {
            if (mouseX >= this.f_97735_ + 7 && mouseX < this.f_97735_ + 27) {
                tooltip.add(ScreenFilter.translate(((ContainerFilter)this.container).getData(1) == 0 ? "whitelist" : "blacklist"));
            }
            if (mouseX >= this.f_97735_ + 27 && mouseX < this.f_97735_ + 47) {
                if (((ContainerFilter)this.container).isTag) {
                    tooltip.addAll(this.getTagText());
                }
                if (((ContainerFilter)this.container).isEnchant) {
                    tooltip.addAll(this.getEnchantText());
                }
            }
            if (((ContainerFilter)this.container).isEnchant && mouseX >= this.f_97735_ + 47 && mouseX < this.f_97735_ + 67) {
                int state = ((ContainerFilter)this.container).getData(20 + ((ContainerFilter)this.container).getData(0));
                tooltip.add(ScreenFilter.translate(state == 0 ? "enchantnotfuzzy" : "enchantfuzzy"));
            }
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

