/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import wayoftime.bloodmagic.common.block.type.SpectralBlockType;
import wayoftime.bloodmagic.common.tile.TileSpectral;

public class BlockSpectral
extends Block
implements EntityBlock {
    public static final EnumProperty<SpectralBlockType> SPECTRAL_STATE = EnumProperty.m_61587_((String)"spectral", SpectralBlockType.class);
    public static final int DECAY_RATE = 100;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public BlockSpectral(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        switch ((SpectralBlockType)((Object)state.m_61143_(SPECTRAL_STATE))) {
            case SOLID: {
                world.m_7731_(pos, (BlockState)state.m_61124_(SPECTRAL_STATE, (Comparable)((Object)SpectralBlockType.LEAKING)), 3);
                world.m_186460_(pos, (Block)this, 100);
                break;
            }
            case LEAKING: {
                BlockEntity tile = world.m_7702_(pos);
                if (!(tile instanceof TileSpectral)) break;
                ((TileSpectral)tile).revertToFluid();
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileSpectral(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(SPECTRAL_STATE, (Comparable)((Object)SpectralBlockType.SOLID));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SPECTRAL_STATE});
    }
}

