/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.container.item;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.inventory.DataFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.IRoutingFilterProvider;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ContainerFilter
extends AbstractContainerMenu {
    public final InventoryFilter inventoryFilter;
    private final int PLAYER_INVENTORY_ROWS = 3;
    private final int PLAYER_INVENTORY_COLUMNS = 9;
    public final Player player;
    public final boolean isTag;
    public final boolean isEnchant;
    private final DataFilter data;
    private int slotsOccupied = 9;

    public ContainerFilter(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory.f_35978_, playerInventory, new InventoryFilter(9), new DataFilter(29){

            @Override
            public void save(int index) {
                BMLog.DEFAULT.info("client says hi. also index {}", index);
            }
        }, buf.readBoolean(), buf.readBoolean());
    }

    public ContainerFilter(int windowId, Player player, Inventory playerInventory, InventoryFilter filterInv, DataFilter data, boolean isTag, boolean isEnchant) {
        super((MenuType)BloodMagicBlocks.FILTER_CONTAINER.get(), windowId);
        this.m_38884_(data);
        this.player = player;
        this.inventoryFilter = filterInv;
        int currentSlotHeldIn = player.m_150109_().f_35977_;
        this.setup(playerInventory, currentSlotHeldIn);
        this.isTag = isTag;
        this.isEnchant = isEnchant;
        this.data = data;
    }

    public void setup(Inventory playerInv, int currentSlotHeldIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotGhostItem((IItemHandler)this.inventoryFilter, j + i * 3, 110 + j * 21, 15 + i * 21));
            }
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.m_38897_(new Slot((Container)playerInv, columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 105 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.m_38897_(new SlotDisabled((Container)playerInv, actionBarIndex, 8 + actionBarIndex * 18, 163));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInv, actionBarIndex, 8 + actionBarIndex * 18, 163));
        }
    }

    public int getData(int index) {
        return this.data.m_6413_(index);
    }

    public boolean m_6366_(Player player, int buttonId) {
        return switch (buttonId) {
            case 0 -> {
                int state = this.data.m_6413_(1);
                this.m_7511_(1, state == 0 ? 1 : 0);
                yield true;
            }
            case 3 -> {
                int slot = this.data.m_6413_(0);
                int state = this.data.m_6413_(20 + slot);
                this.m_7511_(20 + slot, state == 0 ? 1 : 0);
                yield true;
            }
            case 1 -> {
                int slot = this.data.m_6413_(0);
                int state = this.data.m_6413_(2 + slot) + 1;
                ItemStack tagStack = this.inventoryFilter.getStackInSlot(slot);
                if (tagStack.m_41619_()) {
                    yield false;
                }
                ArrayList tagList = new ArrayList();
                tagStack.m_204131_().forEach(tagList::add);
                if (state > tagList.size()) {
                    state = 0;
                }
                CompoundTag tag = tagStack.m_41784_();
                if (state != 0) {
                    tag.m_128359_("tag", ((TagKey)tagList.get(state - 1)).f_203868_().toString());
                } else {
                    tag.m_128473_("tag");
                }
                tagStack.m_41751_(tag);
                this.m_38853_(slot).m_5852_(tagStack);
                this.m_7511_(2 + slot, state);
                yield true;
            }
            case 2 -> {
                int slot = this.data.m_6413_(0);
                int state = this.data.m_6413_(11 + slot) + 1;
                ItemStack enchStack = this.inventoryFilter.getStackInSlot(slot);
                if (enchStack.m_41619_()) {
                    yield false;
                }
                Map enchMap = EnchantmentHelper.m_44831_((ItemStack)enchStack);
                if (state >= enchMap.size() + 2 || enchMap.isEmpty()) {
                    state = 0;
                }
                if (enchMap.size() == 1 && state == 1) {
                    state = 2;
                }
                this.m_7511_(11 + slot, state);
                yield true;
            }
            default -> false;
        };
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = (Slot)this.f_38839_.get(slotId)) instanceof SlotGhostItem) {
            this.m_7511_(0, slot.getSlotIndex());
            if (dragType == 0 || dragType == 1) {
                ItemStack slotStack = slot.m_7993_();
                ItemStack heldStack = this.m_142621_();
                if (dragType == 0) {
                    if (heldStack.m_41619_() && !slotStack.m_41619_()) {
                        return;
                    }
                    if (!heldStack.m_41619_() && slotStack.m_41619_()) {
                        ItemStack copyStack = heldStack.m_41777_();
                        GhostItemHelper.setItemGhostAmount(copyStack, 0);
                        copyStack.m_41764_(1);
                        slot.m_5852_(copyStack);
                    }
                } else {
                    slot.m_5852_(ItemStack.f_41583_);
                }
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public void m_7511_(int p_38855_, int p_38856_) {
        super.m_7511_(p_38855_, p_38856_);
        this.m_38946_();
    }

    public boolean m_6875_(Player entityPlayer) {
        return true;
    }

    public ItemStack m_7648_(Player entityPlayer, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex >= 0 ? itemstack1.m_41720_() instanceof IRoutingFilterProvider && !this.m_38903_(itemstack1, 0, 1, false) : !this.m_38903_(itemstack1, this.slotsOccupied, 36 + this.slotsOccupied, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(entityPlayer, itemstack1);
        }
        return itemstack;
    }

    public class SlotGhostItem
    extends SlotItemHandler {
        public SlotGhostItem(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }
}

