/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.data.loot.packs.VanillaChestLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.fluid.BloodMagicFluids;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.loot.BMTableLootEntry;
import wayoftime.bloodmagic.common.loot.SetLivingUpgrade;
import wayoftime.bloodmagic.common.loot.SetWillFraction;
import wayoftime.bloodmagic.common.loot.SetWillRange;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingUpgrade;

public class GeneratorLootTable
extends LootTableProvider {
    public GeneratorLootTable(PackOutput output) {
        super(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BMBlocks::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(BMLootTables::new, LootContextParamSets.f_81411_)));
    }

    private static class BMBlocks
    extends VanillaBlockLoot {
        private BMBlocks() {
        }

        protected void m_245660_() {
            for (RegistryObject block2 : BloodMagicBlocks.BASICBLOCKS.getEntries()) {
                this.m_245724_((Block)block2.get());
            }
            for (RegistryObject block2 : BloodMagicBlocks.DUNGEONBLOCKS.getEntries()) {
                this.m_245724_((Block)block2.get());
            }
            for (RegistryObject block2 : BloodMagicBlocks.DECORATIVE_SLAB.getEntries()) {
                this.m_246481_((Block)block2.get(), x$0 -> this.m_247233_((Block)x$0));
            }
            for (RegistryObject block2 : BloodMagicBlocks.DECORATIVE_WALL.getEntries()) {
                this.m_245724_((Block)block2.get());
            }
            for (RegistryObject block2 : BloodMagicBlocks.DECORATIVE_GATE.getEntries()) {
                this.m_245724_((Block)block2.get());
            }
            for (RegistryObject block2 : BloodMagicBlocks.DECORATIVE_STAIR.getEntries()) {
                this.m_245724_((Block)block2.get());
            }
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.STEADFAST_DUNGEON_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get());
            this.m_245724_((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CAP.get());
            this.m_245724_((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_CENTER.get());
            this.m_245724_((Block)BloodMagicBlocks.CORROSIVE_DUNGEON_PILLAR_SPECIAL.get());
            this.m_245724_((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CAP.get());
            this.m_245724_((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_CENTER.get());
            this.m_245724_((Block)BloodMagicBlocks.DESTRUCTIVE_DUNGEON_PILLAR_SPECIAL.get());
            this.m_245724_((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CAP.get());
            this.m_245724_((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_CENTER.get());
            this.m_245724_((Block)BloodMagicBlocks.STEADFAST_DUNGEON_PILLAR_SPECIAL.get());
            this.m_245724_((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CAP.get());
            this.m_245724_((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_CENTER.get());
            this.m_245724_((Block)BloodMagicBlocks.VENGEFUL_DUNGEON_PILLAR_SPECIAL.get());
            this.m_245724_((Block)BloodMagicBlocks.BLOOD_ALTAR.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.ALCHEMY_ARRAY.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.BLOOD_LIGHT.get());
            this.m_245724_((Block)BloodMagicBlocks.SOUL_FORGE.get());
            this.m_245724_((Block)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.AIR_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.WATER_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.FIRE_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.EARTH_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.DUSK_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_246125_((Block)BloodMagicBlocks.DAWN_RITUAL_STONE.get(), (ItemLike)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
            this.m_245724_((Block)BloodMagicBlocks.ALCHEMY_TABLE.get());
            this.m_245724_((Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get());
            this.m_245724_((Block)BloodMagicBlocks.DEMON_CRUCIBLE.get());
            this.m_245724_((Block)BloodMagicBlocks.DEMON_CRYSTALLIZER.get());
            this.m_245724_((Block)BloodMagicBlocks.DEMON_PYLON.get());
            this.m_245724_((Block)BloodMagicBlocks.INCENSE_ALTAR.get());
            this.m_246125_((Block)BloodMagicBlocks.NETHER_SOIL.get(), (ItemLike)Blocks.f_50134_);
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.CORROSIVE_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get());
            this.registerDropCrystalsLootTable((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get());
            this.m_245724_((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get());
            this.m_245724_((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get());
            this.m_245724_((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get());
            this.m_245724_((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get());
            this.m_245724_((Block)BloodMagicBlocks.DUNGEON_SPIKE_TRAP.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SPIKES.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SPECIAL_DUNGEON_SEAL.get());
            this.m_245724_((Block)BloodMagicBlocks.TELEPOSER.get());
            this.m_245724_((Block)BloodMagicBlocks.MIMIC.get());
            this.m_245724_((Block)BloodMagicBlocks.ETHEREAL_MIMIC.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SPECTRAL.get());
            this.registerCropDropLootTable((Block)BloodMagicBlocks.GROWING_DOUBT.get(), (Item)BloodMagicItems.GROWING_DOUBT_ITEM.get());
            this.registerCropDropLootTable((Block)BloodMagicBlocks.WEAK_TAU.get(), (Item)BloodMagicItems.WEAK_TAU_ITEM.get());
            this.registerCropDropLootTableWithImmatureSeed((Block)BloodMagicBlocks.STRONG_TAU.get(), (Item)BloodMagicItems.WEAK_TAU_ITEM.get(), (Item)BloodMagicItems.STRONG_TAU_ITEM.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SHAPED_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DEFORESTER_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.VEINMINE_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.FUNGAL_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.AUG_SHAPED_CHARGE.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.DEFORESTER_CHARGE_2.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.VEINMINE_CHARGE_2.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.FUNGAL_CHARGE_2.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.SHAPED_CHARGE_DEEP.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.INVERSION_PILLAR.get());
            this.registerNoDropLootTable((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get());
            this.registerNoDropLootTable((Block)BloodMagicFluids.LIFE_ESSENCE_BLOCK.get());
            this.registerNoDropLootTable((Block)BloodMagicFluids.DOUBT_BLOCK.get());
            this.m_246481_((Block)BloodMagicBlocks.DUNGEON_ORE.get(), block -> this.m_246109_((Block)block, (Item)BloodMagicItems.DEMONITE_RAW.get()));
        }

        private void registerNoDropLootTable(Block block) {
            LootPool.Builder builder = LootPool.m_79043_().name(ForgeRegistries.BLOCKS.getKey((Object)block).toString());
            this.m_247577_(block, LootTable.m_79147_().m_79161_(builder));
        }

        private void registerCropDropLootTable(Block block, Item item) {
            LootTable.Builder builder = LootTable.m_79147_();
            LootItemBlockStatePropertyCondition.Builder ageLootCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7));
            builder = builder.m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)ageLootCondition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))));
            this.m_247577_(block, builder);
        }

        private void registerCropDropLootTableWithImmatureSeed(Block block, Item seed, Item fruit) {
            LootTable.Builder builder = LootTable.m_79147_();
            LootItemBlockStatePropertyCondition.Builder ageLootCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7));
            builder = builder.m_79161_(LootPool.m_79043_().m_79080_(ageLootCondition.m_81807_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)ageLootCondition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fruit))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)ageLootCondition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)fruit).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))));
            this.m_247577_(block, builder);
        }

        private void registerDropCrystalsLootTable(Block block, Item item) {
            LootTable.Builder builder = LootTable.m_79147_();
            for (int i = 0; i < 7; ++i) {
                LootItemBlockStatePropertyCondition.Builder harvestAge = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlockDemonCrystal.AGE, i));
                builder = builder.m_79161_(LootPool.m_79043_().m_79076_(LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(i + 1)))).m_79080_((LootItemCondition.Builder)harvestAge)));
            }
            this.m_247577_(block, builder);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> ForgeRegistries.BLOCKS.getKey(b).m_135827_().equals("bloodmagic")).collect(Collectors.toList());
        }
    }

    private static class BMLootTables
    extends VanillaChestLoot {
        private BMLootTables() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> acceptor) {
            this.generateSimpleDungeonLoot(acceptor);
        }

        private void generateSimpleDungeonLoot(BiConsumer<ResourceLocation, LootTable.Builder> acceptor) {
            LootPool.Builder vanillaDungeon = LootPool.m_79043_().name("vanilla_dungeon").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BMTableLootEntry.builder(BuiltInLootTables.f_78742_).m_79707_(1));
            LootPool.Builder key_pool = LootPool.m_79043_().name("keys").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.DUNGEON_SIMPLE_KEY.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/entrance_chest"), LootTable.m_79147_().m_79161_(key_pool).m_79161_(vanillaDungeon));
            Item[] baseAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (Item)BloodMagicItems.FORTUNE_ANOINTMENT.get(), (Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT.get()};
            Item[] weaponAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT.get(), (Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT.get()};
            LootPool.Builder stronghold_library_pool = LootPool.m_79043_().name("vanilla_library").m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)BMTableLootEntry.builder(BuiltInLootTables.f_78761_).m_79707_(1));
            LootPool.Builder extraLibraryItems = LootPool.m_79043_().name("extra").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            extraLibraryItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(10).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)15.0f, (float)30.0f))));
            extraLibraryItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(5).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)400.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get()).getKey())));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/library"), LootTable.m_79147_().m_79161_(stronghold_library_pool).m_79161_(extraLibraryItems));
            LootPool.Builder potionChest = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42593_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42589_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt -> nbt.m_128359_("Potion", "minecraft:water")))))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42518_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42542_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)30.0f))));
            potionChest = this.addMultipleItemsWithSameParams(potionChest, baseAnointments, 1, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f), new LootItemFunction.Builder[0]);
            LootPool.Builder armory_pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f));
            armory_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(25).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            armory_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(20).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)50.0f))));
            armory_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            armory_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(18).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f))));
            armory_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(8).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.f_42463_, Items.f_42408_, Items.f_42407_, Items.f_42462_}, 4, -3, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)15.0f, (float)25.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.9f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.f_42463_, Items.f_42408_, Items.f_42407_, Items.f_42462_}, 7, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.8f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.f_42471_, Items.f_42469_, Items.f_42468_, Items.f_42470_}, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.2f, (float)0.5f))});
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.f_42471_, Items.f_42469_, Items.f_42470_, Items.f_42468_}, 4, -2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(armory_pool, new Item[]{Items.f_42475_, Items.f_42473_, Items.f_42472_, Items.f_42474_}, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.2f))});
            this.addMultipleItemsWithQualitySameParams(armory_pool, new Item[]{Items.f_42475_, Items.f_42473_, Items.f_42472_, Items.f_42474_}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)25.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)1.0f))});
            LootPool.Builder vanilla_blacksmith_pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(BMTableLootEntry.builder(BuiltInLootTables.f_78743_));
            LootPool.Builder blacksmith_pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f));
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(blacksmith_pool, weaponAnointments, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(25).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(20).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)40.0f))));
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(18).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f))));
            blacksmith_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(8).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(blacksmith_pool, new Item[]{Items.f_42385_, Items.f_42386_, Items.f_42383_, Items.f_42384_, Items.f_42387_}, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)7.0f))});
            this.addMultipleItemsWithQualitySameParams(blacksmith_pool, new Item[]{Items.f_42385_, Items.f_42386_, Items.f_42383_, Items.f_42384_, Items.f_42387_}, 4, -2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(blacksmith_pool, new Item[]{Items.f_42390_, Items.f_42391_, Items.f_42388_, Items.f_42389_, Items.f_42392_}, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.2f))});
            this.addMultipleItemsWithQualitySameParams(blacksmith_pool, new Item[]{Items.f_42390_, Items.f_42391_, Items.f_42388_, Items.f_42389_, Items.f_42392_}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)25.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)0.8f))});
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/potion_ingredients"), LootTable.m_79147_().m_79161_(potionChest).m_79161_(this.addMultipleItemsWithSameParams(LootPool.m_79043_(), baseAnointments, 1, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f), new LootItemFunction.Builder[0])));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/simple_armoury"), LootTable.m_79147_().m_79161_(armory_pool));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/simple_blacksmith"), LootTable.m_79147_().m_79161_(blacksmith_pool).m_79161_(vanilla_blacksmith_pool));
            LootPool.Builder tartaricGemPool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PETTY_GEM.get())).m_79707_(5).m_79078_(SetWillFraction.withRange(UniformGenerator.m_165780_((float)0.5f, (float)0.7f))));
            LootPool.Builder tartaricSoulPool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(5).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)20.0f, (float)50.0f))));
            LootPool.Builder upgradePool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(3).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)300.0f, (float)600.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_HEALTH.get()).getKey())));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/test_gems"), LootTable.m_79147_().m_79161_(tartaricGemPool).m_79161_(tartaricSoulPool).m_79161_(upgradePool));
            LootPool.Builder suppliesPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BMTableLootEntry.builder(BuiltInLootTables.f_78694_).m_79707_(1));
            LootPool.Builder filledTauPool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.TAU_OIL.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/food"), LootTable.m_79147_().m_79161_(suppliesPool).m_79161_(filledTauPool));
            LootPool.Builder farmingToolPool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
            farmingToolPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42386_).m_79707_(20).m_79711_(-3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)0.6f))).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()));
            farmingToolPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42387_).m_79707_(20).m_79711_(-3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.6f, (float)0.8f))).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()));
            farmingToolPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42391_).m_79707_(5).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.2f, (float)0.4f))).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_()));
            farmingToolPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42392_).m_79707_(5).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.6f))).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)30.0f))));
            farmingToolPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42397_).m_79707_(2).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.2f, (float)0.4f))).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f))));
            LootPool.Builder farmAnimalProductPool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            this.addMultipleItemsWithSameParams(farmAnimalProductPool, new Item[]{Items.f_42579_, Items.f_42485_, Items.f_42581_, Items.f_42521_, Items.f_42658_, Items.f_42697_}, 10, (NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)10.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithSameParams(farmAnimalProductPool, new Item[]{Items.f_42402_, Items.f_42454_, Items.f_41870_, Items.f_41938_, Items.f_42649_}, 5, (NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)15.0f), new LootItemFunction.Builder[0]);
            farmAnimalProductPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42655_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            farmAnimalProductPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42648_).m_79707_(2).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            farmAnimalProductPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42656_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/farm_tools"), LootTable.m_79147_().m_79161_(suppliesPool).m_79161_(filledTauPool).m_79161_(farmingToolPool));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/farm_parts"), LootTable.m_79147_().m_79161_(suppliesPool).m_79161_(filledTauPool).m_79161_(farmAnimalProductPool));
            LootPool.Builder basicBastionPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(BMTableLootEntry.builder(BuiltInLootTables.f_78698_));
            LootPool.Builder extraBastionItems = LootPool.m_79043_().name("extra").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            extraBastionItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(10).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)15.0f, (float)30.0f))));
            extraBastionItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(5).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)400.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_PHYSICAL_PROTECT.get()).getKey())));
            extraBastionItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            extraBastionItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41912_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            extraBastionItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42486_).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            LootPool.Builder basicNetherPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(BMTableLootEntry.builder(BuiltInLootTables.f_78760_));
            LootPool.Builder extraNetherItems = LootPool.m_79043_().name("extra").m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(10).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)15.0f, (float)30.0f))));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(5).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)50.0f, (float)200.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_FALL_PROTECT.get()).getKey())));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41912_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f))));
            extraNetherItems.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42585_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/bastion"), LootTable.m_79147_().m_79161_(basicBastionPool).m_79161_(extraBastionItems));
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/nether"), LootTable.m_79147_().m_79161_(basicNetherPool).m_79161_(extraNetherItems));
            LootPool.Builder desertPyramidPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)BMTableLootEntry.builder(BuiltInLootTables.f_78764_).m_79707_(1));
            LootPool.Builder crypt_pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f));
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(crypt_pool, weaponAnointments, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(25).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(20).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)40.0f))));
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(18).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f))));
            crypt_pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(8).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(crypt_pool, new Item[]{Items.f_42385_, Items.f_42386_, Items.f_42383_, Items.f_42384_, Items.f_42387_}, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)7.0f))});
            this.addMultipleItemsWithQualitySameParams(blacksmith_pool, new Item[]{Items.f_42385_, Items.f_42386_, Items.f_42383_, Items.f_42384_, Items.f_42387_}, 4, -2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithSameParams(crypt_pool, new Item[]{Items.f_42390_, Items.f_42391_, Items.f_42388_, Items.f_42389_, Items.f_42392_}, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.1f, (float)0.2f))});
            this.addMultipleItemsWithQualitySameParams(crypt_pool, new Item[]{Items.f_42390_, Items.f_42391_, Items.f_42388_, Items.f_42389_, Items.f_42392_}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)25.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.4f, (float)0.8f))});
            acceptor.accept(BloodMagic.rl("chests/simple_dungeon/crypt"), LootTable.m_79147_().m_79161_(desertPyramidPool).m_79161_(crypt_pool));
            Item[] empoweredAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT_2.get(), (Item)BloodMagicItems.FORTUNE_ANOINTMENT_2.get(), (Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_2.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_2.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT_2.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_2.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_2.get(), (Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT_L.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT_L.get()};
            Item[] empoweredWeaponAnointments = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT_2.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_2.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT_2.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_2.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_2.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT_L.get(), (Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_2.get()};
            Item[] empoweredAnointments3 = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT_3.get(), (Item)BloodMagicItems.FORTUNE_ANOINTMENT_3.get(), (Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_3.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_3.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT_3.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_3.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_3.get(), (Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT_XL.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT_XL.get()};
            Item[] empoweredWeaponAnointments3 = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT_3.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_3.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT_3.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_3.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_3.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT_XL.get(), (Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_3.get()};
            Item[] longAnointments3 = new Item[]{(Item)BloodMagicItems.BOW_POWER_ANOINTMENT_XL.get(), (Item)BloodMagicItems.FORTUNE_ANOINTMENT_XL.get(), (Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_XL.get(), (Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_XL.get(), (Item)BloodMagicItems.LOOTING_ANOINTMENT_XL.get(), (Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_XL.get(), (Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_XL.get(), (Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT_XL.get(), (Item)BloodMagicItems.SMELTING_ANOINTMENT_XL.get()};
            LootPool.Builder decent_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(15).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)20.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(25).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            decent_loot = this.addMultipleItemsWithSameParams(decent_loot, empoweredAnointments, 1, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithQualitySameParams(decent_loot, new Item[]{Items.f_42475_, Items.f_42473_, Items.f_42472_, Items.f_42474_}, 3, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.7f, (float)1.0f))});
            this.addMultipleItemsWithQualitySameParams(decent_loot, new Item[]{Items.f_42471_, Items.f_42469_, Items.f_42468_, Items.f_42470_}, 4, 0, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)39.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.5f, (float)0.8f))});
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get())).m_79707_(4).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get())).m_79707_(3).m_79711_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(8).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)20.0f, (float)50.0f))));
            decent_loot = this.addMultipleItemsWithSameParams(decent_loot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get()}, 2, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            decent_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.SYNTHETIC_POINT.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)12.0f))));
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/decent_loot"), LootTable.m_79147_().m_79161_(decent_loot));
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/great_loot"), LootTable.m_79147_().m_79161_(decent_loot).m_79161_(decent_loot));
            LootPool.Builder enchanting_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_).m_79707_(30).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)24.0f))));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(15).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)10.0f))));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(12).m_79711_(1).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)ConstantValue.m_165692_((float)30.0f)).m_80499_()));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(18).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)22.0f))));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42612_).m_79707_(10).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))));
            this.addMultipleItemsWithQualitySameParams(enchanting_loot, new Item[]{Items.f_42475_, Items.f_42473_, Items.f_42472_, Items.f_42474_, Items.f_42390_, Items.f_42391_, Items.f_42389_, Items.f_42388_}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)25.0f, (float)39.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(enchanting_loot, new Item[]{(Item)BloodMagicItems.SENTIENT_SWORD.get(), (Item)BloodMagicItems.SENTIENT_PICKAXE.get(), (Item)BloodMagicItems.SENTIENT_SCYTHE.get(), (Item)BloodMagicItems.SENTIENT_AXE.get(), (Item)BloodMagicItems.SENTIENT_SHOVEL.get()}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)25.0f, (float)39.0f)).m_80499_()});
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)400.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get()).getKey())));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            enchanting_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithSameParams(enchanting_loot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get()}, 1, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/enchanting_loot"), LootTable.m_79147_().m_79161_(enchanting_loot));
            LootPool.Builder poor_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get())).m_79707_(25).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)15.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.IRON_FRAGMENT.get())).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get())).m_79707_(15).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(3).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42405_).m_79707_(8).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79707_(8).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_).m_79707_(8).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(8).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50686_).m_79707_(20).m_79711_(-1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)12.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(15).m_79711_(-1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)9.0f, (float)15.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(8).m_79711_(-1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)10.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.SULFUR.get())).m_79707_(6).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)7.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.DUNGEON_SIMPLE_KEY.get())).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(3).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            poor_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(5).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/poor_loot"), LootTable.m_79147_().m_79161_(poor_loot));
            LootPool.Builder potions_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.IRON_SAND.get())).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.GOLD_SAND.get())).m_79707_(15).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COAL_SAND.get())).m_79707_(8).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(8).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)14.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42677_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42714_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42648_).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PLANT_OIL.get())).m_79707_(6).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(8).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            this.addMultipleItemsWithQualitySameParams(potions_loot, new Item[]{Items.f_42593_, Items.f_42542_, Items.f_42518_, Items.f_42592_, Items.f_42591_, Items.f_42501_, Items.f_42784_, Items.f_42546_}, 5, -1, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.BASIC_CUTTING_FLUID.get())).m_79707_(6).m_79711_(4));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MUNDANE_POWER_CATALYST.get())).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MUNDANE_LENGTHENING_CATALYST.get())).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COMBINATIONAL_CATALYST.get())).m_79707_(7).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.SIMPLE_CATALYST.get())).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42736_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43584_)));
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/decent_alchemy"), LootTable.m_79147_().m_79161_(potions_loot));
            LootPool.Builder strong_potions_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)6.0f));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.IRON_SAND.get())).m_79707_(10).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.GOLD_SAND.get())).m_79707_(8).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COAL_SAND.get())).m_79707_(3).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)15.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42525_).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42588_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)14.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42677_).m_79707_(2).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42714_).m_79707_(3).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42648_).m_79707_(2).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42586_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151079_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151049_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(8).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MUNDANE_POWER_CATALYST.get())).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MUNDANE_LENGTHENING_CATALYST.get())).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COMBINATIONAL_CATALYST.get())).m_79707_(4).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.AVERAGE_POWER_CATALYST.get())).m_79707_(2).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.AVERAGE_LENGTHENING_CATALYST.get())).m_79707_(2).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRENGTHENED_CATALYST.get())).m_79707_(6).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.AVERAGE_FILLING_AGENT.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.INTERMEDIATE_CUTTING_FLUID.get())).m_79707_(9).m_79711_(4));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42736_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43581_)));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42736_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43623_)));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42736_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43589_)));
            strong_potions_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42736_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)Potions.f_43588_)));
            this.addMultipleItemsWithQualitySameParams(strong_potions_loot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get()}, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/strong_alchemy"), LootTable.m_79147_().m_79161_(strong_potions_loot));
            LootPool.Builder smithy_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(15).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)20.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)12.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(16).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)11.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(20).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)14.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(7).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get())).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.CORRUPTED_DUST.get())).m_79707_(6).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(8).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PRIMITIVE_EXPLOSIVE_CELL.get())).m_79707_(10).m_79711_(5));
            this.addMultipleItemsWithSameParams(smithy_loot, empoweredWeaponAnointments, 3, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f), new LootItemFunction.Builder[0]);
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_).m_79707_(12).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)40.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(14).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f))));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(6).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithQualitySameParams(smithy_loot, new Item[]{Items.f_42385_, Items.f_42386_, Items.f_42383_, Items.f_42384_, Items.f_42387_, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_}, 3, -2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.9f, (float)1.0f))});
            this.addMultipleItemsWithQualitySameParams(smithy_loot, new Item[]{Items.f_42390_, Items.f_42391_, Items.f_42388_, Items.f_42389_, Items.f_42392_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_}, 1, 2, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)25.0f)).m_80499_(), SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.7f, (float)0.9f))});
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)150.0f, (float)225.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_DIGGING.get()).getKey())));
            smithy_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)250.0f, (float)350.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_MELEE_DAMAGE.get()).getKey())));
            this.addMultipleItemsWithQualitySameParams(smithy_loot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get()}, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f), new LootItemFunction.Builder[0]);
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/decent_smithy"), LootTable.m_79147_().m_79161_(smithy_loot));
            LootPool.Builder mines_loot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(15).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)20.0f))));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(25).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            mines_loot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            mines_loot = this.addMultipleItemsWithSameParams(decent_loot, empoweredAnointments, 1, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f), new LootItemFunction.Builder[0]);
            LootPool.Builder mines_key = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.DUNGEON_MINE_ENTRANCE_KEY.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/standard_dungeon/mines_key"), LootTable.m_79147_().m_79161_(mines_loot).m_79161_(mines_key));
            LootPool.Builder fragmentLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
            fragmentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get())).m_79707_(25).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)15.0f, (float)22.0f))));
            fragmentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.IRON_FRAGMENT.get())).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)15.0f))));
            fragmentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get())).m_79707_(15).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)13.0f))));
            fragmentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.NETHERITE_SCRAP_FRAGMENT.get())).m_79707_(3).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            LootPool.Builder miningOreLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(15).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)12.0f, (float)26.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(20).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(16).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)14.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(20).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)16.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(7).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)10.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_79707_(4).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)11.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get())).m_79707_(12).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            this.addMultipleItemsWithQualitySameParams(miningOreLoot, new Item[]{Items.f_42385_, Items.f_42384_}, 4, 1, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)20.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(miningOreLoot, new Item[]{Items.f_42390_, Items.f_42389_}, 3, 3, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(miningOreLoot, new Item[]{Items.f_42395_, Items.f_42394_, Items.f_42396_}, 1, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(miningOreLoot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get()}, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)300.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_DIGGING.get()).getKey())));
            this.addMultipleItemsWithQualitySameParams(miningOreLoot, empoweredWeaponAnointments, 3, 2, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get())).m_79707_(1).m_79711_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            miningOreLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.BLEEDING_EDGE_MUSIC.get())).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/mines/ore_loot"), LootTable.m_79147_().m_79161_(fragmentLoot).m_79161_(miningOreLoot));
            LootPool.Builder minesSmithyLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(10).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)12.0f, (float)26.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(16).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(14).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)14.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(10).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)16.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(6).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42792_).m_79707_(5).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(4).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_SAND.get())).m_79707_(12).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicBlocks.DUNGEON_ORE.get())).m_79707_(8).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            this.addMultipleItemsWithQualitySameParams(minesSmithyLoot, new Item[]{Items.f_42390_, Items.f_42389_, Items.f_42391_, Items.f_42392_, Items.f_42388_}, 3, 3, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(minesSmithyLoot, new Item[]{Items.f_42395_, Items.f_42394_, Items.f_42396_, Items.f_42393_, Items.f_42397_}, 1, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(minesSmithyLoot, new Item[]{Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_}, 1, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)25.0f, (float)35.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(minesSmithyLoot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get()}, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)300.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_ARROW_PROTECT.get()).getKey())));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.LIVING_TOME.get())).m_79707_(4).m_79078_(SetLivingUpgrade.withRange(UniformGenerator.m_165780_((float)200.0f, (float)300.0f), ((LivingUpgrade)LivingArmorRegistrar.UPGRADE_PHYSICAL_PROTECT.get()).getKey())));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(10).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)40.0f, (float)75.0f))));
            this.addMultipleItemsWithQualitySameParams(minesSmithyLoot, empoweredWeaponAnointments3, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f), new LootItemFunction.Builder[0]);
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(10).m_79711_(3).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)25.0f, (float)35.0f)).m_80499_()));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get())).m_79707_(2).m_79711_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PRIMITIVE_EXPLOSIVE_CELL.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PRIMITIVE_CRYSTALLINE_RESONATOR.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.INTERMEDIATE_CUTTING_FLUID.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_EXPLOSIVE_CELL.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.7f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_RESONATOR.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.7f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.ADVANCED_CUTTING_FLUID.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.3f, (float)0.7f))));
            minesSmithyLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.BLEEDING_EDGE_MUSIC.get())).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/mines/smithy_loot"), LootTable.m_79147_().m_79161_(fragmentLoot).m_79161_(minesSmithyLoot));
            LootPool.Builder minesRawLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
            minesRawLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151051_).m_79707_(20).m_79711_(-4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)20.0f))));
            minesRawLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151050_).m_79707_(16).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f))));
            minesRawLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151053_).m_79707_(14).m_79711_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            minesRawLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42419_).m_79707_(3).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            minesRawLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.CORRUPTED_DUST.get())).m_79707_(8).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            LootPool.Builder minesDecentLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_79707_(10).m_79711_(-2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)12.0f, (float)18.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151049_).m_79707_(12).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)17.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42692_).m_79707_(15).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)17.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(8).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)14.0f, (float)20.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42534_).m_79707_(8).m_79711_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)14.0f, (float)20.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(5).m_79711_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get())).m_79707_(10).m_79078_(SetWillRange.withRange(UniformGenerator.m_165780_((float)40.0f, (float)75.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(6).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))));
            this.addMultipleItemsWithSameParams(minesDecentLoot, empoweredAnointments3, 2, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithSameParams(minesDecentLoot, longAnointments3, 2, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithQualitySameParams(minesDecentLoot, new Item[]{(Item)BloodMagicItems.CORROSIVE_CRYSTAL.get(), (Item)BloodMagicItems.RAW_CRYSTAL.get(), (Item)BloodMagicItems.STEADFAST_CRYSTAL.get(), (Item)BloodMagicItems.VENGEFUL_CRYSTAL.get(), (Item)BloodMagicItems.DESTRUCTIVE_CRYSTAL.get()}, 2, 3, (NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithQualitySameParams(minesDecentLoot, new Item[]{Items.f_42395_, Items.f_42394_, Items.f_42396_, Items.f_42393_, Items.f_42397_}, 1, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)40.0f)).m_80499_()});
            this.addMultipleItemsWithQualitySameParams(minesDecentLoot, new Item[]{Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_}, 1, 6, (NumberProvider)ConstantValue.m_165692_((float)1.0f), new LootItemFunction.Builder[]{EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)30.0f, (float)35.0f)).m_80499_()});
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get())).m_79707_(6).m_79711_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_EXPLOSIVE_CELL.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_RESONATOR.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.ADVANCED_CUTTING_FLUID.get())).m_79707_(4).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesDecentLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.BLEEDING_EDGE_MUSIC.get())).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/mines/decent_loot"), LootTable.m_79147_().m_79161_(minesRawLoot).m_79161_(minesDecentLoot));
            LootPool.Builder minesFoodLoot = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            this.addMultipleItemsWithSameParams(minesFoodLoot, new Item[]{Items.f_42579_, Items.f_42485_, Items.f_42581_, Items.f_42521_, Items.f_42658_, Items.f_42697_}, 10, (NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)10.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithSameParams(minesFoodLoot, new Item[]{Items.f_42402_, Items.f_42454_, Items.f_41870_, Items.f_41938_, Items.f_42649_}, 5, (NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)15.0f), new LootItemFunction.Builder[0]);
            this.addMultipleItemsWithSameParams(minesFoodLoot, new Item[]{Items.f_42578_, Items.f_42577_, Items.f_42404_, Items.f_42733_}, 5, (NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)10.0f), new LootItemFunction.Builder[0]);
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42655_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42648_).m_79707_(2).m_79711_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42656_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42583_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)11.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)7.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get())).m_79707_(12).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)11.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get())).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)11.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.PLANT_OIL.get())).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)11.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.ADVANCED_CUTTING_FLUID.get())).m_79707_(3).m_79711_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            minesFoodLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get())).m_79707_(3).m_79711_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))));
            acceptor.accept(BloodMagic.rl("chests/mines/food_loot"), LootTable.m_79147_().m_79161_(fragmentLoot).m_79161_(minesFoodLoot));
            LootPool.Builder mineKeyLoot = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BloodMagicItems.DUNGEON_MINE_KEY.get())).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            acceptor.accept(BloodMagic.rl("chests/mines/mine_key_loot"), LootTable.m_79147_().m_79161_(minesRawLoot).m_79161_(minesDecentLoot).m_79161_(mineKeyLoot));
        }

        private LootPool.Builder addMultipleItemsWithSameParams(LootPool.Builder pool, Item[] items, int basicWeight, NumberProvider basicRange, LootItemFunction.Builder ... functions) {
            return this.addMultipleItemsWithQualitySameParams(pool, items, basicWeight, 0, basicRange, functions);
        }

        private LootPool.Builder addMultipleItemsWithQualitySameParams(LootPool.Builder pool, Item[] items, int basicWeight, int quality, NumberProvider basicRange, LootItemFunction.Builder ... functions) {
            if (basicWeight > 0) {
                for (Item item : items) {
                    LootPoolSingletonContainer.Builder entryBuilder = LootItem.m_79579_((ItemLike)item).m_79707_(basicWeight).m_79711_(quality).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)basicRange));
                    for (LootItemFunction.Builder function : functions) {
                        entryBuilder = entryBuilder.m_79078_(function);
                    }
                    pool = pool.m_79076_((LootPoolEntryContainer.Builder)entryBuilder);
                }
            }
            return pool;
        }
    }
}

