/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class AlchemyTableRecipeBuilder
extends BloodMagicRecipeBuilder<AlchemyTableRecipeBuilder> {
    private final List<Ingredient> input;
    private final ItemStack output;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected AlchemyTableRecipeBuilder(List<Ingredient> input, ItemStack output, int syphon, int ticks, int minimumTier) {
        super(AlchemyTableRecipeBuilder.bmSerializer("alchemytable"));
        this.input = input;
        this.output = output;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static AlchemyTableRecipeBuilder alchemyTable(ItemStack output, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new AlchemyTableRecipeBuilder(inputList, output, syphon, ticks, minimumTier);
    }

    public AlchemyTableRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 6) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected AlchemyTableRecipeResult getResult(ResourceLocation id) {
        return new AlchemyTableRecipeResult(id);
    }

    public class AlchemyTableRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected AlchemyTableRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            if (AlchemyTableRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : AlchemyTableRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.add("output", SerializerHelper.serializeItemStack(AlchemyTableRecipeBuilder.this.output));
            json.addProperty("syphon", (Number)AlchemyTableRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)AlchemyTableRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)AlchemyTableRecipeBuilder.this.minimumTier);
        }
    }
}

