/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.common.item.BMItemTier;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSentientScythe
extends HoeItem
implements IDemonWillWeapon,
IMultiWillTool {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{1.0, 2.0, 3.0, 3.5, 4.0, 4.5, 5.0};
    public static double[] destructiveDamageAdded = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] defaultDigSpeedAdded = new double[]{1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.25};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};
    public static double[] healthBonus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public static double[] vengefulAttackSpeed = new double[]{-3.0, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3};
    public static double[] destructiveAttackSpeed = new double[]{-3.1, -3.1, -3.2, -3.3, -3.3, -3.3, -3.3};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600, 700, 800};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100, 120, 150};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public static double[] movementSpeed = new double[]{0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4};
    public static final double baseAttackDamage = 4.0;
    public static final double baseAttackSpeed = -3.0;
    public static final int durabilityFromMob = 2;
    private static Map<UUID, Boolean> hitMap = new HashMap<UUID, Boolean>();

    public ItemSentientScythe() {
        super((Tier)BMItemTier.SENTIENT, 4, -3.0f, new Item.Properties().m_41503_(520));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BloodMagicTags.CRYSTAL_DEMON) || super.m_6832_(toRepair, repair);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44977_ || enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float value = super.m_8102_(stack, state);
        if (value > 1.0f) {
            return (float)((double)value + this.getDigSpeedOfSword(stack));
        }
        return value;
    }

    public void recalculatePowers(ItemStack stack, Level world, Player player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.setCurrentType(stack, soulsRemaining > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(stack, soulsRemaining);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        double extraDamage = this.getExtraDamage(type, level);
        this.setDrainOfActivatedSword(stack, drain);
        this.setDamageOfActivatedSword(stack, 4.0 + extraDamage);
        this.setStaticDropOfActivatedSword(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedSword(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setAttackSpeedOfSword(stack, level >= 0 ? this.getAttackSpeed(type, level) : -3.0);
        this.setHealthBonusOfSword(stack, level >= 0 ? this.getHealthBonus(type, level) : 0.0);
        this.setSpeedOfSword(stack, level >= 0 ? this.getMovementSpeed(type, level) : 0.0);
        this.setDigSpeedOfSword(stack, level >= 0 ? this.getDigSpeed(type, level) : 0.0);
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return vengefulAttackSpeed[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveAttackSpeed[willBracket];
            }
        }
        return -2.9;
    }

    public double getHealthBonus(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return healthBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getMovementSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return movementSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public double getDigSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            default: 
        }
        return defaultDigSpeedAdded[willBracket];
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity attacker) {
        if (attacker instanceof Player) {
            UUID id = attacker.m_20148_();
            Player attackerPlayer = (Player)attacker;
            this.recalculatePowers(stack, attackerPlayer.m_20193_(), attackerPlayer);
            EnumDemonWillType type = this.getCurrentType(stack);
            double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
            int willBracket = this.getLevel(stack, will);
            this.recalculatePowers(stack, attacker.m_9236_(), attackerPlayer);
            hitMap.put(id, true);
            float f2 = ((Player)attacker).m_36403_(0.5f);
            int attackCount = this.attackEntitiesInAreaExcludingEntity(stack, attackerPlayer, type, willBracket, null, f2);
            if (attackCount > 0) {
                stack.m_41622_(2, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
            hitMap.remove(id);
        }
        return false;
    }

    public int attackEntitiesInAreaExcludingEntity(ItemStack stack, Player attacker, EnumDemonWillType type, int willBracket, LivingEntity attackedEntity, float scale) {
        boolean flag;
        double verticalRange = 2.0;
        double horizontalRange = 2.0;
        double range = 2.0;
        int count = 0;
        AABB aabb = null;
        List list = null;
        if (attackedEntity != null) {
            aabb = attackedEntity.m_20191_().m_82363_(horizontalRange, verticalRange, horizontalRange);
            list = attacker.m_9236_().m_6249_((Entity)attackedEntity, aabb, EntitySelector.f_20402_);
        } else {
            Vec3 eyeVec = attacker.m_20299_(1.0f).m_82549_(attacker.m_20154_().m_82490_(range));
            aabb = new AABB(eyeVec.m_7096_() - horizontalRange, eyeVec.m_7098_() - verticalRange, eyeVec.m_7094_() - horizontalRange, eyeVec.m_7096_() + horizontalRange, eyeVec.m_7098_() + verticalRange, eyeVec.m_7094_() + horizontalRange);
            list = attacker.m_9236_().m_6249_((Entity)attacker, aabb, EntitySelector.f_20402_);
        }
        list = attacker.m_9236_().m_45976_(Entity.class, aabb);
        float f = (float)attacker.m_21133_(Attributes.f_22281_);
        float f2 = scale;
        f *= 0.2f + f2 * f2 * 0.8f;
        f *= f2;
        attacker.m_36334_();
        boolean flag1 = false;
        int i = 0;
        i += EnchantmentHelper.m_44894_((LivingEntity)attacker);
        boolean bl = flag = f2 > 0.9f;
        if (attacker.m_20142_() && flag) {
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12314_, attacker.m_5720_(), 1.0f, 1.0f);
            ++i;
            flag1 = true;
        }
        boolean didHit = false;
        boolean strongAttackHit = false;
        boolean weakAttackHit = false;
        boolean noDamageHit = false;
        for (Entity targetEntity : list) {
            if (targetEntity.equals((Object)attacker) || !targetEntity.m_6097_() || targetEntity.m_7313_((Entity)attacker)) continue;
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
            f1 *= f2;
            if (!(f > 0.0f) && !(f1 > 0.0f)) continue;
            boolean flag2 = flag && attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_() && targetEntity instanceof LivingEntity;
            flag2 = flag2 && !attacker.m_20142_();
            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)attacker, (Entity)targetEntity, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
            boolean bl2 = flag2 = hitResult != null;
            if (flag2) {
                f *= hitResult.getDamageModifier();
            }
            f += f1;
            boolean flag3 = false;
            double d0 = attacker.f_19787_ - attacker.f_19867_;
            float f4 = 0.0f;
            boolean flag4 = false;
            int j = EnchantmentHelper.m_44914_((LivingEntity)attacker);
            if (targetEntity instanceof LivingEntity) {
                f4 = ((LivingEntity)targetEntity).m_21223_();
                if (j > 0 && !targetEntity.m_6060_()) {
                    flag4 = true;
                    targetEntity.m_20254_(1);
                }
            }
            Vec3 vector3d = targetEntity.m_20184_();
            boolean flag5 = targetEntity.m_6469_(targetEntity.m_269291_().m_269075_(attacker), f);
            ++count;
            if (flag5) {
                didHit = true;
                if (i > 0) {
                    if (targetEntity instanceof LivingEntity) {
                        ((LivingEntity)targetEntity).m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                    } else {
                        targetEntity.m_5997_((double)(-Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                    }
                }
                attacker.m_36346_();
                if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                    ((ServerPlayer)targetEntity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                    targetEntity.f_19864_ = false;
                    targetEntity.m_20256_(vector3d);
                }
                if (flag2) {
                    attacker.m_5704_(targetEntity);
                }
                if (!flag2 && !flag3) {
                    if (flag) {
                        strongAttackHit = true;
                    } else {
                        weakAttackHit = true;
                    }
                }
                if (f1 > 0.0f) {
                    attacker.m_5700_(targetEntity);
                }
                attacker.m_21335_(targetEntity);
                if (targetEntity instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)targetEntity), (Entity)attacker);
                }
                EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)targetEntity);
                ItemStack itemstack1 = stack;
                Entity entity = targetEntity;
                if (!attacker.m_9236_().f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                    ItemStack copy = itemstack1.m_41777_();
                    itemstack1.m_41640_((LivingEntity)entity, attacker);
                    if (itemstack1.m_41619_()) {
                        ForgeEventFactory.onPlayerDestroyItem((Player)attacker, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                        attacker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                }
                if (!(targetEntity instanceof LivingEntity)) continue;
                float f5 = f4 - ((LivingEntity)targetEntity).m_21223_();
                attacker.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                if (j > 0) {
                    targetEntity.m_20254_(j * 4);
                }
                if (attacker.m_9236_() instanceof ServerLevel && f5 > 2.0f) {
                    int k = (int)((double)f5 * 0.5);
                    ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                }
                this.applyEffectToEntity(type, willBracket, (LivingEntity)targetEntity, attacker);
                continue;
            }
            noDamageHit = true;
            if (!flag4) continue;
            targetEntity.m_20095_();
        }
        if (didHit) {
            if (flag1) {
                attacker.m_20256_(attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
                attacker.m_6858_(false);
            }
            attacker.m_36399_(0.1f);
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
        }
        if (noDamageHit) {
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12315_, attacker.m_5720_(), 1.0f, 1.0f);
        }
        if (strongAttackHit) {
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12316_, attacker.m_5720_(), 1.0f, 1.0f);
        }
        if (weakAttackHit) {
            attacker.m_9236_().m_6263_((Player)null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12318_, attacker.m_5720_(), 1.0f, 1.0f);
        }
        return count;
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, LivingEntity target, Player attacker) {
        switch (type) {
            case CORROSIVE: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.m_6084_()) break;
                float absorption = attacker.m_6103_();
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19617_, absorptionTime[willBracket], 127, true, false));
                attacker.m_7911_((float)Math.min((double)(absorption + target.m_21233_() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            UUID id = attacker.m_20148_();
            Player attackerPlayer = (Player)attacker;
            if (hitMap.containsKey(id) && hitMap.get(id).booleanValue()) {
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                this.applyEffectToEntity(type, willBracket, target, attackerPlayer);
            } else {
                this.recalculatePowers(stack, attackerPlayer.m_20193_(), attackerPlayer);
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                hitMap.put(id, true);
                stack.m_41622_(2, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                this.attackEntitiesInAreaExcludingEntity(stack, attackerPlayer, type, willBracket, target, 1.0f);
                hitMap.remove(id);
            }
        }
        return true;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.m_128461_("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_("demonWillType", type.toString());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        this.recalculatePowers(player.m_21120_(hand), world, player);
        return super.m_7203_(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    private int getLevel(ItemStack stack, double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.sentientScythe.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.recalculatePowers(stack, player.m_20193_(), player);
        double drain = this.getDrainOfActivatedSword(stack);
        if (drain > 0.0) {
            EnumDemonWillType type = this.getCurrentType(stack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (drain > soulsRemaining) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, drain);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public List<ItemStack> getRandomDemonWillDrop(LivingEntity killedEntity, LivingEntity attackingEntity, ItemStack stack, int looting) {
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.m_20193_().m_46791_() != Difficulty.PEACEFUL && !(killedEntity instanceof Enemy)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof Slime ? 0.67 : 1.0;
        EnumDemonWillType type = this.getCurrentType(stack);
        IDemonWill soul = switch (type) {
            case EnumDemonWillType.CORROSIVE -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_CORROSIVE.get();
            case EnumDemonWillType.DESTRUCTIVE -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_DESTRUCTIVE.get();
            case EnumDemonWillType.STEADFAST -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_STEADFAST.get();
            case EnumDemonWillType.VENGEFUL -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_VENGEFUL.get();
            default -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get();
        };
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.m_20193_().f_46441_.m_188500_() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.m_20193_().f_46441_.m_188500_() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.m_21233_() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.getDamageOfActivatedSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(new UUID(0L, 31818145L), "Weapon modifier", this.getHealthBonusOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(new UUID(0L, 4218052L), "Weapon modifier", this.getSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDamage");
    }

    public void setDamageOfActivatedSword(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDamage", damage);
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDrop", drop);
    }

    public double getHealthBonusOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordHealth");
    }

    public void setHealthBonusOfSword(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordHealth", hp);
    }

    public double getAttackSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordAttackSpeed");
    }

    public void setAttackSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordAttackSpeed", speed);
    }

    public double getSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordSpeed");
    }

    public void setSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordSpeed", speed);
    }

    public double getDigSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDigSpeed");
    }

    public void setDigSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDigSpeed", speed);
    }
}

