/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.common.container.tile.ContainerAlchemyTable;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IAlchemyItem;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.network.AlchemyTableFlagPacket;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class TileAlchemyTable
extends TileInventory
implements WorldlyContainer,
MenuProvider {
    public static final int orbSlot = 6;
    public static final int outputSlot = 7;
    public Direction direction = Direction.NORTH;
    public boolean isSlave = false;
    public int burnTime = 0;
    public int ticksRequired = 1;
    public boolean orbFlag = false;
    public boolean lpFlag = false;
    public BlockPos connectedPos = BlockPos.f_121853_;
    public boolean[] blockedSlots = new boolean[]{false, false, false, false, false, false};
    public boolean[] allowedDirectionsSlot0 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot1 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot2 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot3 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot4 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsSlot5 = new boolean[]{false, false, true, true, true, true};
    public boolean[] allowedDirectionsOrb = new boolean[]{false, true, false, false, false, false};
    public boolean[] allowedDirectionsOutput = new boolean[]{true, false, false, false, false, false};
    public int activeSlot = -1;

    public TileAlchemyTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 8, "alchemytable", pos, state);
    }

    public TileAlchemyTable(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.ALCHEMY_TABLE_TYPE.get(), pos, state);
    }

    public void setInitialTableParameters(Direction direction, boolean isSlave, BlockPos connectedPos) {
        this.isSlave = isSlave;
        this.connectedPos = connectedPos;
        if (!isSlave) {
            this.direction = direction;
        }
    }

    public boolean isInvisible() {
        return this.isSlave();
    }

    public boolean isInputSlotAccessible(int slot) {
        return slot >= 6 || slot < 0 || !this.blockedSlots[slot];
    }

    public void toggleInputSlotAccessible(int slot) {
        if (slot < 6 && slot >= 0) {
            this.blockedSlots[slot] = !this.blockedSlots[slot];
        }
    }

    public boolean isSlotEnabled(int slot, Direction dir) {
        switch (slot) {
            case 0: {
                return this.allowedDirectionsSlot0[dir.ordinal()];
            }
            case 1: {
                return this.allowedDirectionsSlot1[dir.ordinal()];
            }
            case 2: {
                return this.allowedDirectionsSlot2[dir.ordinal()];
            }
            case 3: {
                return this.allowedDirectionsSlot3[dir.ordinal()];
            }
            case 4: {
                return this.allowedDirectionsSlot4[dir.ordinal()];
            }
            case 5: {
                return this.allowedDirectionsSlot5[dir.ordinal()];
            }
            case 6: {
                return this.allowedDirectionsOrb[dir.ordinal()];
            }
            case 7: {
                return this.allowedDirectionsOutput[dir.ordinal()];
            }
        }
        return false;
    }

    public void setSlotEnabled(boolean enabled, int slot, Direction dir) {
        switch (slot) {
            case 0: {
                this.allowedDirectionsSlot0[dir.ordinal()] = enabled;
                break;
            }
            case 1: {
                this.allowedDirectionsSlot1[dir.ordinal()] = enabled;
                break;
            }
            case 2: {
                this.allowedDirectionsSlot2[dir.ordinal()] = enabled;
                break;
            }
            case 3: {
                this.allowedDirectionsSlot3[dir.ordinal()] = enabled;
                break;
            }
            case 4: {
                this.allowedDirectionsSlot4[dir.ordinal()] = enabled;
                break;
            }
            case 5: {
                this.allowedDirectionsSlot5[dir.ordinal()] = enabled;
                break;
            }
            case 6: {
                this.allowedDirectionsOrb[dir.ordinal()] = enabled;
                break;
            }
            case 7: {
                this.allowedDirectionsOutput[dir.ordinal()] = enabled;
            }
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        int i;
        super.deserialize(tag);
        this.isSlave = tag.m_128471_("isSlave");
        this.direction = Direction.m_122376_((int)tag.m_128451_("direction"));
        this.connectedPos = new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
        this.burnTime = tag.m_128451_("burnTime");
        this.ticksRequired = tag.m_128451_("ticksRequired");
        byte[] array = tag.m_128463_("blockedSlots");
        for (i = 0; i < array.length; ++i) {
            this.blockedSlots[i] = array[i] != 0;
        }
        for (i = 0; i <= 7; ++i) {
            byte[] allowedSlotArray = tag.m_128463_("allowedDirections" + i);
            for (int j = 0; j < Math.min(allowedSlotArray.length, Direction.values().length); ++j) {
                this.setSlotEnabled(allowedSlotArray[j] == 1, i, Direction.values()[j]);
            }
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        int i;
        super.serialize(tag);
        tag.m_128379_("isSlave", this.isSlave);
        tag.m_128405_("direction", this.direction.m_122411_());
        tag.m_128405_("xCoord", this.connectedPos.m_123341_());
        tag.m_128405_("yCoord", this.connectedPos.m_123342_());
        tag.m_128405_("zCoord", this.connectedPos.m_123343_());
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("ticksRequired", this.ticksRequired);
        byte[] blockedSlotArray = new byte[this.blockedSlots.length];
        for (i = 0; i < this.blockedSlots.length; ++i) {
            blockedSlotArray[i] = (byte)(this.blockedSlots[i] ? 1 : 0);
        }
        tag.m_128382_("blockedSlots", blockedSlotArray);
        for (i = 0; i <= 7; ++i) {
            byte[] allowedSlotArray = new byte[Direction.values().length];
            for (int j = 0; j < Direction.values().length; ++j) {
                allowedSlotArray[j] = (byte)(this.isSlotEnabled(i, Direction.values()[j]) ? 1 : 0);
            }
            tag.m_128382_("allowedDirections" + i, allowedSlotArray);
        }
        return tag;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (this.isSlave()) {
                BlockEntity tile = this.m_58904_().m_7702_(this.connectedPos);
                if (tile instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
                    return tile.getCapability(capability, facing);
                }
            } else {
                return super.getCapability(capability, facing);
            }
        }
        return super.getCapability(capability, facing);
    }

    public int[] m_7071_(Direction side) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (int i = 0; i <= 7; ++i) {
            if (!this.isSlotEnabled(i, side)) continue;
            integerList.add(i);
        }
        int[] intArray = new int[integerList.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (Integer)integerList.get(i);
        }
        return intArray;
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        switch (index) {
            case 7: {
                return false;
            }
            case 6: {
                return !stack.m_41619_() && stack.m_41720_() instanceof IBloodOrb;
            }
        }
        return this.isSlotEnabled(index, direction);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        switch (direction) {
            default: 
        }
        return this.isSlotEnabled(index, direction);
    }

    public List<Integer> getAccessibleInputSlots(Direction direction) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            if (!this.isInputSlotAccessible(i)) continue;
            list.add(i);
        }
        return list;
    }

    public void tick() {
        if (this.isSlave()) {
            return;
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        ItemStack flaskStack = ItemStack.f_41583_;
        int flaskIndex = 0;
        int j = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            ItemStack slotStack = this.m_8020_(i);
            inputList.add(slotStack);
            if (slotStack.m_41720_() instanceof ItemAlchemyFlask && flaskStack.m_41619_()) {
                flaskStack = slotStack;
                flaskIndex = j;
            }
            ++j;
        }
        int tier = this.getTierOfOrb();
        RecipeAlchemyTable recipeAlchemyTable = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTable(this.f_58857_, inputList);
        if (recipeAlchemyTable != null && (this.burnTime > 0 || !this.m_58904_().f_46443_ && tier >= recipeAlchemyTable.getMinimumTier() && this.getContainedLp() >= recipeAlchemyTable.getSyphon())) {
            this.lpFlag = false;
            this.orbFlag = false;
            if (this.burnTime == 1) {
                this.notifyUpdate();
            }
            if (this.canCraft(recipeAlchemyTable.getOutput(inputList))) {
                this.ticksRequired = recipeAlchemyTable.getTicks();
                ++this.burnTime;
                if (this.burnTime >= this.ticksRequired && !this.m_58904_().f_46443_) {
                    if (recipeAlchemyTable.getSyphon() > 0 && this.consumeLp(recipeAlchemyTable.getSyphon()) < recipeAlchemyTable.getSyphon()) {
                        this.burnTime = 0;
                        this.notifyUpdate();
                        return;
                    }
                    ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                    for (ItemStack stack : inputList) {
                        inputs.add(stack.m_41777_());
                    }
                    BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(recipeAlchemyTable.getOutput(inputList).m_41777_(), (ItemStack[])inputs.toArray(ItemStack[]::new));
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    ItemStack outputSlotStack = this.m_8020_(7);
                    if (outputSlotStack.m_41619_()) {
                        this.m_6836_(7, event.getOutput());
                    } else {
                        outputSlotStack.m_41769_(event.getOutput().m_41613_());
                    }
                    this.consumeInventory(recipeAlchemyTable);
                    this.burnTime = 0;
                    this.notifyUpdate();
                }
            }
            return;
        }
        if (!flaskStack.m_41619_()) {
            List<EffectHolder> holderList = ((ItemAlchemyFlask)flaskStack.m_41720_()).getEffectHoldersOfFlask(flaskStack);
            inputList.remove(flaskIndex);
            RecipePotionFlaskBase recipePotionFlask = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getPotionFlaskRecipe(this.f_58857_, flaskStack, holderList, inputList);
            if (recipePotionFlask != null && (this.burnTime > 0 || !this.m_58904_().f_46443_ && tier >= recipePotionFlask.getMinimumTier() && this.getContainedLp() >= recipePotionFlask.getSyphon())) {
                this.lpFlag = false;
                this.orbFlag = false;
                if (this.burnTime == 1) {
                    this.notifyUpdate();
                }
                if (this.m_8020_(7).m_41619_()) {
                    this.ticksRequired = recipePotionFlask.getTicks();
                    ++this.burnTime;
                    if (this.burnTime >= this.ticksRequired && !this.m_58904_().f_46443_) {
                        if (recipePotionFlask.getSyphon() > 0 && this.consumeLp(recipePotionFlask.getSyphon()) < recipePotionFlask.getSyphon()) {
                            this.burnTime = 0;
                            this.notifyUpdate();
                            return;
                        }
                        ItemStack outputStack = recipePotionFlask.getOutput(flaskStack, holderList);
                        if (outputStack.m_41720_() instanceof ItemAlchemyFlask) {
                            ((ItemAlchemyFlask)outputStack.m_41720_()).resyncEffectInstances(outputStack);
                        }
                        this.m_6836_(7, outputStack);
                        this.consumeInventory(recipePotionFlask);
                        this.burnTime = 0;
                        this.notifyUpdate();
                    }
                }
                return;
            }
        }
        this.burnTime = 0;
        if (!this.f_58857_.f_46443_) {
            boolean oldOrbFlag = this.orbFlag;
            boolean oldLPFlag = this.lpFlag;
            if (recipeAlchemyTable != null) {
                this.orbFlag = tier < recipeAlchemyTable.getMinimumTier();
                this.lpFlag = !this.orbFlag && this.getContainedLp() < recipeAlchemyTable.getSyphon();
            } else {
                this.lpFlag = false;
                this.orbFlag = false;
            }
            if (this.orbFlag != oldOrbFlag || this.lpFlag != oldLPFlag) {
                BloodMagic.packetHandler.sendToAllTracking(new AlchemyTableFlagPacket(this), this);
            }
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / (double)this.ticksRequired;
    }

    public boolean getOrbFlagForGui() {
        return this.orbFlag;
    }

    public boolean getLPFlagforGui() {
        return this.lpFlag;
    }

    public void setOrbFlagForGui(boolean orbFlag) {
        this.orbFlag = orbFlag;
    }

    public void setLPFlagForGui(boolean lpFlag) {
        this.lpFlag = lpFlag;
    }

    private boolean canCraft(ItemStack output) {
        ItemStack currentOutputStack = this.m_8020_(7);
        if (output.m_41619_()) {
            return false;
        }
        if (currentOutputStack.m_41619_()) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)currentOutputStack)) {
            return false;
        }
        int result = currentOutputStack.m_41613_() + output.m_41613_();
        return result <= this.m_6893_() && result <= currentOutputStack.m_41741_();
    }

    public int getTierOfOrb() {
        ItemStack orbStack = this.m_8020_(6);
        if (!orbStack.m_41619_() && orbStack.m_41720_() instanceof IBloodOrb) {
            BloodOrb orb = ((IBloodOrb)orbStack.m_41720_()).getOrb(orbStack);
            return orb == null ? 0 : orb.getTier();
        }
        return 0;
    }

    public int getContainedLp() {
        ItemStack orbStack = this.m_8020_(6);
        if (!orbStack.m_41619_() && orbStack.m_41720_() instanceof IBloodOrb) {
            Binding binding = ((IBindable)orbStack.m_41720_()).getBinding(orbStack);
            if (binding == null) {
                return 0;
            }
            SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
            return network.getCurrentEssence();
        }
        return 0;
    }

    public void craftItem(List<ItemStack> inputList, RecipeAlchemyTable recipe) {
        ItemStack outputStack = recipe.getOutput(inputList);
        if (this.canCraft(outputStack)) {
            ItemStack currentOutputStack = this.m_8020_(7);
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (ItemStack stack : inputList) {
                inputs.add(stack.m_41777_());
            }
            BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(outputStack.m_41777_(), (ItemStack[])inputs.toArray(ItemStack[]::new));
            MinecraftForge.EVENT_BUS.post((Event)event);
            outputStack = event.getOutput();
            if (currentOutputStack.m_41619_()) {
                this.m_6836_(7, outputStack);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)currentOutputStack)) {
                currentOutputStack.m_41769_(outputStack.m_41613_());
            }
            this.consumeInventory(recipe);
        }
    }

    public int consumeLp(int requested) {
        ItemStack orbStack = this.m_8020_(6);
        if (!orbStack.m_41619_() && orbStack.m_41720_() instanceof IBloodOrb && NetworkHelper.syphonFromContainer(orbStack, SoulTicket.item(orbStack, this.f_58857_, this.f_58858_, requested))) {
            return requested;
        }
        return 0;
    }

    public void consumeInventory(RecipeAlchemyTable recipe) {
        for (int i = 0; i < 6; ++i) {
            ItemStack inputStack = this.m_8020_(i);
            if (inputStack.m_41619_()) continue;
            if (inputStack.m_41720_() instanceof IAlchemyItem) {
                if (!((IAlchemyItem)inputStack.m_41720_()).isStackChangedOnUse(inputStack)) continue;
                this.m_6836_(i, ((IAlchemyItem)inputStack.m_41720_()).onConsumeInput(inputStack));
                continue;
            }
            if (inputStack.m_41720_().hasCraftingRemainingItem(inputStack)) {
                this.m_6836_(i, inputStack.m_41720_().getCraftingRemainingItem(inputStack));
                continue;
            }
            if (inputStack.m_41776_() > 0) {
                if (!inputStack.m_41763_() || !inputStack.m_220157_(1, this.f_58857_.f_46441_, null)) continue;
                this.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            inputStack.m_41774_(1);
            if (!inputStack.m_41619_()) continue;
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void consumeInventory(RecipePotionFlaskBase recipe) {
        for (int i = 0; i < 6; ++i) {
            ItemStack inputStack = this.m_8020_(i);
            if (inputStack.m_41619_()) continue;
            if (inputStack.m_41720_() instanceof IAlchemyItem) {
                if (!((IAlchemyItem)inputStack.m_41720_()).isStackChangedOnUse(inputStack)) continue;
                this.m_6836_(i, ((IAlchemyItem)inputStack.m_41720_()).onConsumeInput(inputStack));
                continue;
            }
            if (inputStack.m_41720_().hasCraftingRemainingItem(inputStack)) {
                this.m_6836_(i, inputStack.m_41720_().getCraftingRemainingItem(inputStack));
                continue;
            }
            inputStack.m_41774_(1);
            if (!inputStack.m_41619_()) continue;
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public BlockPos getConnectedPos() {
        return this.connectedPos;
    }

    public boolean[] getBlockedSlots() {
        return this.blockedSlots;
    }

    public static int getOrbSlot() {
        return 6;
    }

    public static int getOutputSlot() {
        return 7;
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerAlchemyTable(this, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Alchemy Table");
    }
}

