/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.altar.AltarComponent;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.ComponentType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;

public class RegisterPatchouliMultiblocks {
    private int maxX;
    private int minX;
    private int maxY;
    private int minY;
    private int maxZ;
    private int minZ;

    public RegisterPatchouliMultiblocks() {
        PatchouliAPI.IPatchouliAPI patAPI = PatchouliAPI.get();
        BloodMagicAPI bmAPI = BloodMagicAPI.INSTANCE;
        List<Ritual> rituals = BloodMagic.RITUAL_MANAGER.getSortedRituals();
        for (Ritual ritual : rituals) {
            String ritualID = BloodMagic.RITUAL_MANAGER.getId(ritual);
            HashMap ritualMap = Maps.newHashMap();
            ArrayList components = Lists.newArrayList();
            ritual.gatherComponents(components::add);
            this.resetMinMaxValues();
            for (RitualComponent component : components) {
                ritualMap.put(component.getOffset(), component.getRuneType());
                this.checkAndSetMinMaxValues(component.getX(Direction.NORTH), component.getY(), component.getZ(Direction.NORTH));
            }
            String[][] pattern = this.makePattern(ritualMap, Collections.emptyMap());
            if (ritualID.equals("downgrade")) {
                pattern[2][3] = "_FDC______";
            }
            IMultiblock multiblock = patAPI.makeMultiblock(pattern, new Object[]{Character.valueOf('0'), BloodMagicBlocks.MASTER_RITUAL_STONE.get(), Character.valueOf('B'), BloodMagicBlocks.BLANK_RITUAL_STONE.get(), Character.valueOf('W'), BloodMagicBlocks.WATER_RITUAL_STONE.get(), Character.valueOf('F'), BloodMagicBlocks.FIRE_RITUAL_STONE.get(), Character.valueOf('E'), BloodMagicBlocks.EARTH_RITUAL_STONE.get(), Character.valueOf('A'), BloodMagicBlocks.AIR_RITUAL_STONE.get(), Character.valueOf('D'), BloodMagicBlocks.DUSK_RITUAL_STONE.get(), Character.valueOf('d'), BloodMagicBlocks.DAWN_RITUAL_STONE.get(), Character.valueOf('C'), Blocks.f_50087_});
            patAPI.registerMultiblock(new ResourceLocation("bloodmagic", ritualID), multiblock);
        }
        for (AltarTier tier : AltarTier.values()) {
            String[][] pattern;
            int shiftMultiblock = 1;
            if (tier.equals((Object)AltarTier.ONE)) {
                pattern = new String[][]{{"0"}, {"_"}};
                shiftMultiblock = 0;
            } else if (tier.equals((Object)AltarTier.TWO)) {
                pattern = new String[][]{{"___", "_0_", "___"}, {"rRr", "R_R", "rRr"}};
            } else {
                HashMap altarMap = Maps.newHashMap();
                List<AltarComponent> components = tier.getAltarComponents();
                this.resetMinMaxValues();
                for (AltarComponent component : components) {
                    BlockPos offset = component.getOffset();
                    altarMap.put(offset, component.getComponent());
                    this.checkAndSetMinMaxValues(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
                }
                pattern = this.makePattern(Collections.emptyMap(), altarMap);
            }
            BMStateMatcher bloodRuneSM = new BMStateMatcher(bmAPI.getComponentStates(ComponentType.BLOODRUNE));
            BMStateMatcher blankBloodRuneSM = new BMStateMatcher((Block)BloodMagicBlocks.BLANK_RUNE.get(), bmAPI.getComponentStates(ComponentType.BLOODRUNE));
            IStateMatcher notAirSM = patAPI.predicateMatcher(Blocks.f_50222_, state -> !state.m_60795_() && !state.m_278721_());
            BMStateMatcher glowstoneSM = new BMStateMatcher(bmAPI.getComponentStates(ComponentType.GLOWSTONE));
            BMStateMatcher bloodStoneSM = new BMStateMatcher(bmAPI.getComponentStates(ComponentType.BLOODSTONE));
            BMStateMatcher beaconSM = new BMStateMatcher(bmAPI.getComponentStates(ComponentType.BEACON));
            BMStateMatcher crystalSM = new BMStateMatcher(bmAPI.getComponentStates(ComponentType.CRYSTAL));
            IMultiblock multiblock = patAPI.makeMultiblock(pattern, new Object[]{Character.valueOf('R'), bloodRuneSM, Character.valueOf('P'), notAirSM, Character.valueOf('G'), glowstoneSM, Character.valueOf('S'), bloodStoneSM, Character.valueOf('B'), beaconSM, Character.valueOf('C'), crystalSM, Character.valueOf('r'), blankBloodRuneSM, Character.valueOf('0'), BloodMagicBlocks.BLOOD_ALTAR.get()});
            multiblock.offset(0, shiftMultiblock, 0);
            patAPI.registerMultiblock(new ResourceLocation("bloodmagic", "altar_" + tier.name().toLowerCase(Locale.ROOT)), multiblock);
        }
    }

    private void resetMinMaxValues() {
        this.minZ = 0;
        this.maxZ = 0;
        this.minY = 0;
        this.maxY = 0;
        this.minX = 0;
        this.maxX = 0;
    }

    private void checkAndSetMinMaxValues(int x, int y, int z) {
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (x < this.minX) {
            this.minX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
    }

    private String[][] makePattern(Map<BlockPos, EnumRuneType> ritualMap, Map<BlockPos, ComponentType> altarMap) {
        String[][] pattern = new String[1 + this.maxY - this.minY][1 + this.maxX - this.minX];
        for (int y = this.maxY; y >= this.minY; --y) {
            for (int x = this.minX; x <= this.maxX; ++x) {
                StringBuilder row = new StringBuilder();
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    String name;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!ritualMap.isEmpty()) {
                        EnumRuneType rune = ritualMap.get(pos);
                        if (rune != null) {
                            switch (name = rune.name()) {
                                case "BLANK": {
                                    row.append('B');
                                    break;
                                }
                                case "WATER": {
                                    row.append('W');
                                    break;
                                }
                                case "FIRE": {
                                    row.append('F');
                                    break;
                                }
                                case "EARTH": {
                                    row.append('E');
                                    break;
                                }
                                case "AIR": {
                                    row.append('A');
                                    break;
                                }
                                case "DUSK": {
                                    row.append('D');
                                    break;
                                }
                                case "DAWN": {
                                    row.append('d');
                                    break;
                                }
                            }
                            continue;
                        }
                        row.append(this.checkEmptySpace(x, y, z));
                        continue;
                    }
                    if (altarMap.isEmpty()) continue;
                    ComponentType component = altarMap.get(pos);
                    if (component != null) {
                        switch (name = component.name()) {
                            case "BLOODRUNE": {
                                row.append('R');
                                break;
                            }
                            case "NOTAIR": {
                                row.append('P');
                                break;
                            }
                            case "GLOWSTONE": {
                                row.append('G');
                                break;
                            }
                            case "BLOODSTONE": {
                                row.append('S');
                                break;
                            }
                            case "BEACON": {
                                row.append('B');
                                break;
                            }
                            case "CRYSTAL": {
                                row.append('C');
                                break;
                            }
                        }
                        continue;
                    }
                    row.append(this.checkEmptySpace(x, y, z));
                }
                pattern[this.maxY - y][x - this.minX] = row.toString();
            }
        }
        return pattern;
    }

    private Character checkEmptySpace(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return Character.valueOf('0');
        }
        return Character.valueOf('_');
    }

    private void stringDumper(String[][] pattern) {
        System.out.println("Dev Test: Multiblock String Dumper");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length; ++j) {
                System.out.println(String.format("pattern[%d][%d] = \"%s\";", i, j, pattern[i][j]));
            }
            System.out.println("");
        }
    }

    private class BMStateMatcher
    implements IStateMatcher {
        private final List<BlockState> render;
        private final List<BlockState> valid;

        private BMStateMatcher(Block singleBlockRender, List<BlockState> valid) {
            ArrayList render = Lists.newArrayList();
            render.add(singleBlockRender.m_49966_());
            this.render = render;
            this.valid = valid;
        }

        private BMStateMatcher(List<BlockState> renderAndValid) {
            this.render = renderAndValid;
            this.valid = renderAndValid;
        }

        public BlockState getDisplayedState(long ticks) {
            if (this.render.isEmpty()) {
                return Blocks.f_50752_.m_49966_();
            }
            int idx = (int)(ticks / 20L % (long)this.render.size());
            return this.render.get(idx);
        }

        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.valid.contains(s);
        }
    }
}

