/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class LivingStats {
    protected final Map<LivingUpgrade, Double> upgrades;
    protected Supplier<Integer> maxPoints;
    protected boolean evolved = false;

    public LivingStats(Map<LivingUpgrade, Double> upgrades) {
        this.upgrades = upgrades;
        this.maxPoints = ConfigManager.COMMON.defaultUpgradePoints;
    }

    public LivingStats() {
        this(Maps.newHashMap());
    }

    public Map<LivingUpgrade, Double> getUpgrades() {
        return ImmutableMap.copyOf(this.upgrades);
    }

    public LivingStats addExperience(ResourceLocation key, double experience) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        double current = this.upgrades.getOrDefault(upgrade, 0.0);
        if (experience > 0.0 && upgrade.getNextRequirement((int)current) == 0) {
            return this;
        }
        this.upgrades.put(upgrade, current + experience);
        return this;
    }

    public LivingStats resetExperience(ResourceLocation key) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        if (!this.upgrades.containsKey(upgrade)) {
            return this;
        }
        this.upgrades.put(upgrade, 0.0);
        return this;
    }

    public int getLevel(ResourceLocation key) {
        LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(key, LivingUpgrade.DUMMY);
        return upgrade.getLevel(this.upgrades.getOrDefault(upgrade, 0.0).intValue());
    }

    public int getUsedPoints() {
        int total = 0;
        for (Map.Entry<LivingUpgrade, Double> applied : this.upgrades.entrySet()) {
            double experience = applied.getValue();
            int level = applied.getKey().getLevel((int)experience);
            int cost = applied.getKey().getLevelCost(level);
            total += cost;
        }
        return total;
    }

    public int getMaxPoints() {
        return this.maxPoints.get();
    }

    public LivingStats setMaxPoints(int maxPoints) {
        this.maxPoints = () -> maxPoints;
        return this;
    }

    public boolean isEvolved() {
        return this.evolved;
    }

    public LivingStats setEvolved() {
        this.evolved = true;
        this.setMaxPoints((Integer)ConfigManager.COMMON.evolvedUpgradePoints.get());
        return this;
    }

    public CompoundTag serialize() {
        CompoundTag compound = new CompoundTag();
        ListTag statList = new ListTag();
        this.upgrades.forEach((k, v) -> {
            CompoundTag upgrade = new CompoundTag();
            upgrade.m_128359_("key", k.getKey().toString());
            upgrade.m_128347_("exp", v.doubleValue());
            statList.add((Object)upgrade);
        });
        compound.m_128365_("upgrades", (Tag)statList);
        compound.m_128405_("maxPoints", this.maxPoints.get().intValue());
        compound.m_128379_("evolved", this.evolved);
        return compound;
    }

    public void deserialize(CompoundTag nbt) {
        ListTag statList = nbt.m_128437_("upgrades", 10);
        statList.forEach(tag -> {
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            LivingUpgrade upgrade = LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(new ResourceLocation(((CompoundTag)tag).m_128461_("key")), LivingUpgrade.DUMMY);
            if (upgrade == LivingUpgrade.DUMMY) {
                return;
            }
            double experience = ((CompoundTag)tag).m_128459_("exp");
            this.upgrades.put(upgrade, experience);
        });
        this.maxPoints = () -> nbt.m_128451_("maxPoints");
        this.evolved = nbt.m_128471_("evolved");
    }

    public static LivingStats fromNBT(CompoundTag statTag) {
        LivingStats stats = new LivingStats();
        stats.deserialize(statTag);
        return stats;
    }

    public static LivingStats fromPlayer(Player player) {
        return LivingStats.fromPlayer(player, false);
    }

    public static LivingStats fromPlayer(Player player, boolean createNew) {
        if (!LivingUtil.hasFullSet(player)) {
            return null;
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        LivingStats stats = ((ILivingContainer)chest.m_41720_()).getLivingStats(chest);
        return stats == null && createNew ? new LivingStats() : stats;
    }

    public static void toPlayer(Player player, LivingStats stats) {
        if (!LivingUtil.hasFullSet(player)) {
            return;
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ((ILivingContainer)chest.m_41720_()).updateLivingStats(chest, stats);
    }
}

