/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.registries.BloodMagicDamageTypes;
import wayoftime.bloodmagic.common.tile.TileAltar;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="well_of_suffering")
public class RitualWellOfSuffering
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public static final int SACRIFICE_AMOUNT = (Integer)ConfigManager.COMMON.entitySacrificeDefault.get();
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualWellOfSuffering() {
        super("ritualWellOfSuffering", 0, 40000, "ritual.bloodmagic.wellOfSufferingRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.m_121955_((Vec3i)this.altarOffsetPos);
        BlockEntity tile = world.m_7702_(altarPos);
        AreaDescriptor altarRange = masterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                BlockEntity nextTile = world.m_7702_(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.m_121996_((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (tile instanceof TileAltar) {
            TileAltar tileAltar = (TileAltar)tile;
            AreaDescriptor damageRange = masterRitualStone.getBlockRange(DAMAGE_RANGE);
            AABB range = damageRange.getAABB(pos);
            List entities = world.m_45976_(LivingEntity.class, range);
            for (LivingEntity entity : entities) {
                int lifeEssenceRatio;
                ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                if (BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(id) || (lifeEssenceRatio = BloodMagicAPI.INSTANCE.getValueManager().getSacrificial().getOrDefault(id, SACRIFICE_AMOUNT).intValue()) <= 0 || !entity.m_6084_() || entity instanceof Player || !entity.m_6469_(entity.m_269291_().m_269079_(BloodMagicDamageTypes.RITUAL), 1.0f)) continue;
                if (entity.m_6162_()) {
                    lifeEssenceRatio = (int)((float)lifeEssenceRatio * 0.5f);
                }
                tileAltar.sacrificialDaggerCall(lifeEssenceRatio, true);
                if (++totalEffects < maxEffects) continue;
                break;
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, -3, -1, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.WATER);
        this.addOffsetRunes(components, 1, 4, 0, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 1, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWellOfSuffering();
    }
}

