/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;

public class SpecialDungeonRoomPoolRegistry {
    public static Map<ResourceLocation, BiPredicate<Integer, Integer>> predicateMap = new HashMap<ResourceLocation, BiPredicate<Integer, Integer>>();
    public static Map<ResourceLocation, BlockState> stateMap = new HashMap<ResourceLocation, BlockState>();

    public static List<ResourceLocation> getSpecialRooms(int minimumRooms, int minimumDepth, Map<ResourceLocation, Integer> timeSincePlacement, List<ResourceLocation> bufferRoomPools) {
        ArrayList<ResourceLocation> specialRoomPools = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, BiPredicate<Integer, Integer>> entry : predicateMap.entrySet()) {
            ResourceLocation roomPool = entry.getKey();
            if (bufferRoomPools.contains(roomPool) || timeSincePlacement.containsKey(roomPool) || !entry.getValue().test(minimumRooms, minimumDepth)) continue;
            System.out.println("Added special room: " + String.valueOf(roomPool));
            specialRoomPools.add(roomPool);
        }
        return specialRoomPools;
    }

    public static void registerUniqueRoomPool(ResourceLocation roomPool, int minRooms, int minDepth) {
        predicateMap.put(roomPool, (x, y) -> x >= minRooms && y >= minDepth);
    }

    public static void registerUniqueRoomPool(ResourceLocation roomPool, int minRooms, int minDepth, BlockState placementState) {
        SpecialDungeonRoomPoolRegistry.registerUniqueRoomPool(roomPool, minRooms, minDepth);
        stateMap.put(roomPool, placementState);
    }

    public static BlockState getSealBlockState(ResourceLocation roomPool) {
        if (stateMap.containsKey(roomPool)) {
            return stateMap.get(roomPool);
        }
        return ((Block)BloodMagicBlocks.SPECIAL_DUNGEON_SEAL.get()).m_49966_();
    }
}

