/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TraderTileentityBase
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected Block workstation = Blocks.f_50016_;
    protected long nextRestock;

    public TraderTileentityBase(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public Block getWorkstation() {
        return this.workstation;
    }

    public boolean hasWorkstation() {
        return this.workstation != Blocks.f_50016_;
    }

    public void setWorkstation(Block workstation) {
        this.workstation = workstation;
        if (this.hasVillager()) {
            this.fixProfession();
        }
        this.m_6596_();
        this.sync();
    }

    public Block removeWorkstation() {
        Block w = this.workstation;
        this.setWorkstation(Blocks.f_50016_);
        return w;
    }

    public boolean isValidBlock(Block block) {
        return PoiTypes.m_218075_((BlockState)block.m_49966_()).isPresent();
    }

    public VillagerProfession getWorkstationProfession() {
        return PoiTypes.m_218075_((BlockState)this.workstation.m_49966_()).flatMap(pointOfInterestType -> ForgeRegistries.VILLAGER_PROFESSIONS.getValues().stream().filter(villagerProfession -> villagerProfession.f_219628_().test(pointOfInterestType)).findFirst()).orElse(VillagerProfession.f_35585_);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (this.hasWorkstation()) {
            this.fixProfession();
        }
    }

    private void fixProfession() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null || v.m_7809_() > 0 || v.m_7141_().m_35571_().equals((Object)VillagerProfession.f_35596_)) {
            return;
        }
        v.m_34375_(v.m_7141_().m_35565_(this.getWorkstationProfession()));
    }

    public boolean openTradingGUI(Player playerEntity) {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return false;
        }
        if (villagerEntity.m_6162_()) {
            return false;
        }
        VillagerProfession profession = villagerEntity.m_7141_().m_35571_();
        if (profession.equals((Object)VillagerProfession.f_35585_) || profession.equals((Object)VillagerProfession.f_35596_)) {
            return false;
        }
        if (villagerEntity.m_35306_()) {
            return false;
        }
        villagerEntity.m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5);
        villagerEntity.m_35536_(playerEntity);
        return true;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return;
        }
        if (this.advanceAge()) {
            this.sync();
        }
        this.m_6596_();
        VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
        if (!v.m_35306_()) {
            if (v.f_35374_) {
                v.m_35528_();
                v.f_35374_ = false;
                this.sync();
            }
            if (this.f_58857_.m_46467_() - this.getLastRestock() > this.nextRestock && v.m_7141_().m_35571_().equals((Object)this.getWorkstationProfession())) {
                this.restock();
                this.nextRestock = this.calculateNextRestock();
            }
        }
    }

    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get() + this.f_58857_.f_46441_.m_188503_(Math.max((Integer)Main.SERVER_CONFIG.traderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get(), 1));
    }

    protected void restock() {
        try {
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity == null) {
                return;
            }
            villagerEntity.m_35510_();
            SoundEvent workSound = villagerEntity.m_7141_().m_35571_().f_35604_();
            if (workSound != null) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.m_58899_(), workSound);
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Error restocking villager", (Throwable)e);
        }
    }

    protected long getLastRestock() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0L;
        }
        return villagerEntity.f_35363_;
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.hasWorkstation()) {
            compound.m_128359_("Workstation", ForgeRegistries.BLOCKS.getKey((Object)this.workstation).toString());
        }
        compound.m_128356_("NextRestock", this.nextRestock);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("Workstation")) {
            this.workstation = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("Workstation")));
        } else {
            this.removeWorkstation();
        }
        this.nextRestock = compound.m_128454_("NextRestock");
        super.m_142466_(compound);
    }
}

