/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.renderers.EnchantingWixieCauldronRenderer;
import com.github.jarva.arsadditions.client.renderers.tile.WarpNexusRenderer;
import com.github.jarva.arsadditions.client.util.BookUtil;
import com.github.jarva.arsadditions.client.util.CompassUtil;
import com.github.jarva.arsadditions.common.block.EnderSourceJar;
import com.github.jarva.arsadditions.common.util.FillUtil;
import com.github.jarva.arsadditions.setup.networking.OpenTerminalPacket;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import vazkii.patchouli.api.BookContentsReloadEvent;
import vazkii.patchouli.client.book.BookPage;

public class ArsAdditionsClient {
    public static KeyMapping openTerm;

    public static void clientSetup() {
    }

    @Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent evt) {
            if (Minecraft.m_91087_().f_91074_ == null || evt.phase == TickEvent.Phase.START) {
                return;
            }
            if (openTerm.m_90859_()) {
                OpenTerminalPacket.openTerminal();
            }
        }

        @SubscribeEvent
        public static void updateBookContents(BookContentsReloadEvent event) {
            ResourceLocation bookId = event.getBook();
            if (!bookId.equals((Object)BookUtil.WORN_NOTEBOOK)) {
                return;
            }
            BookUtil.addRelation(new ResourceLocation("ars_nouveau", "machines/storage_lectern"), new ResourceLocation("ars_nouveau", "machines/warp_indexes"));
            BookPage wixiePage = BookUtil.newTextPage("ars_additions.page.wixie_enchanting_apparatus", "ars_additions.page1.wixie_enchanting_apparatus");
            BookUtil.addPage(new ResourceLocation("ars_nouveau", "automation/wixie_charm"), wixiePage, true, page -> BookUtil.isTextPage(page, "ars_nouveau.potion_crafting"));
            BookPage bulkScribing = BookUtil.newTextPage("ars_additions.page.bulk_scribing", "ars_additions.page1.bulk_scribing");
            BookUtil.addPage(new ResourceLocation("ars_nouveau", "machines/scribes_block"), bulkScribing, true, page -> BookUtil.isTextPage(page, "ars_nouveau.scribing"));
        }
    }

    @Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void initKeybinds(RegisterKeyMappingsEvent evt) {
            openTerm = new KeyMapping("key.ars_additions.open_lectern", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "key.category.ars_nouveau.general");
            evt.register(openTerm);
        }

        @SubscribeEvent
        public static void init(FMLClientSetupEvent evt) {
            ArsAdditions.LOGGER.info("Running init");
            evt.enqueueWork(() -> {
                ItemProperties.register((Item)((EnderSourceJar)((Object)((Object)AddonBlockRegistry.ENDER_SOURCE_JAR.get()))).m_5456_(), (ResourceLocation)ArsAdditions.prefix("source"), (stack, level, entity, seed) -> {
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) {
                        return 0.0f;
                    }
                    CompoundTag BET = tag.m_128469_("BlockEntityTag");
                    return FillUtil.getFillLevel(BET.m_128451_("source"), BET.m_128451_("max_source"));
                });
                ItemProperties.register((Item)((Item)AddonItemRegistry.HANDY_HAVERSACK.get()), (ResourceLocation)ArsAdditions.prefix("loaded"), (stack, level, entity, seed) -> {
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) {
                        return 1.0f;
                    }
                    return tag.m_128471_("loaded") ? 0.0f : 1.0f;
                });
                ItemProperties.register((Item)((Item)AddonItemRegistry.WAYFINDER.get()), (ResourceLocation)ArsAdditions.prefix("angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((CompassItemPropertyFunction.CompassTarget)new CompassUtil()));
                ItemProperties.register((Item)((Item)AddonItemRegistry.WAYFINDER.get()), (ResourceLocation)ArsAdditions.prefix("pos"), (stack, level, entity, seed) -> {
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) {
                        return 0.0f;
                    }
                    return tag.m_128441_("Structure") ? 1.0f : 0.0f;
                });
            });
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get(), WarpNexusRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)AddonBlockRegistry.WIXIE_ENCHANTING_TILE.get(), EnchantingWixieCauldronRenderer::new);
        }
    }
}

