/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.common.util.SourceSpawner;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SourceSpawnerTile
extends BlockEntity
implements ITickable,
ITooltipProvider {
    public final SourceSpawner spawner = new SourceSpawner(this);

    public SourceSpawnerTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AddonBlockRegistry.SOURCE_SPAWNER_TILE.get(), pos, blockState);
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.spawner.disabled) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ars_additions.source_spawner.disabled").m_130940_(ChatFormatting.GOLD));
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.spawner.m_151328_(this.f_58857_, this.f_58858_, tag);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.spawner.m_186381_(tag);
    }

    public int getDelaySignal() {
        double percentage = (double)this.spawner.spawnDelay / (double)this.spawner.maxSpawnDelay;
        return (int)Math.ceil(percentage * 15.0);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = this.m_187482_();
        compoundtag.m_128473_("SpawnPotentials");
        return compoundtag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_() == null ? new CompoundTag() : pkt.m_131708_());
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawner.m_151311_(serverLevel, pos);
        } else {
            this.spawner.m_151319_(level, pos);
        }
    }

    public BaseSpawner getSpawner() {
        return this.spawner;
    }
}

