/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.common.item.NexusWarpScroll;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.api.particle.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WarpNexusTile
extends BlockEntity
implements GeoBlockEntity,
ITickable,
IWololoable {
    private static final RawAnimation CLOSE = RawAnimation.begin().then("spin", Animation.LoopType.PLAY_ONCE).thenPlayAndHold("close");
    private static final RawAnimation OPEN = RawAnimation.begin().thenPlay("open").thenLoop("spin");
    private static final RawAnimation CLOSED = RawAnimation.begin().thenPlayAndHold("closed");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasNearbyPlayer = false;
    private boolean hasOpened = false;
    public AnimationController<WarpNexusTile> controller;
    private ParticleColor color = ParticleColor.defaultParticleColor();
    private ItemStackHandler inventory;
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);

    public WarpNexusTile(final BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get(), pos, blockState);
        int invSize = blockState.m_61143_(WarpNexus.HALF) == DoubleBlockHalf.LOWER ? 1 : 0;
        this.inventory = new ItemStackHandler(invSize){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack scroll = super.extractItem(slot, amount, simulate);
                if (!(scroll.m_41720_() instanceof NexusWarpScroll)) {
                    return scroll;
                }
                StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(scroll);
                data.setData(pos.m_122012_(), WarpNexusTile.this.f_58857_.m_46472_().m_135782_().toString(), Vec2.f_82462_);
                return scroll;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                WarpNexusTile.this.m_6596_();
            }
        };
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (this.m_58900_().m_61143_(WarpNexus.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        if (level.m_46467_() % 10L == 0L) {
            Player player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false);
            this.hasNearbyPlayer = player != null;
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : super.getCapability(cap);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        this.color = ParticleColorRegistry.from((CompoundTag)tag.m_128469_("color"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("color", (Tag)this.color.serialize());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getStack() {
        if (this.inventory.getSlots() > 0) {
            return this.inventory.getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extract() {
        if (this.inventory.getSlots() > 0) {
            return this.inventory.extractItem(0, 64, false);
        }
        return ItemStack.f_41583_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.controller = new AnimationController((GeoAnimatable)this, this::predicate);
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    private <E extends BlockEntity> PlayState predicate(AnimationState<E> event) {
        if (event.getController().getCurrentAnimation() == null || !this.hasNearbyPlayer && !this.hasOpened) {
            return event.setAndContinue(CLOSED);
        }
        if (this.hasNearbyPlayer) {
            this.hasOpened = true;
            return event.setAndContinue(OPEN);
        }
        return event.setAndContinue(CLOSE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setColor(ParticleColor color) {
        this.color = color;
        this.m_6596_();
    }

    public ParticleColor getColor() {
        return this.color;
    }

    public static Optional<WarpNexusTile> getWarpNexus(Level level, BlockPos pos) {
        Optional be = level.m_141902_(pos, (BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get());
        return be.flatMap(tile -> tile.m_58900_().m_61143_(WarpNexus.HALF) == DoubleBlockHalf.UPPER ? level.m_141902_(pos.m_7495_(), (BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get()) : Optional.of(tile));
    }
}

