/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.util.KeypressUtil;
import com.github.jarva.arsadditions.common.advancement.Triggers;
import com.github.jarva.arsadditions.server.util.LocateUtil;
import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.PortalBlock;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ExplorationWarpScroll
extends Item {
    public ExplorationWarpScroll() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return super.m_6225_(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_20193_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (LocateUtil.isPending(stack)) {
            LocateUtil.resolveUUID(serverLevel, entity.m_20182_(), stack, null);
        }
        BlockPos pos = entity.m_20183_();
        boolean isRuinedPortal = serverLevel.m_215010_().m_220491_(pos, TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ArsAdditions.prefix("ruined_portals"))).m_73603_();
        if (isRuinedPortal) {
            StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(stack);
            if (!data.isValid()) {
                return false;
            }
            String displayName = "Explorer's Warp Portal";
            if (((PortalBlock)BlockRegistry.PORTAL_BLOCK.get()).trySpawnPortal((Level)serverLevel, pos, (WarpScroll.WarpScrollData)data, displayName)) {
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)Triggers.FIND_RUINED_PORTAL, (ServerLevel)serverLevel, (BlockPos)pos, (int)10);
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)Triggers.CREATE_RUINED_PORTAL, (ServerLevel)serverLevel, (BlockPos)pos, (int)10);
                TeleportUtil.createTeleportDecoration(serverLevel, pos, stack);
                return true;
            }
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (LocateUtil.isPending(stack)) {
            LocateUtil.resolveUUID(serverLevel, entity.m_20182_(), stack, entity);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.desc"));
        if (LocateUtil.isPending(stack)) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
        }
        if (KeypressUtil.isShiftPressed()) {
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ars_additions.exploration_warp_scroll.use", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.getKey().m_84875_()}));
        } else {
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_()}));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (usedHand == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(stack);
        if (LocateUtil.isPending(stack)) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!data.isValid()) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.locating"));
            LocateUtil.locateFromStack(serverLevel, player.m_20182_(), stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        TeleportUtil.teleport(serverLevel, (WarpScroll.WarpScrollData)data, (Entity)player, stack);
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

