/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item;

import com.github.jarva.arsadditions.common.util.LangUtil;
import com.github.jarva.arsadditions.server.util.PlayerInvUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="ars_additions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HandyHaversack
extends Item
implements IScribeable {
    public HandyHaversack() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 10L == 0L) {
            return;
        }
        HaversackData.fromItemStack(stack).ifPresent(data -> {
            boolean loaded;
            CompoundTag tag = stack.m_41784_();
            boolean curr = tag.m_128441_("loaded") && tag.m_128471_("loaded");
            if (curr != (loaded = level.m_46749_(data.pos))) {
                tag.m_128379_("loaded", loaded);
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level.f_46443_) {
            return super.m_7203_(level, player, usedHand);
        }
        ItemStack stack = player.m_21120_(usedHand);
        return HaversackData.fromItemStack(stack).map(data -> {
            if (player.m_6144_()) {
                if (data.toggle(stack)) {
                    PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.on"));
                } else {
                    PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.off"));
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            ItemStack write = player.m_21206_();
            this.writeStack(player, stack, write);
            return InteractionResultHolder.m_19090_((Object)stack);
        }).orElse(InteractionResultHolder.m_19100_((Object)stack));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_7078_()) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        BlockPos pos = context.m_8083_();
        BlockEntity be = context.m_43725_().m_7702_(pos);
        if (be == null) {
            return InteractionResult.PASS;
        }
        IItemHandler handler = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
        if (handler != null) {
            ItemStack stack = context.m_43722_();
            HaversackData data = new HaversackData(pos, context.m_43719_(), (ResourceKey<Level>)context.m_43725_().m_46472_(), true, new ArrayList<ItemStack>());
            data.write(stack);
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)Component.m_237110_((String)"chat.ars_additions.warp_index.bound", (Object[])new Object[]{LangUtil.container()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_142207_(ItemStack haversack, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && slot.f_40218_ instanceof Inventory) {
            ItemStack other = slot.m_7993_();
            return this.transportItem(haversack, other, player, arg_0 -> ((Slot)slot).m_5852_(arg_0));
        }
        return false;
    }

    public boolean m_142305_(ItemStack haversack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            return this.transportItem(haversack, other, player, arg_0 -> ((SlotAccess)access).m_142104_(arg_0));
        }
        return false;
    }

    public boolean transportItem(ItemStack haversack, ItemStack other, Player player, Consumer<ItemStack> update) {
        if (player.m_7500_()) {
            return true;
        }
        Optional<HaversackData> dataOpt = HaversackData.fromItemStack(haversack);
        if (dataOpt.isEmpty()) {
            return true;
        }
        HaversackData data = dataOpt.get();
        FilterableItemHandler handler = data.getItemHandler(player.m_9236_());
        if (handler == null) {
            return true;
        }
        InventoryManager manager = new InventoryManager(List.of(handler));
        ItemStack remainder = manager.insertStack(other);
        update.accept(remainder);
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        HaversackData.fromItemStack(stack).ifPresentOrElse(data -> {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ars_additions.warp_index.bound", (Object[])new Object[]{data.pos.m_123341_(), data.pos.m_123342_(), data.pos.m_123343_(), data.level.m_135782_().toString()}));
            if (!data.items().isEmpty()) {
                if (data.active().booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.on"));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.off"));
                }
            }
            for (ItemStack item : data.items()) {
                tooltip.add(item.m_41786_());
            }
        }, () -> tooltip.add((Component)Component.m_237110_((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.m_237117_((String)"key.sneak"), Component.m_237117_((String)"key.use"), LangUtil.container()})));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_())) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ars_additions.handy_haversack.instructions"));
        }
    }

    public boolean writeStack(Player player, ItemStack haversack, ItemStack write) {
        return HaversackData.fromItemStack(haversack).map(data -> {
            if (write.m_41619_()) {
                return false;
            }
            if (data.containsStack(write)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.scribe.item_removed"));
                boolean removed = data.remove(write);
                data.write(haversack);
                return removed;
            }
            if (data.add(write)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.scribe.item_added"));
                data.write(haversack);
                return true;
            }
            return false;
        }).orElseGet(() -> {
            PortUtil.sendMessage((Entity)player, (Component)Component.m_237115_((String)"chat.ars_additions.handy_haversack.invalid"));
            return false;
        });
    }

    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack haversack) {
        return this.writeStack(player, haversack, player.m_21120_(handIn));
    }

    public static void tryStoreStack(Player player, ItemStack pickedUp, Consumer<ItemStack> remainder) {
        ItemStack haversack = PlayerInvUtil.findItem(player, stack -> stack.m_150930_((Item)AddonItemRegistry.HANDY_HAVERSACK.get()), ItemStack.f_41583_, Function.identity());
        if (haversack.m_41619_()) {
            return;
        }
        Item item = haversack.m_41720_();
        if (item instanceof HandyHaversack) {
            HandyHaversack handyHaversack = (HandyHaversack)item;
            HaversackData.fromItemStack(haversack).ifPresent(data -> {
                if (data.containsStack(pickedUp)) {
                    handyHaversack.transportItem(haversack, pickedUp, player, remainder);
                }
            });
        }
    }

    @SubscribeEvent
    public static void entityPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack pickedUp = event.getItem().m_32055_();
        HandyHaversack.tryStoreStack(player, pickedUp, remainder -> {
            pickedUp.m_41764_(remainder.m_41613_());
            event.setResult(Event.Result.ALLOW);
        });
    }

    @SubscribeEvent
    public static void playerPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack pickedUp = event.getStack();
        HandyHaversack.tryStoreStack(player, pickedUp, remainder -> pickedUp.m_41764_(remainder.m_41613_()));
    }

    public record HaversackData(BlockPos pos, Direction side, ResourceKey<Level> level, Boolean active, ArrayList<ItemStack> items) {
        public static final String TAG_KEY = "haversack";
        public static final Codec<HaversackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("BindPos").forGetter(HaversackData::pos), (App)Direction.f_175356_.optionalFieldOf("BindDirection", (Object)Direction.UP).forGetter(HaversackData::side), (App)Level.f_46427_.fieldOf("BindDim").forGetter(HaversackData::level), (App)Codec.BOOL.optionalFieldOf("Active", (Object)false).forGetter(HaversackData::active), (App)ItemStack.f_41582_.listOf().optionalFieldOf("Items", List.of()).xmap(Lists::newArrayList, list -> list).forGetter(HaversackData::items)).apply((Applicative)instance, HaversackData::new));

        public static Optional<HaversackData> fromItemStack(ItemStack stack) {
            return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)stack.m_41784_().m_128469_(TAG_KEY)).result();
        }

        public boolean toggle(ItemStack stack) {
            HaversackData toggled = new HaversackData(this.pos, this.side, this.level, this.active == false, this.items);
            toggled.write(stack);
            return toggled.active;
        }

        public void write(ItemStack stack) {
            CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().ifPresent(tag -> stack.m_41784_().m_128365_(TAG_KEY, tag));
        }

        public boolean add(ItemStack stack) {
            return this.items.add(stack.m_41777_());
        }

        public boolean remove(ItemStack stack) {
            return this.items.removeIf(s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack));
        }

        public boolean containsStack(ItemStack stack) {
            return this.items.stream().anyMatch(s -> ItemStack.m_41656_((ItemStack)s, (ItemStack)stack));
        }

        @Nullable
        public FilterableItemHandler getItemHandler(Level level) {
            if (!level.m_46749_(this.pos)) {
                return null;
            }
            BlockEntity be = level.m_7702_(this.pos);
            if (be == null) {
                return null;
            }
            return be.getCapability(ForgeCapabilities.ITEM_HANDLER, this.side).map(cap -> new FilterableItemHandler(cap, InvUtil.filtersOnTile((BlockEntity)be))).orElse(null);
        }
    }
}

