/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.imbuement;

import com.github.jarva.arsadditions.common.item.curios.Charm;
import com.github.jarva.arsadditions.common.util.codec.ResourceOrTag;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record CharmChargingRecipe(ResourceLocation id, ResourceOrTag<Item> input, int costPerCharge) implements IImbuementRecipe
{
    public boolean isMatch(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.stack;
        Item item = reagent.m_41720_();
        if (item instanceof Charm) {
            Charm charm = (Charm)item;
            if (charm.getDamage(reagent) == 0) {
                return false;
            }
            return this.input.map(Ingredient::m_204132_, key -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.f_257033_.m_6246_(key)})).map(ingredient -> ingredient.test(imbuementTile.stack)).orElse(false);
        }
        return false;
    }

    public ItemStack getResult(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.m_8020_(0);
        ItemStack result = reagent.m_41777_();
        CharmRegistry.setCharges(result, result.m_41776_());
        return result;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.m_8020_(0);
        return reagent.m_41773_() * this.costPerCharge;
    }

    public boolean matches(ImbuementTile container, Level level) {
        return false;
    }

    public ItemStack assemble(ImbuementTile container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AddonRecipeRegistry.CHARM_CHARGING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AddonRecipeRegistry.CHARM_CHARGING_TYPE.get();
    }

    public JsonElement asRecipe() {
        JsonElement recipe = Serializer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElse(null);
        JsonObject obj = recipe.getAsJsonObject();
        obj.addProperty("type", this.m_6671_().toString());
        return obj;
    }

    public Component getCraftingStartedText(ImbuementTile imbuementTile) {
        return Component.m_237110_((String)"chat.ars_additions.charm.charging_started", (Object[])new Object[]{this.getResult(imbuementTile).m_41786_()});
    }

    public Component getCraftingText(ImbuementTile imbuementTile) {
        return Component.m_237110_((String)"tooltip.ars_additions.charm.charging", (Object[])new Object[]{this.getResult(imbuementTile).m_41786_()});
    }

    public Component getCraftingProgressText(ImbuementTile imbuementTile, int progress) {
        return Component.m_237110_((String)"tooltip.ars_additions.charm.charging_progress", (Object[])new Object[]{progress}).m_130940_(ChatFormatting.GOLD);
    }

    public static class Serializer
    implements RecipeSerializer<CharmChargingRecipe> {
        public static final Codec<CharmChargingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(CharmChargingRecipe::id), (App)ResourceOrTag.ITEM_CODEC.fieldOf("item").forGetter(CharmChargingRecipe::input), (App)Codec.INT.optionalFieldOf("costPerDamage", (Object)10).forGetter(CharmChargingRecipe::costPerCharge)).apply((Applicative)instance, CharmChargingRecipe::new));

        public CharmChargingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(null);
        }

        @Nullable
        public CharmChargingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            return (CharmChargingRecipe)friendlyByteBuf.m_271872_(CODEC);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, CharmChargingRecipe recipe) {
            friendlyByteBuf.m_272073_(CODEC, (Object)recipe);
        }
    }
}

