/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.networking;

import com.github.jarva.arsadditions.client.util.ClientUtil;
import com.github.jarva.arsadditions.common.capability.CapabilityRegistry;
import com.github.jarva.arsadditions.setup.networking.AbstractPacket;
import com.github.jarva.arsadditions.setup.networking.NetworkHandler;
import com.hollingsworth.arsnouveau.ArsNouveau;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;

public class OpenNexusPacket
implements AbstractPacket {
    private final BlockPos pos;
    private final CompoundTag tag;

    public OpenNexusPacket(FriendlyByteBuf buf) {
        this.tag = buf.m_130260_();
        this.pos = buf.m_130135_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.tag);
        buf.m_130064_(this.pos);
    }

    public OpenNexusPacket(CompoundTag famCaps, BlockPos nexus) {
        this.tag = famCaps;
        this.pos = nexus;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = ArsNouveau.proxy.getPlayer();
            ItemStackHandler itemStackHandler = new ItemStackHandler(9);
            itemStackHandler.deserializeNBT(this.tag);
            ClientUtil.openWarpScreen(ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.pos), itemStackHandler);
        });
        ctx.get().setPacketHandled(true);
    }

    public static void openNexus(Player player, BlockPos pos) {
        ItemStackHandler nexus = (ItemStackHandler)player.getCapability(CapabilityRegistry.PLAYER_NEXUS_CAPABILITY).orElse((Object)new ItemStackHandler());
        CompoundTag tag = nexus.serializeNBT();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayerClient(new OpenNexusPacket(tag, pos), serverPlayer);
        }
    }
}

