/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.networking;

import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.common.block.tile.WarpNexusTile;
import com.github.jarva.arsadditions.common.capability.CapabilityRegistry;
import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.github.jarva.arsadditions.setup.networking.AbstractPacket;
import com.github.jarva.arsadditions.setup.networking.NetworkHandler;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;

public class TeleportNexusPacket
implements AbstractPacket {
    private final BlockPos pos;
    int index;

    public TeleportNexusPacket(FriendlyByteBuf buf) {
        this.index = buf.readInt();
        this.pos = buf.m_130135_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.index);
        buf.m_130064_(this.pos);
    }

    public TeleportNexusPacket(int index, BlockPos pos) {
        this.index = index;
        this.pos = pos;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            WarpNexusTile be = WarpNexusTile.getWarpNexus(player.m_9236_(), this.pos).orElse(null);
            if (be == null) {
                return;
            }
            if (player.m_20183_().m_203198_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()) > Math.pow(player.getBlockReach(), 2.0)) {
                return;
            }
            ItemStackHandler nexus = (ItemStackHandler)player.getCapability(CapabilityRegistry.PLAYER_NEXUS_CAPABILITY).orElse((Object)new ItemStackHandler());
            ItemStack scroll = nexus.getStackInSlot(this.index);
            StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(scroll);
            if (((Boolean)be.m_58900_().m_61143_((Property)WarpNexus.REQUIRES_SOURCE)).booleanValue()) {
                ISpecialSourceProvider takePos = SourceUtil.takeSource((BlockPos)this.pos, (Level)player.m_284548_(), (int)5, (int)1000);
                if (takePos != null) {
                    TeleportUtil.teleport(player.m_284548_(), (WarpScroll.WarpScrollData)data, (Entity)player);
                } else {
                    PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.apparatus.nomana"));
                }
            } else {
                TeleportUtil.teleport(player.m_284548_(), (WarpScroll.WarpScrollData)data, (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void teleport(int index, BlockPos pos) {
        NetworkHandler.sendToServer(new TeleportNexusPacket(index, pos));
    }
}

