/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.web.config.validators;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefulconfig.web.config.validators.Validator;
import com.teamresourceful.resourcefulconfig.web.config.validators.Validators;
import com.teamresourceful.resourcefulconfig.web.info.UserJwtPayload;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;

public record IfValidator(Set<UUID> uuids, Validator ifTrue, Optional<Validator> ifFalse) implements Validator
{
    public static final Codec<Set<UUID>> UUID_SET_CODEC = UUIDUtil.f_252480_.listOf().xmap(HashSet::new, Lists::newArrayList);
    public static final Codec<IfValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUID_SET_CODEC.fieldOf("uuids").forGetter(IfValidator::uuids), (App)Validators.CODEC.fieldOf("if").forGetter(IfValidator::ifTrue), (App)Validators.CODEC.optionalFieldOf("else").forGetter(IfValidator::ifFalse)).apply((Applicative)instance, IfValidator::new));

    @Override
    public boolean test(UserJwtPayload userJwtPayload) {
        if (this.uuids.contains(userJwtPayload.uuid())) {
            return this.ifTrue.test(userJwtPayload);
        }
        return this.ifFalse.map(validator -> validator.test(userJwtPayload)).orElse(false);
    }

    @Override
    public String id() {
        return "if";
    }
}

