/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.underground_village.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.reggarf.mods.underground_village.Underground_village;
import com.reggarf.mods.underground_village.register.USStructures;
import com.reggarf.mods.underground_village.utilities.FilterHolderSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class UnderwaterStructures
extends Structure {
    public static final MapCodec<Structure.StructureSettings> CUSTOM_STRUCTURE_SETTINGS_CODEC = RecordCodecBuilder.mapCodec(codecBuilder -> codecBuilder.group((App)FilterHolderSet.codec(Registries.f_256952_, Biome.f_47431_, false).fieldOf("biomes").forGetter(x -> {
        FilterHolderSet filterHolderSet;
        HolderSet patt2343$temp = x.f_226689_();
        if (patt2343$temp instanceof FilterHolderSet) {
            FilterHolderSet filterHolderSet2 = (FilterHolderSet)patt2343$temp;
            filterHolderSet = filterHolderSet2;
        } else {
            filterHolderSet = new FilterHolderSet(x.f_226689_(), HolderSet.m_205800_(List.of()));
        }
        return filterHolderSet;
    }), (App)Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(Structure.StructureSettings::f_226690_), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(Structure.StructureSettings::f_226691_), (App)TerrainAdjustment.f_226918_.optionalFieldOf("terrain_adaptation", (Object)new Structure.StructureSettings((HolderSet)HolderSet.m_205809_((Holder[])new Holder[0]), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE).f_226692_()).forGetter(Structure.StructureSettings::f_226692_)).apply((Applicative)codecBuilder, Structure.StructureSettings::new));
    public static final Codec<UnderwaterStructures> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CUSTOM_STRUCTURE_SETTINGS_CODEC.forGetter(structureInfo -> structureInfo.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, UnderwaterStructures::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public UnderwaterStructures(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int ignoredMaxDistance) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = Underground_village.CONFIG.common.waterstructureSize;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = Underground_village.CONFIG.common.watermaxDistanceFromCenter;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int occupiedYPos = context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(chunkpos.m_151382_(0), chunkpos.m_151391_(0), context.f_226629_(), context.f_226624_());
        BlockState blockState = columnOfBlocks.m_183556_(occupiedYPos);
        return blockState.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!UnderwaterStructures.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        ChunkPos chunkPos = context.f_226628_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)USStructures.UNDERWATER_STRUCTURES.get();
    }
}

