/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.underground_village.structureplacement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.reggarf.mods.underground_village.register.USStructurePlacements;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class DistanceBasedStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<DistanceBasedStructurePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(rec$ -> ((DistanceBasedStructurePlacement)((Object)((Object)((Object)rec$)))).m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((DistanceBasedStructurePlacement)((Object)((Object)((Object)rec$)))).m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((DistanceBasedStructurePlacement)((Object)((Object)((Object)rec$)))).m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(rec$ -> ((DistanceBasedStructurePlacement)((Object)((Object)((Object)rec$)))).m_227075_()), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((DistanceBasedStructurePlacement)((Object)((Object)((Object)rec$)))).m_227076_()), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::m_205003_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::m_205005_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("min_distance_from_world_origin").forGetter(DistanceBasedStructurePlacement::minDistanceFromWorldOrigin)).apply((Applicative)instance, instance.stable(DistanceBasedStructurePlacement::new)));
    private final Optional<Integer> minDistanceFromWorldOrigin;

    public DistanceBasedStructurePlacement(Vec3i locationOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, int spacing, int separation, RandomSpreadType spreadType, Optional<Integer> minDistanceFromWorldOrigin) {
        super(locationOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.minDistanceFromWorldOrigin = minDistanceFromWorldOrigin;
        if (spacing <= separation) {
            throw new RuntimeException("    Spacing cannot be less or equal to separation.\n    Please correct this error as there's no way to spawn this structure properly\n        Spacing: %s\n        Separation: %s.\n".formatted(spacing, separation));
        }
    }

    public Optional<Integer> minDistanceFromWorldOrigin() {
        return this.minDistanceFromWorldOrigin;
    }

    protected boolean m_214090_(ChunkGeneratorStructureState chunkGeneratorStructureState, int x, int z) {
        long zBlockPos;
        long xBlockPos;
        if (this.minDistanceFromWorldOrigin.isPresent() && (xBlockPos = (long)x * 16L) * xBlockPos + (zBlockPos = (long)z * 16L) * zBlockPos < (long)this.minDistanceFromWorldOrigin.get().intValue() * (long)this.minDistanceFromWorldOrigin.get().intValue()) {
            return false;
        }
        ChunkPos chunkpos = this.m_227008_(chunkGeneratorStructureState.m_254887_(), x, z);
        return chunkpos.f_45578_ == x && chunkpos.f_45579_ == z;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)USStructurePlacements.DISTANCE_BASED_STRUCTURE_PLACEMENT.get();
    }
}

