/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.underground_village.utilities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public class FilterHolderSet<T>
implements HolderSet<T> {
    private final HolderSet<T> base;
    private final HolderSet<T> filter;
    private Set<Holder<T>> set = null;
    private List<Holder<T>> list = null;

    public static <T> MapCodec<FilterHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("base").forGetter(FilterHolderSet::base), (App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("filter").forGetter(FilterHolderSet::filter)).apply((Applicative)builder, FilterHolderSet::new));
    }

    public HolderSet<T> base() {
        return this.base;
    }

    public HolderSet<T> filter() {
        return this.filter;
    }

    public FilterHolderSet(HolderSet<T> base, HolderSet<T> filter) {
        this.base = base;
        this.filter = filter;
    }

    protected Set<Holder<T>> createSet() {
        return this.base.m_203614_().filter(holder -> !this.filter.m_203333_(holder)).collect(Collectors.toSet());
    }

    public Set<Holder<T>> getSet() {
        Set<Holder<T>> thisSet = this.set;
        if (thisSet == null) {
            Set<Holder<T>> set = this.createSet();
            this.set = set;
            return set;
        }
        return thisSet;
    }

    public List<Holder<T>> getList() {
        List<Holder<T>> thisList = this.list;
        if (thisList == null) {
            List<Holder<T>> list = List.copyOf(this.getSet());
            this.list = list;
            return list;
        }
        return thisList;
    }

    public Stream<Holder<T>> m_203614_() {
        return this.getList().stream();
    }

    public int m_203632_() {
        return this.getList().size();
    }

    public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
        return Either.right(this.getList());
    }

    public Optional<Holder<T>> m_213653_(RandomSource rand) {
        List<Holder<T>> list = this.getList();
        int size = list.size();
        return size > 0 ? Optional.of(list.get(rand.m_188503_(size))) : Optional.empty();
    }

    public Holder<T> m_203662_(int i) {
        return this.getList().get(i);
    }

    public boolean m_203333_(Holder<T> holder) {
        return this.getSet().contains(holder);
    }

    public boolean m_207277_(HolderOwner<T> holderOwner) {
        return this.base.m_207277_(holderOwner) && this.filter.m_207277_(holderOwner);
    }

    public Optional<TagKey<T>> m_245234_() {
        return Optional.empty();
    }

    public Iterator<Holder<T>> iterator() {
        return this.getList().iterator();
    }
}

