/*
 * Decompiled with CFR 0.152.
 */
package com.mna.advancements.triggers;

import com.google.gson.JsonObject;
import com.mna.advancements.predicates.CraftSpellPredicate;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.RLoc;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class CastSpellTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RLoc.create("cast_spell");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        CraftSpellPredicate predicate = null;
        if (json.has("spell") && json.get("spell").isJsonObject()) {
            predicate = CraftSpellPredicate.fromJSON(json.get("spell").getAsJsonObject());
        }
        return new Instance(entityPredicate, predicate);
    }

    public void trigger(ServerPlayer player, ISpellDefinition spell) {
        this.m_66234_(player, instance -> instance.test(spell, player.m_9236_()));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final CraftSpellPredicate predicate;

        public Instance(ContextAwarePredicate player, CraftSpellPredicate predicate) {
            super(ID, player);
            this.predicate = predicate;
        }

        public boolean test(ISpellDefinition spell, Level world) {
            if (this.predicate != null) {
                return this.predicate.test(spell, world);
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            return jsonobject;
        }
    }
}

