/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class DirectionalPoint {
    private final Direction direction;
    private final BlockPos position;
    private final String originalBlockName;
    private final Block originalBlock;
    private final String originalBlockID;

    public DirectionalPoint(BlockPos position, Direction direction, @Nullable String originalBlockName, @Nullable String originalBlockID) {
        this.position = position;
        this.direction = direction;
        this.originalBlockName = originalBlockName;
        this.originalBlockID = originalBlockID;
        this.originalBlock = originalBlockID != null ? (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(originalBlockID)) : null;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isValid() {
        return this.position != null && this.direction != null;
    }

    @Nullable
    public String getBlockName() {
        return this.originalBlockName;
    }

    @Nullable
    public Block getBlock() {
        return this.originalBlock;
    }

    @Nullable
    public String getBlockID() {
        return this.originalBlockID;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.direction != null) {
            tag.m_128405_("direction", this.direction.m_122411_());
        }
        if (this.position != null) {
            tag.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)this.position));
        }
        if (this.originalBlockName != null) {
            tag.m_128359_("block", this.originalBlockName);
        }
        if (this.originalBlockID != null) {
            tag.m_128359_("block_id", this.originalBlockID);
        }
        return tag;
    }

    public static DirectionalPoint of(CompoundTag tag) {
        if (tag.m_128441_("position") && tag.m_128441_("direction")) {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("position"));
            Direction direction = Direction.m_122376_((int)tag.m_128451_("direction"));
            String name = tag.m_128441_("block") ? tag.m_128461_("block") : null;
            String blockID = tag.m_128441_("block_id") ? tag.m_128461_("block_id") : null;
            return new DirectionalPoint(pos, direction, name, blockID);
        }
        return null;
    }
}

