/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.blocks.tile;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.PowerStatus;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;

public interface IPowerRequestStatus {
    default public void writePowerConsumeStatus(PowerStatus value, CompoundTag tag) {
        this.writePowerConsumeStatus(value, tag, "powerStatus");
    }

    default public void writePowerConsumeStatus(PowerStatus value, CompoundTag tag, String key) {
        tag.m_128405_(key, value.ordinal());
    }

    default public void writePowerConsumeStatus(CompoundTag tag, HashMap<Affinity, PowerStatus> values) {
        int[] affinities = new int[values.size()];
        int[] statuses = new int[values.size()];
        int count = 0;
        for (Affinity aff : values.keySet()) {
            affinities[count] = aff.ordinal();
            statuses[count] = values.get((Object)aff).ordinal();
            ++count;
        }
        tag.m_128385_("powerStatusKeys", affinities);
        tag.m_128385_("powerStatusValues", statuses);
    }

    default public PowerStatus readPowerConsumeStatus(CompoundTag tag) {
        return this.readPowerConsumeStatus(tag, "powerStatus");
    }

    default public PowerStatus readPowerConsumeStatus(CompoundTag tag, String key) {
        if (tag.m_128425_(key, 3)) {
            return PowerStatus.values()[tag.m_128451_(key)];
        }
        return PowerStatus.NOT_REQUESTING;
    }

    default public void readPowerConsumeStatusList(CompoundTag tag, HashMap<Affinity, PowerStatus> output) {
        int[] statuses;
        int[] affinities;
        output.clear();
        if (tag.m_128425_("powerStatusKeys", 11) && tag.m_128425_("powerStatusValues", 11) && (affinities = tag.m_128465_("powerStatusKeys")).length == (statuses = tag.m_128465_("powerStatusValues")).length) {
            for (int i = 0; i < affinities.length; ++i) {
                Affinity aff = Affinity.values()[affinities[i]];
                PowerStatus stat = PowerStatus.values()[statuses[i]];
                output.put(aff, stat);
            }
        }
    }

    default public PowerStatus calculatePowerStatus(float requested, float obtained) {
        if (obtained < 0.0f) {
            return PowerStatus.NO_CONDUIT;
        }
        if (obtained == 0.0f) {
            return PowerStatus.NO_POWER;
        }
        return obtained < requested ? PowerStatus.PARTIAL : PowerStatus.SUPPLIED;
    }
}

