/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.ai;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.spells.targeting.SpellSource;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class CastSpellOnSelfGoal<T extends Mob>
extends Goal {
    private final T user;
    private final ItemStack stack;
    private final Predicate<? super T> shouldCast;
    private final Consumer<? super T> onStartHandler;
    private final Consumer<? super T> onStopHandler;
    private final int warmup;
    private int counter;

    public CastSpellOnSelfGoal(T user, ItemStack stack, Predicate<? super T> shouldCast) {
        this((T)user, stack, shouldCast, null, null, 0);
    }

    public CastSpellOnSelfGoal(T user, ItemStack stack, Predicate<? super T> shouldCast, @Nullable Consumer<? super T> onStartHandler, @Nullable Consumer<? super T> onStopHandler, int warmup) {
        this.user = user;
        this.stack = stack;
        this.shouldCast = shouldCast;
        this.warmup = warmup;
        this.onStartHandler = onStartHandler;
        this.onStopHandler = onStopHandler;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8045_() {
        return this.counter < this.warmup;
    }

    public boolean m_8036_() {
        return this.shouldCast.test(this.user);
    }

    public void m_8056_() {
        if (this.onStartHandler != null) {
            this.onStartHandler.accept(this.user);
        }
        this.counter = 0;
    }

    public void m_8041_() {
        if (this.onStopHandler != null) {
            this.onStopHandler.accept(this.user);
        }
        this.counter = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        if (++this.counter >= this.warmup) {
            ManaAndArtificeMod.getSpellHelper().affect(this.stack, ManaAndArtificeMod.getSpellHelper().parseSpellDefinition(this.stack), this.user.m_9236_(), new SpellSource((LivingEntity)this.user, InteractionHand.MAIN_HAND));
            if (this.onStopHandler != null) {
                this.onStopHandler.accept(this.user);
            }
        }
    }
}

