/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.entities.possession;

import com.mna.api.spells.targeting.SpellTargetHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PossessionActions {
    private static HashMap<EntityType<?>, PosessionActionCollection<?>> _registeredActions = new HashMap();

    public static <T extends Mob> void RegisterLeftClickAction(EntityType<T> entityType, Consumer<T> callback) {
        PosessionActionCollection<T> registry = _registeredActions.getOrDefault(entityType, new PosessionActionCollection());
        registry.AddAction(callback);
        _registeredActions.put(entityType, registry);
    }

    public static <T extends Mob> boolean Invoke(T reference) {
        PosessionActionCollection registry = _registeredActions.getOrDefault(reference.m_6095_(), null);
        if (registry == null) {
            return false;
        }
        registry.Invoke(reference);
        return true;
    }

    public static <T extends Mob> boolean InvokeDefault(T reference) {
        boolean isSkeleton = reference instanceof AbstractSkeleton;
        boolean isCrossbowUser = reference instanceof CrossbowAttackMob;
        if (isSkeleton || isCrossbowUser) {
            ItemStack itemstack = reference.m_6298_(reference.m_21120_(ProjectileUtil.getWeaponHoldingHand(reference, item -> item == Items.f_42411_)));
            AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_(reference, (ItemStack)itemstack, (float)1.0f);
            if (reference.m_21205_().m_41720_() instanceof BowItem) {
                abstractarrowentity = ((BowItem)reference.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            }
            Vec3 fwd = Vec3.m_82503_((Vec2)reference.m_20155_());
            double d0 = fwd.f_82479_;
            double d1 = fwd.f_82480_;
            double d2 = fwd.f_82481_;
            double d3 = Mth.m_144952_((double)(d0 * d0 + d2 * d2));
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - reference.m_9236_().m_46791_().m_19028_() * 4));
            reference.m_5496_(isCrossbowUser ? SoundEvents.f_11847_ : SoundEvents.f_12382_, 1.0f, 1.0f / (reference.m_217043_().m_188501_() * 0.4f + 0.8f));
            reference.m_9236_().m_7967_((Entity)abstractarrowentity);
            return true;
        }
        if (reference instanceof RangedAttackMob) {
            ((RangedAttackMob)reference).m_6504_(reference, 1.0f);
            return true;
        }
        float range = 8.0f;
        double damage = 1.0;
        if (reference.m_21204_().m_22171_(Attributes.f_22281_)) {
            damage = Math.max(reference.m_21051_(Attributes.f_22281_).m_22135_(), 1.0);
        }
        HitResult targetResult = SpellTargetHelper.rayTrace(null, reference.m_9236_(), reference.m_20182_().m_82520_(0.0, (double)reference.m_20192_(), 0.0), Vec3.m_82503_((Vec2)reference.m_20155_()), true, false, ClipContext.Block.COLLIDER, entity -> entity.m_6087_() && entity.m_6084_() && entity != reference, reference.m_20191_().m_82377_((double)range, (double)range, (double)range), range);
        reference.m_21011_(InteractionHand.MAIN_HAND, true);
        if (targetResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult ertr = (EntityHitResult)targetResult;
            ertr.m_82443_().m_6469_(reference.m_269291_().m_269333_(reference), (float)damage);
            return true;
        }
        return false;
    }

    static class PosessionActionCollection<T extends Entity> {
        ArrayList<Consumer<T>> actions = new ArrayList();

        public void AddAction(Consumer<T> callback) {
            this.actions.add(callback);
        }

        public void Invoke(T e) {
            this.actions.forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)a -> a.accept(e)));
        }
    }
}

