/*
 * Decompiled with CFR 0.152.
 */
package com.mna.api.items;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.ChargeableItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ManaBatteryItem
extends ChargeableItem {
    static final String KEY_MODE = "mana_crystal_fragment_mode";
    static final String KEY_MANA = "mana_crystal_fragment_mana";
    static final int MODE_INFUSE = 0;
    static final int MODE_SUPPLEMENT = 1;

    public ManaBatteryItem(Item.Properties properties, float maxMana) {
        super(properties, maxMana);
    }

    public int getMode(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(KEY_MODE)) {
            return 0;
        }
        return stack.m_41783_().m_128451_(KEY_MODE);
    }

    protected void setMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(KEY_MODE, mode);
    }

    @Override
    public void m_5929_(Level pLevel, LivingEntity living, ItemStack stack, int pRemainingUseDuration) {
        IPlayerMagic magic = (IPlayerMagic)living.getCapability(ManaAndArtificeMod.getMagicCapability()).orElse(null);
        if (magic == null || !(living instanceof Player)) {
            return;
        }
        int mana_shift_amount = 10;
        switch (this.getMode(stack)) {
            case 1: {
                if (living.m_9236_().m_5776_()) {
                    living.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), living.m_20185_() - 0.5 + Math.random(), living.m_20186_() + Math.random(), living.m_20189_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
                    break;
                }
                if (!(magic.getCastingResource().getAmount() < magic.getCastingResource().getMaxAmount())) break;
                if (this.consumeMana(stack, mana_shift_amount, null)) {
                    magic.getCastingResource().restore(mana_shift_amount);
                    break;
                }
                living.m_5810_();
                break;
            }
            default: {
                if (living.m_9236_().m_5776_()) {
                    living.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), living.m_20185_() - 0.5 + Math.random(), living.m_20186_() + Math.random(), living.m_20189_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
                    break;
                }
                if (magic.getCastingResource().getAmount() > (float)mana_shift_amount) {
                    if (this.refundMana(stack, mana_shift_amount, (Player)living) > 0.0f) {
                        magic.getCastingResource().setAmount(magic.getCastingResource().getAmount() - (float)mana_shift_amount);
                        break;
                    }
                    living.m_5810_();
                    return;
                }
                living.m_5810_();
                return;
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                if (this.getMode(stack) == 0) {
                    this.setMode(stack, 1);
                } else {
                    this.setMode(stack, 0);
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (this.getMode(stack) == 1) {
            if (this.getMana(stack) > 0.0f) {
                playerIn.getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                    if (m.getCastingResource().canRechargeFrom(stack) && m.getCastingResource().getAmount() < m.getCastingResource().getMaxAmount()) {
                        playerIn.m_6672_(handIn);
                    }
                });
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.f_46443_);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        switch (this.getMode(stack)) {
            case 1: {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.mana_battery.supplement").m_130940_(ChatFormatting.AQUA));
                break;
            }
            default: {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.mana_battery.infusion").m_130940_(ChatFormatting.AQUA));
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.f_91074_ != null) {
            mc.f_91074_.getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                if (!m.getCastingResource().canRechargeFrom(stack)) {
                    tooltip.add((Component)Component.m_237115_((String)"item.mna.mana_battery.no_supplement").m_130940_(ChatFormatting.RED));
                }
            });
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return this.getMode(newStack) == 0 ? this.getMana(newStack) < this.getMaxMana() : this.getMode(newStack) == 1 && this.getMana(newStack) >= 0.0f;
    }

    @Override
    protected boolean tickCurio() {
        return false;
    }

    @Override
    protected boolean tickInventory() {
        return false;
    }

    @Override
    protected boolean tickEffect(ItemStack stack, Player player, Level world, int slot, float mana, boolean selected) {
        return false;
    }
}

