/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.blocks.tileentities.FluidJugTile;
import com.mna.items.ItemInit;
import com.mna.items.artifice.FluidJug;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidJugBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
IDontCreateBlockItem,
SimpleWaterloggedBlock {
    public static final ResourceLocation JUG = new ResourceLocation("jug");
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private final boolean is_infinite;
    private final ResourceLocation infinite_fluid_type;

    public FluidJugBlock(boolean is_infinite, ResourceLocation fluidType) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283744_).m_60955_().m_60978_(2.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.is_infinite = is_infinite;
        this.infinite_fluid_type = fluidType;
    }

    public FluidJugBlock() {
        this(false, null);
    }

    public final boolean is_infinite() {
        return this.is_infinite;
    }

    @Nullable
    public final ResourceLocation getFluidType() {
        return this.infinite_fluid_type;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FluidJugTile(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
        BlockPos blockpos = ctx.m_8083_();
        BlockState blockstate = ctx.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidstate = ctx.m_43725_().m_6425_(blockpos);
        return (BlockState)base.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos position, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            return InteractionResult.FAIL;
        }
        LazyOptional handler = FluidUtil.getFluidHandler((Level)world, (BlockPos)position, (Direction)Direction.DOWN);
        if (handler.isPresent()) {
            if (heldItem.m_41720_() == Items.f_42590_) {
                BlockEntity be;
                FluidStack blockFluidStack = ((IFluidHandler)handler.resolve().get()).getFluidInTank(0);
                int amt = blockFluidStack.getAmount();
                if (amt >= 100 && (be = world.m_7702_(position)) != null && be instanceof FluidJugTile) {
                    FluidJugTile fluidTile = (FluidJugTile)be;
                    fluidTile.drain(100, IFluidHandler.FluidAction.EXECUTE);
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)heldItem, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                    player.m_6674_(hand);
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            } else if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((IFluidHandler)handler.resolve().get()))) {
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        BlockEntity be;
        FluidStack flStack;
        if (!this.is_infinite && stack.m_41782_() && !(flStack = ((FluidJug)ItemInit.FLUID_JUG.get()).getFluidTagData(stack)).isEmpty() && (be = world.m_7702_(pos)) != null && be instanceof FluidJugTile) {
            FluidJugTile fluidTile = (FluidJugTile)be;
            fluidTile.fill(flStack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        FluidJugTile jug;
        FluidStack jugFluid;
        BlockEntity blockentity;
        if (!this.is_infinite && (blockentity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof FluidJugTile && !(jugFluid = (jug = (FluidJugTile)blockentity).getFluidInTank(0)).isEmpty()) {
            ItemStack jugStack = new ItemStack((ItemLike)ItemInit.FLUID_JUG.get());
            FluidUtil.getFluidHandler((ItemStack)jugStack).ifPresent(f -> f.fill(jugFluid, IFluidHandler.FluidAction.EXECUTE));
            return Arrays.asList(jugStack);
        }
        return super.m_49635_(state, builder);
    }
}

