/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.artifice;

import com.mna.api.tools.BlockUtilities;
import com.mna.blocks.TableShape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TableBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<TableShape> SHAPE = EnumProperty.m_61587_((String)"shape", TableShape.class);
    private static final VoxelShape TABLE_LEG_NE = Block.m_49796_((double)10.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)6.0);
    private static final VoxelShape TABLE_LEG_NW = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)6.0, (double)13.0, (double)6.0);
    private static final VoxelShape TABLE_LEG_SE = Block.m_49796_((double)10.0, (double)0.0, (double)10.0, (double)14.0, (double)13.0, (double)14.0);
    private static final VoxelShape TABLE_LEG_SW = Block.m_49796_((double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)13.0, (double)14.0);
    private static final VoxelShape LEG_BRACE_N = Block.m_49796_((double)6.0, (double)6.0, (double)3.0, (double)10.0, (double)8.0, (double)4.0);
    private static final VoxelShape LEG_BRACE_E = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)13.0, (double)8.0, (double)10.0);
    private static final VoxelShape LEG_BRACE_W = Block.m_49796_((double)3.0, (double)6.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0);
    private static final VoxelShape LEG_BRACE_S = Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)8.0, (double)13.0);
    public static final VoxelShape STANDALONE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{TABLE_LEG_NE, TABLE_LEG_NW, TABLE_LEG_SE, TABLE_LEG_SW, LEG_BRACE_N, LEG_BRACE_E, LEG_BRACE_W, LEG_BRACE_S});
    private static final VoxelShape END_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)13.0, (double)8.0, (double)10.0), Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)10.0), TABLE_LEG_SE, TABLE_LEG_SW, LEG_BRACE_S});
    public static final VoxelShape STRAIGHT_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)13.0, (double)8.0, (double)16.0), Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0)});
    public static final VoxelShape CORNER_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)16.0, (double)8.0, (double)13.0), TABLE_LEG_SW});
    public static final VoxelShape CORNER_INTERIOR_N = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TABLE_LEG_NE);
    public static final VoxelShape CORNER_INTERSECTION_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{TABLE_LEG_SW, Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)16.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)10.0)});
    public static final VoxelShape T_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0), TABLE_LEG_SE, TABLE_LEG_NE});
    public static final VoxelShape T_INTERSECTION_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TABLE_LEG_NW, TABLE_LEG_NE});
    public static final VoxelShape EDGE_N = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)3.0, (double)6.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0));
    public static final VoxelShape EDGE_INTERIOR_RIGHT_N = Shapes.m_83110_((VoxelShape)EDGE_N, (VoxelShape)TABLE_LEG_NE);
    public static final VoxelShape EDGE_INTERIOR_LEFT_N = Shapes.m_83110_((VoxelShape)EDGE_N, (VoxelShape)TABLE_LEG_SE);
    public static final VoxelShape CENTER = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CROSS = Shapes.m_83110_((VoxelShape)STANDALONE, (VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final VoxelShape CROSS_SINGLE_INTERCARDINAL_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TABLE_LEG_NW, TABLE_LEG_SW, TABLE_LEG_SE});
    public static final VoxelShape CROSS_DIAGONAL_INTERCARDINAL_N = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TABLE_LEG_NE, TABLE_LEG_SW});
    private static final HashMap<TableShape, List<VoxelShape>> VoxelLookup = new HashMap();

    public TableBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)((Object)TableShape.STANDALONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, SHAPE});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level blockGetter = pContext.m_43725_();
        BlockPos myPos = pContext.m_8083_();
        return this.calculateStateFromSurroundings(this.m_49966_(), (BlockGetter)blockGetter, myPos);
    }

    private BlockState calculateStateFromSurroundings(BlockState input, BlockGetter blockGetter, BlockPos myPos) {
        Direction calculatedFacing = Direction.NORTH;
        TableShape calculatedShape = TableShape.STANDALONE;
        boolean connectEast = this.canConnectTo(blockGetter, myPos, Direction.EAST);
        boolean connectWest = this.canConnectTo(blockGetter, myPos, Direction.WEST);
        boolean connectNorth = this.canConnectTo(blockGetter, myPos, Direction.NORTH);
        boolean connectSouth = this.canConnectTo(blockGetter, myPos, Direction.SOUTH);
        boolean ic_NW = this.checkIntercardinal(blockGetter, myPos, Direction.NORTH, Direction.WEST);
        boolean ic_NE = this.checkIntercardinal(blockGetter, myPos, Direction.NORTH, Direction.EAST);
        boolean ic_SE = this.checkIntercardinal(blockGetter, myPos, Direction.SOUTH, Direction.EAST);
        boolean ic_SW = this.checkIntercardinal(blockGetter, myPos, Direction.SOUTH, Direction.WEST);
        int num_connections = (connectEast ? 1 : 0) + (connectWest ? 1 : 0) + (connectNorth ? 1 : 0) + (connectSouth ? 1 : 0);
        int num_intercardinals = (ic_NW ? 1 : 0) + (ic_NE ? 1 : 0) + (ic_SW ? 1 : 0) + (ic_SE ? 1 : 0);
        block0 : switch (num_connections) {
            case 1: {
                calculatedShape = TableShape.END;
                if (connectEast) {
                    calculatedFacing = Direction.EAST;
                    break;
                }
                if (connectWest) {
                    calculatedFacing = Direction.WEST;
                    break;
                }
                if (connectNorth) {
                    calculatedFacing = Direction.NORTH;
                    break;
                }
                if (!connectSouth) break;
                calculatedFacing = Direction.SOUTH;
                break;
            }
            case 2: {
                if (connectEast && connectEast == connectWest) {
                    calculatedShape = TableShape.STRAIGHT;
                    calculatedFacing = Direction.EAST;
                    break;
                }
                if (connectNorth && connectNorth == connectSouth) {
                    calculatedShape = TableShape.STRAIGHT;
                    calculatedFacing = Direction.NORTH;
                    break;
                }
                if (connectNorth && connectEast) {
                    calculatedFacing = Direction.NORTH;
                    calculatedShape = ic_NE ? TableShape.CORNER_INTERSECTION : TableShape.CORNER;
                    break;
                }
                if (connectSouth && connectEast) {
                    calculatedFacing = Direction.EAST;
                    calculatedShape = ic_SE ? TableShape.CORNER_INTERSECTION : TableShape.CORNER;
                    break;
                }
                if (connectSouth && connectWest) {
                    calculatedFacing = Direction.SOUTH;
                    calculatedShape = ic_SW ? TableShape.CORNER_INTERSECTION : TableShape.CORNER;
                    break;
                }
                calculatedFacing = Direction.WEST;
                calculatedShape = ic_NW ? TableShape.CORNER_INTERSECTION : TableShape.CORNER;
                break;
            }
            case 3: {
                if (connectNorth && connectEast && connectSouth) {
                    calculatedShape = ic_NE && ic_SE ? TableShape.EDGE : (ic_NE ? TableShape.EDGE_INTERIOR_LEFT : (ic_SE ? TableShape.EDGE_INTERIOR_RIGHT : TableShape.T));
                    calculatedFacing = Direction.NORTH;
                    break;
                }
                if (connectWest && connectSouth && connectEast) {
                    calculatedShape = ic_SE && ic_SW ? TableShape.EDGE : (ic_SE ? TableShape.EDGE_INTERIOR_LEFT : (ic_SW ? TableShape.EDGE_INTERIOR_RIGHT : TableShape.T));
                    calculatedFacing = Direction.EAST;
                    break;
                }
                if (connectNorth && connectWest && connectSouth) {
                    calculatedShape = ic_NW && ic_SW ? TableShape.EDGE : (ic_SW ? TableShape.EDGE_INTERIOR_LEFT : (ic_NW ? TableShape.EDGE_INTERIOR_RIGHT : TableShape.T));
                    calculatedFacing = Direction.SOUTH;
                    break;
                }
                calculatedShape = ic_NW && ic_NE ? TableShape.EDGE : (ic_NW ? TableShape.EDGE_INTERIOR_LEFT : (ic_NE ? TableShape.EDGE_INTERIOR_RIGHT : TableShape.T));
                calculatedFacing = Direction.WEST;
                break;
            }
            case 4: {
                switch (num_intercardinals) {
                    case 4: {
                        calculatedShape = TableShape.CENTER;
                        break block0;
                    }
                    case 3: {
                        calculatedShape = TableShape.CORNER_INTERIOR;
                        if (!ic_NE) {
                            calculatedFacing = Direction.NORTH;
                            break block0;
                        }
                        if (!ic_SE) {
                            calculatedFacing = Direction.EAST;
                            break block0;
                        }
                        if (!ic_SW) {
                            calculatedFacing = Direction.SOUTH;
                            break block0;
                        }
                        if (ic_NW) break block0;
                        calculatedFacing = Direction.WEST;
                        break block0;
                    }
                    case 2: {
                        calculatedShape = TableShape.T_INTERSECTION;
                        if (ic_NE && ic_NW) {
                            calculatedFacing = Direction.SOUTH;
                        } else if (ic_SE && ic_SW) {
                            calculatedFacing = Direction.NORTH;
                        } else if (ic_NE && ic_SE) {
                            calculatedFacing = Direction.WEST;
                        } else if (ic_NW && ic_SW) {
                            calculatedFacing = Direction.EAST;
                        }
                        if (ic_NE && ic_SW) {
                            calculatedShape = TableShape.CROSS_DIAGONAL_INTERCARDINAL;
                            calculatedFacing = Direction.EAST;
                            break block0;
                        }
                        if (!ic_NW || !ic_SE) break block0;
                        calculatedShape = TableShape.CROSS_DIAGONAL_INTERCARDINAL;
                        break block0;
                    }
                    case 1: {
                        calculatedShape = TableShape.CROSS_SINGLE_INTERCARDINAL;
                        if (ic_NE) {
                            calculatedFacing = Direction.NORTH;
                            break block0;
                        }
                        if (ic_SE) {
                            calculatedFacing = Direction.EAST;
                            break block0;
                        }
                        if (ic_SW) {
                            calculatedFacing = Direction.SOUTH;
                            break block0;
                        }
                        if (!ic_NW) break block0;
                        calculatedFacing = Direction.WEST;
                        break block0;
                    }
                }
                calculatedShape = TableShape.CROSS;
            }
        }
        return (BlockState)((BlockState)input.m_61124_((Property)FACING, (Comparable)calculatedFacing)).m_61124_(SHAPE, (Comparable)((Object)calculatedShape));
    }

    private boolean canConnectTo(BlockGetter blockGetter, BlockPos myPos, Direction dir) {
        BlockState neighborState = blockGetter.m_8055_(myPos.m_7918_(dir.m_122429_(), dir.m_122430_(), dir.m_122431_()));
        return this.canConnectTo(neighborState, dir);
    }

    private boolean checkIntercardinal(BlockGetter blockGetter, BlockPos myPos, Direction one, Direction two) {
        BlockPos intercardinalCheck = myPos.m_121955_(one.m_122436_()).m_121955_(two.m_122436_());
        BlockState intercardinalState = blockGetter.m_8055_(intercardinalCheck);
        return intercardinalState.m_60734_() instanceof TableBlock;
    }

    private boolean canConnectTo(BlockState neighborState, Direction dir) {
        return neighborState.m_60734_() instanceof TableBlock;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return this.calculateStateFromSurroundings(pState, (BlockGetter)pLevel, pPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        TableShape tableShape = (TableShape)((Object)pState.m_61143_(SHAPE));
        Direction dir = (Direction)pState.m_61143_((Property)FACING);
        if (dir == Direction.DOWN || dir == Direction.UP) {
            return Shapes.m_83144_();
        }
        List<VoxelShape> valuesForShape = VoxelLookup.getOrDefault((Object)tableShape, Arrays.asList(Shapes.m_83144_()));
        return valuesForShape.get(dir.m_122416_() % valuesForShape.size());
    }

    private static List<VoxelShape> createHorizontalPermutations(VoxelShape northShape) {
        return Arrays.asList(BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, northShape), BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, northShape), northShape, BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, northShape));
    }

    static {
        VoxelLookup.put(TableShape.STANDALONE, Arrays.asList(STANDALONE));
        VoxelLookup.put(TableShape.END, TableBlock.createHorizontalPermutations(END_N));
        VoxelLookup.put(TableShape.STRAIGHT, TableBlock.createHorizontalPermutations(STRAIGHT_N));
        VoxelLookup.put(TableShape.CORNER, TableBlock.createHorizontalPermutations(CORNER_N));
        VoxelLookup.put(TableShape.CORNER_INTERIOR, TableBlock.createHorizontalPermutations(CORNER_INTERIOR_N));
        VoxelLookup.put(TableShape.CORNER_INTERSECTION, TableBlock.createHorizontalPermutations(CORNER_INTERSECTION_N));
        VoxelLookup.put(TableShape.T, TableBlock.createHorizontalPermutations(T_N));
        VoxelLookup.put(TableShape.T_INTERSECTION, TableBlock.createHorizontalPermutations(T_INTERSECTION_N));
        VoxelLookup.put(TableShape.EDGE, TableBlock.createHorizontalPermutations(EDGE_N));
        VoxelLookup.put(TableShape.EDGE_INTERIOR_LEFT, TableBlock.createHorizontalPermutations(EDGE_INTERIOR_LEFT_N));
        VoxelLookup.put(TableShape.EDGE_INTERIOR_RIGHT, TableBlock.createHorizontalPermutations(EDGE_INTERIOR_RIGHT_N));
        VoxelLookup.put(TableShape.CENTER, Arrays.asList(CENTER));
        VoxelLookup.put(TableShape.CROSS, Arrays.asList(CROSS));
        VoxelLookup.put(TableShape.CROSS_SINGLE_INTERCARDINAL, TableBlock.createHorizontalPermutations(CROSS_SINGLE_INTERCARDINAL_N));
        VoxelLookup.put(TableShape.CROSS_DIAGONAL_INTERCARDINAL, TableBlock.createHorizontalPermutations(CROSS_DIAGONAL_INTERCARDINAL_N));
    }
}

