/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.sorcery;

import com.google.common.collect.ImmutableMap;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.blocks.BlockInit;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;

public class HellfireBlock
extends BaseFireBlock
implements ICutoutBlock,
IDontCreateBlockItem,
IForgeBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(facingProperty -> facingProperty.getKey() != Direction.DOWN).collect(Util.m_137448_());
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;
    private final Object2IntMap<Block> encouragements = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> flammabilities = new Object2IntOpenHashMap();

    public HellfireBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.LIME).m_60955_().m_60910_().m_60966_().m_60953_(state -> 15).m_60918_(SoundType.f_56745_), 3.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().filter(p_242674_0_ -> (Integer)p_242674_0_.m_61143_((Property)AGE) == 0).collect(Collectors.toMap(Function.identity(), HellfireBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState p_242673_0_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_242673_0_.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)p_242673_0_.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)p_242673_0_.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)p_242673_0_.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)p_242673_0_.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.m_83281_() ? f_49237_ : voxelshape;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? this.getFireWithAge(worldIn, currentPos, (Integer)stateIn.m_61143_((Property)AGE)) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    protected BlockState getStateForPlacement(BlockGetter blockReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = blockReader.m_8055_(blockpos);
        if (!this.canCatchFire(blockReader, pos, Direction.UP) && !blockstate.m_60783_(blockReader, blockpos, Direction.UP)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(blockReader, pos.m_121945_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((BlockGetter)worldIn, pos);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.m_186460_(pos, (Block)this, HellfireBlock.getTickCooldown(worldIn.f_46441_));
        if (worldIn.m_46469_().m_46207_(GameRules.f_46131_)) {
            if (!state.m_60710_((LevelReader)worldIn, pos)) {
                worldIn.m_7471_(pos, false);
            }
            BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
            boolean flag = blockstate.isFireSource((LevelReader)worldIn, pos, Direction.UP);
            int i = (Integer)state.m_61143_((Property)AGE);
            if (!flag && worldIn.m_46471_() && this.canDie((Level)worldIn, pos) && rand.m_188501_() < 0.2f + (float)i * 0.03f) {
                worldIn.m_7471_(pos, false);
            } else {
                boolean flag1;
                int j = Math.min(15, i + rand.m_188503_(3) / 2);
                if (i != j) {
                    state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j));
                    worldIn.m_7731_(pos, state, 4);
                }
                if (!flag) {
                    if (!this.areNeighborsFlammable((BlockGetter)worldIn, pos)) {
                        BlockPos blockpos = pos.m_7495_();
                        if (!worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) || i > 3) {
                            worldIn.m_7471_(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.m_188503_(4) == 0 && !this.canCatchFire((BlockGetter)worldIn, pos.m_7495_(), Direction.UP)) {
                        worldIn.m_7471_(pos, false);
                        return;
                    }
                }
                int k = (flag1 = worldIn.m_204166_(pos).m_203656_(BiomeTags.f_263839_)) ? -50 : 0;
                this.tryCatchFire((Level)worldIn, pos.m_122029_(), 300 + k, rand, i, Direction.WEST);
                this.tryCatchFire((Level)worldIn, pos.m_122024_(), 300 + k, rand, i, Direction.EAST);
                this.tryCatchFire((Level)worldIn, pos.m_7495_(), 250 + k, rand, i, Direction.UP);
                this.tryCatchFire((Level)worldIn, pos.m_7494_(), 250 + k, rand, i, Direction.DOWN);
                this.tryCatchFire((Level)worldIn, pos.m_122012_(), 300 + k, rand, i, Direction.SOUTH);
                this.tryCatchFire((Level)worldIn, pos.m_122019_(), 300 + k, rand, i, Direction.NORTH);
                BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutable.m_122154_((Vec3i)pos, l, j1, i1);
                            int l1 = this.getNeighborEncouragement((LevelReader)worldIn, (BlockPos)blockpos$mutable);
                            if (l1 <= 0) continue;
                            int i2 = (l1 + 40 + worldIn.m_46791_().m_19028_() * 7) / (i + 30);
                            if (flag1) {
                                i2 /= 2;
                            }
                            if (i2 <= 0 || rand.m_188503_(k1) > i2 || worldIn.m_46471_() && this.canDie((Level)worldIn, (BlockPos)blockpos$mutable)) continue;
                            int j2 = Math.min(15, i + rand.m_188503_(5) / 4);
                            worldIn.m_7731_((BlockPos)blockpos$mutable, this.getFireWithAge((LevelAccessor)worldIn, (BlockPos)blockpos$mutable, j2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean canDie(Level worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    public int getFlammability(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.flammabilities.getInt((Object)state.m_60734_());
    }

    @Deprecated
    public int getFireSpreadSpeed(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.encouragements.getInt((Object)state.m_60734_()) * 2;
    }

    private void tryCatchFire(Level worldIn, BlockPos pos, int chance, RandomSource random, int age, Direction face) {
        int i = worldIn.m_8055_(pos).getFlammability((BlockGetter)worldIn, pos, face);
        if (random.m_188503_(chance) < i) {
            BlockState blockstate = worldIn.m_8055_(pos);
            if (random.m_188503_(age + 10) < 5) {
                int j = Math.min(age + random.m_188503_(5) / 4, 15);
                worldIn.m_7731_(pos, this.getFireWithAge((LevelAccessor)worldIn, pos, j), 3);
            } else {
                worldIn.m_7471_(pos, false);
            }
            blockstate.onCaughtFire(worldIn, pos, face, null);
        }
    }

    private BlockState getFireWithAge(LevelAccessor world, BlockPos pos, int age) {
        return (BlockState)this.getStateForPlacement((BlockGetter)world, pos).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    private boolean areNeighborsFlammable(BlockGetter worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(LevelReader worldIn, BlockPos pos) {
        if (!worldIn.m_46859_(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
            i = Math.max(blockstate.getFireSpreadSpeed((BlockGetter)worldIn, pos.m_121945_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    @Deprecated
    protected boolean m_7599_(BlockState state) {
        return this.getFireSpreadSpeed(state) > 0;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        worldIn.m_186460_(pos, (Block)this, HellfireBlock.getTickCooldown(worldIn.f_46441_));
    }

    private static int getTickCooldown(RandomSource rand) {
        return 5 + rand.m_188503_(10);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    private void setFireInfo(Block blockIn, int encouragement, int flammability) {
        if (blockIn == Blocks.f_50016_) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.encouragements.put((Object)blockIn, encouragement);
        this.flammabilities.put((Object)blockIn, flammability);
    }

    public boolean canCatchFire(BlockGetter world, BlockPos pos, Direction face) {
        return world.m_8055_(pos).isFlammable(world, pos, face);
    }

    public static void init() {
        HellfireBlock fireblock = (HellfireBlock)BlockInit.HELLFIRE.get();
        fireblock.setFireInfo(Blocks.f_50705_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50741_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50742_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50743_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50744_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50745_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50398_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50399_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50400_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50401_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50402_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50403_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50192_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50474_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50475_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50476_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50478_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50477_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50132_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50479_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50480_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50481_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50483_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50482_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50086_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50270_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50269_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50271_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50372_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50373_, 5, 20);
        fireblock.setFireInfo(Blocks.f_49999_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50000_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50001_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50002_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50003_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50004_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50010_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50005_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50006_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50007_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50008_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50009_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50044_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50045_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50046_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50047_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50048_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50049_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50011_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50012_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50013_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50014_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50015_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50043_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50050_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50051_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50052_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50053_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50054_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50055_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50078_, 30, 20);
        fireblock.setFireInfo(Blocks.f_50077_, 15, 100);
        fireblock.setFireInfo(Blocks.f_50034_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50035_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50036_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50355_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50356_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50357_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50358_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50359_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50360_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50111_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50112_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50113_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50114_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50115_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50116_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50117_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50118_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50119_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50120_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50121_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50071_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50070_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50041_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50042_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50096_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50097_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50098_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50099_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50100_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50101_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50102_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50103_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50104_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50105_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50106_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50107_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50108_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50109_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50191_, 15, 100);
        fireblock.setFireInfo(Blocks.f_50353_, 5, 5);
        fireblock.setFireInfo(Blocks.f_50335_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50716_, 15, 20);
        fireblock.setFireInfo(Blocks.f_50336_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50337_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50338_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50339_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50340_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50341_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50342_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50343_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50344_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50345_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50346_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50347_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50348_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50349_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50350_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50351_, 60, 20);
        fireblock.setFireInfo(Blocks.f_50577_, 30, 60);
        fireblock.setFireInfo(Blocks.f_50571_, 60, 60);
        fireblock.setFireInfo(Blocks.f_50616_, 60, 60);
        fireblock.setFireInfo(Blocks.f_50624_, 30, 20);
        fireblock.setFireInfo(Blocks.f_50715_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50685_, 60, 100);
        fireblock.setFireInfo(Blocks.f_50718_, 5, 20);
        fireblock.setFireInfo(Blocks.f_50717_, 30, 20);
    }
}

