/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.ManaAndArtifice;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.blocks.artifice.ConstructWorkbenchBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.entities.constructs.ai.ConstructCommandFollowAndGuard;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.constructs.animated.ConstructConstruction;
import com.mna.entities.sorcery.AffinityIcon;
import com.mna.events.EventDispatcher;
import com.mna.items.ItemInit;
import com.mna.particles.types.movers.ParticleBezierMover;
import com.mna.particles.types.movers.ParticleLerpMover;
import com.mna.particles.types.movers.ParticleSphereOrbitMover;
import com.mna.particles.types.movers.ParticleVelocityMover;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ConstructWorkbenchTile
extends BlockEntity
implements GeoBlockEntity {
    private static final String NBT_CRAFTING = "crafting";
    private static final String NBT_CRAFT_TICKS = "craft_ticks";
    private static final String NBT_CRAFTER = "crafter";
    private static final String NBT_NAME = "custom_name";
    private static final String NBT_KNOWN_POS = "known_pos";
    IConstructConstruction construct;
    private boolean crafting = false;
    private boolean entityInside = false;
    private int craftTicks = 0;
    private UUID crafter;
    ArrayList<PosAffinityData> knownPositions;
    private String constructName = null;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ConstructWorkbenchTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.CONSTRUCT_WORKBENCH.get(), pos, state);
        this.construct = new ConstructConstruction();
        this.knownPositions = new ArrayList();
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, ConstructWorkbenchTile tile) {
        if (tile.crafting) {
            if (tile.m_58904_().m_5776_()) {
                Direction facing = (Direction)state.m_61143_((Property)ConstructWorkbenchBlock.FACING);
                Vec3 me = null;
                switch (facing) {
                    case NORTH: {
                        me = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.65f), (double)pos.m_123343_());
                        break;
                    }
                    case SOUTH: {
                        me = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.65f), (double)((float)pos.m_123343_() + 1.25f));
                        break;
                    }
                    case EAST: {
                        me = new Vec3((double)((float)pos.m_123341_() + 1.0f), (double)((float)pos.m_123342_() + 1.65f), (double)((float)pos.m_123343_() + 0.5f));
                        break;
                    }
                    case WEST: {
                        me = new Vec3((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 1.65f), (double)((float)pos.m_123343_() + 0.5f));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (tile.knownPositions.size() == 0) {
                    tile.findNearbyPoints();
                }
                for (PosAffinityData pad : tile.knownPositions) {
                    Vec3 start = new Vec3((double)((float)pad.getPos().m_123341_() + 0.5f), (double)((float)pad.getPos().m_123342_() + 0.5f), (double)((float)pad.getPos().m_123343_() + 0.5f));
                    tile.getForAffinity(pad.aff, start, me);
                }
            }
            ++tile.craftTicks;
            if (tile.craftTicks >= 200 && !tile.m_58904_().m_5776_()) {
                tile.spawnConstruct(tile.crafter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private MAParticleType getForAffinity(Affinity aff, Vec3 start, Vec3 end) {
        MAParticleType particle = null;
        switch (aff) {
            case ARCANE: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())).setMaxAge(60).setMover(new ParticleLerpMover(start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_));
                break;
            }
            case EARTH: {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(new ItemStack((ItemLike)ItemInit.GREATER_MOTE_EARTH.get())).setScale(0.1f).setMover(new ParticleVelocityMover(0.0, 0.2f, 0.0, true)).setGravity(0.05f), end.f_82479_ - 1.0 + 2.0 * Math.random(), end.f_82480_ - 1.4, end.f_82481_ - 1.0 + 2.0 * Math.random(), 0.0, 0.0, 0.0);
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST_LERP.get())).setMover(new ParticleVelocityMover(0.0, 0.15f, 0.0, true)).setMaxAge(60).setScale(0.05f);
                break;
            }
            case ENDER: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())).setScale(0.15f);
                break;
            }
            case FIRE: 
            case HELLFIRE: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_LERP.get())).setScale(0.15f).setMover(new ParticleBezierMover(start, end));
                break;
            }
            case LIGHTNING: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get()));
                break;
            }
            case WATER: {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())).setColor(14, 28, 35).setScale(0.1f), start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0);
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER_LERP.get())).setScale(0.05f).setColor(0, 128, 255).setMaxAge(60).setMover(new ParticleSphereOrbitMover(end.f_82479_, end.f_82480_, end.f_82481_, 0.05, 57.29577951308232 * (double)(ManaAndArtifice.instance.proxy.getGameTicks() % 360L), 1.25));
                break;
            }
            case ICE: {
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setColor(14, 28, 35).setScale(0.1f), start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0);
                Vec3 newEnd = new Vec3(end.f_82479_ - 1.0 + Math.random() * 2.0, end.f_82480_ - 2.0, end.f_82481_ - 1.0 + Math.random() * 2.0);
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST_LERP.get())).setScale(0.1f).setColor(14, 28, 35).setMover(new ParticleLerpMover(newEnd.f_82479_, newEnd.f_82480_, newEnd.f_82481_, newEnd.f_82479_, newEnd.f_82480_ + 3.0, newEnd.f_82481_));
                break;
            }
            case WIND: {
                Vec3 controlA = start.m_82549_(end.m_82546_(start).m_82490_((double)0.33f)).m_82520_(0.0, 0.25 + Math.random(), 0.0);
                Vec3 controlB = start.m_82549_(end.m_82546_(start).m_82490_((double)0.66f)).m_82520_(0.0, 0.25 + Math.random(), 0.0);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_LERP.get())).setScale(0.2f).setColor(10, 10, 10).setMover(new ParticleBezierMover(start, end, controlA, controlB)), start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0);
                this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), end.f_82479_, end.f_82480_ - 1.0, end.f_82481_, (double)0.1f, (double)0.1f, 1.25);
                break;
            }
            default: {
                particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get()));
            }
        }
        if (particle != null) {
            this.m_58904_().m_7106_((ParticleOptions)particle, start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_);
        }
        return particle;
    }

    public int getCraftTicks() {
        return this.craftTicks;
    }

    public ArrayList<PosAffinityData> getKnownPositions() {
        return this.knownPositions;
    }

    public boolean getIsCrafting() {
        return this.crafting;
    }

    public ItemStack placePart(ItemStack stack) {
        if (this.crafting || stack.m_41613_() != 1 || !(stack.m_41720_() instanceof ItemConstructPart)) {
            return stack;
        }
        ItemStack output = this.construct.setPart(stack);
        if (!this.m_58904_().m_5776_()) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
        }
        return output;
    }

    public ItemStack popPart() {
        ConstructSlot slot;
        ConstructSlot[] slots;
        ItemStack output = ItemStack.f_41583_;
        if (this.crafting) {
            return output;
        }
        ConstructSlot[] constructSlotArray = slots = new ConstructSlot[]{ConstructSlot.LEFT_ARM, ConstructSlot.RIGHT_ARM, ConstructSlot.TORSO, ConstructSlot.HEAD, ConstructSlot.LEGS};
        int n = constructSlotArray.length;
        for (int i = 0; i < n && (output = this.construct.removePart(slot = constructSlotArray[i])).m_41619_(); ++i) {
        }
        if (!this.m_58904_().m_5776_()) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
        }
        return output;
    }

    public void setConstructData(IConstructConstruction data, String name) {
        if (!this.m_58904_().m_5776_()) {
            this.construct = data.copy();
            this.constructName = name;
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ConstructWorkbenchBlock.HAS_PART, (Comparable)Boolean.valueOf(!this.construct.isEmpty())), 3);
        }
    }

    private void spawnConstruct(UUID owner) {
        if (this.construct.isComplete() && !this.m_58904_().m_5776_()) {
            this.crafting = false;
            this.craftTicks = 0;
            this.crafter = null;
            Construct eac = new Construct(this.f_58857_);
            BlockPos pos = this.m_58899_();
            Direction dir = (Direction)this.m_58900_().m_61143_((Property)ConstructWorkbenchBlock.FACING);
            Vec3 fwdDir = new Vec3((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_());
            Vec3 vPos = new Vec3((double)((float)pos.m_123341_() + 0.5f) + fwdDir.f_82479_, (double)pos.m_123342_() + 0.5, (double)((float)pos.m_123343_() + 0.5f) + fwdDir.f_82481_);
            eac.m_7678_(vPos.f_82479_, vPos.f_82480_, vPos.f_82481_, 0.0f, 0.0f);
            eac.m_7618_(EntityAnchorArgument.Anchor.FEET, vPos.m_82549_(fwdDir.m_82490_(10.0)));
            if (this.constructName != null) {
                eac.m_6593_((Component)Component.m_237113_((String)this.constructName));
                this.constructName = null;
            }
            eac.setOwner(owner);
            HashMap affinities = new HashMap();
            this.getNearbyEntities().forEach(e -> {
                if (!affinities.containsKey((Object)e.getAffinity())) {
                    affinities.put(e.getAffinity(), 1);
                } else {
                    affinities.put(e.getAffinity(), (Integer)affinities.get((Object)e.getAffinity()) + 1);
                }
                e.m_142687_(Entity.RemovalReason.DISCARDED);
            });
            for (Affinity aff : Affinity.values()) {
                this.construct.setAffinityScore(aff, 0);
            }
            for (Affinity aff : affinities.keySet()) {
                this.construct.setAffinityScore(aff, (Integer)affinities.get((Object)aff));
            }
            eac.setConstructParts(this.construct);
            this.m_58904_().m_7967_((Entity)eac);
            this.m_6596_();
            this.construct = new ConstructConstruction();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            Player player = this.f_58857_.m_46003_(owner);
            if (player != null) {
                EventDispatcher.DispatchConstructCrafted(eac, player);
                if (player instanceof ServerPlayer) {
                    CustomAdvancementTriggers.SUMMON_CONSTRUCT.trigger((ServerPlayer)player, eac);
                }
            }
            ConstructCommandFollowAndGuard task = (ConstructCommandFollowAndGuard)ConstructTasks.FOLLOW_DEFEND.instantiateTask(eac);
            task.setFollowTarget((LivingEntity)player);
            task.setShouldGuard(false);
            eac.setCurrentCommand(player, task, true);
        }
    }

    private List<AffinityIcon> getNearbyEntities() {
        int search_radius = 5;
        final Vec3 myVec = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f));
        AABB bb = new AABB(this.m_58899_()).m_82400_((double)search_radius);
        List<AffinityIcon> entities = this.m_58904_().m_45976_(AffinityIcon.class, bb).stream().map(e -> e).sorted(new Comparator<AffinityIcon>(){

            @Override
            public int compare(AffinityIcon o1, AffinityIcon o2) {
                Double d1 = o1.m_20182_().m_82557_(myVec);
                Double d2 = o2.m_20182_().m_82557_(myVec);
                return d1.compareTo(d2);
            }
        }).limit(8L).collect(Collectors.toList());
        return entities;
    }

    private boolean findNearbyPoints() {
        List<AffinityIcon> entities = this.getNearbyEntities();
        if (entities.size() < 8) {
            return false;
        }
        this.knownPositions.clear();
        entities.stream().forEach(e -> this.knownPositions.add(new PosAffinityData(BlockPos.m_274446_((Position)e.m_20182_()), e.getAffinity())));
        return true;
    }

    public boolean isEmpty() {
        return this.construct.isEmpty();
    }

    public boolean startCrafting(@Nonnull Player player) {
        if (!this.crafting && this.construct.isComplete() && !this.m_58904_().m_5776_() && this.findNearbyPoints()) {
            this.crafting = true;
            this.craftTicks = 0;
            this.crafter = player.m_20148_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            return true;
        }
        return false;
    }

    public boolean summonConstructImmediately(@Nonnull Player player) {
        if (!this.crafting && this.construct.isComplete() && !this.m_58904_().m_5776_()) {
            this.spawnConstruct(player.m_20148_());
            return true;
        }
        return false;
    }

    private void writeKnownPositions(CompoundTag nbt) {
        CompoundTag known = new CompoundTag();
        known.m_128405_("count", this.knownPositions.size());
        for (int i = 0; i < this.knownPositions.size(); ++i) {
            known.m_128365_("pos" + i, (Tag)NbtUtils.m_129224_((BlockPos)this.knownPositions.get(i).getPos()));
            known.m_128359_("aff" + i, this.knownPositions.get(i).getAffinity().toString());
        }
        nbt.m_128365_(NBT_KNOWN_POS, (Tag)known);
    }

    private void readKnownPositions(CompoundTag nbt) {
        if (nbt.m_128441_(NBT_KNOWN_POS)) {
            CompoundTag known = nbt.m_128469_(NBT_KNOWN_POS);
            int count = known.m_128451_("count");
            this.knownPositions.clear();
            for (int i = 0; i < count; ++i) {
                try {
                    BlockPos pos = NbtUtils.m_129239_((CompoundTag)known.m_128469_("pos" + i));
                    Affinity aff = Affinity.valueOf(known.m_128461_("aff" + i));
                    this.knownPositions.add(new PosAffinityData(pos, aff));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void m_183515_(CompoundTag base) {
        this.construct.WriteNBT(base);
        base.m_128379_(NBT_CRAFTING, this.crafting);
        base.m_128405_(NBT_CRAFT_TICKS, this.craftTicks);
        base.m_128359_(NBT_CRAFTER, this.crafter != null ? this.crafter.toString() : "");
        if (this.constructName != null) {
            base.m_128359_(NBT_NAME, this.constructName);
        }
        this.writeKnownPositions(base);
    }

    public void m_142466_(CompoundTag nbt) {
        String crafterUUIDString;
        super.m_142466_(nbt);
        this.construct.ReadNBT(nbt);
        if (nbt.m_128441_(NBT_CRAFTING)) {
            this.crafting = nbt.m_128471_(NBT_CRAFTING);
        }
        if (nbt.m_128441_(NBT_CRAFT_TICKS)) {
            this.craftTicks = nbt.m_128451_(NBT_CRAFT_TICKS);
        }
        if (nbt.m_128441_(NBT_CRAFTER) && !(crafterUUIDString = nbt.m_128461_(NBT_CRAFTER)).isEmpty()) {
            this.crafter = UUID.fromString(crafterUUIDString);
        }
        if (nbt.m_128441_(NBT_NAME)) {
            this.constructName = nbt.m_128461_(NBT_NAME);
        }
        this.readKnownPositions(nbt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        boolean wasCrafting = this.crafting;
        this.construct.ReadNBT(nbt);
        if (nbt.m_128441_(NBT_CRAFTING)) {
            this.crafting = nbt.m_128471_(NBT_CRAFTING);
        }
        if (nbt.m_128441_(NBT_CRAFT_TICKS)) {
            this.craftTicks = nbt.m_128451_(NBT_CRAFT_TICKS);
        }
        if (this.crafting && !wasCrafting) {
            BlockPos soundPos = this.m_58899_();
            this.m_58904_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), (double)soundPos.m_123341_(), (double)soundPos.m_123342_(), (double)soundPos.m_123343_(), SFX.Event.Block.GANTRY_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.readKnownPositions(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag payload = super.m_5995_();
        this.construct.WriteNBT(payload);
        payload.m_128379_(NBT_CRAFTING, this.crafting);
        payload.m_128405_(NBT_CRAFT_TICKS, this.craftTicks);
        this.writeKnownPositions(payload);
        return payload;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public IConstructConstruction getConstruct() {
        return this.construct;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> {
            if (this.crafting) {
                return state.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.construct_arch.assemble"));
            }
            if (this.entityInside) {
                if (state.isCurrentAnimationStage("animation.construct_arch.idle")) {
                    state.resetCurrentAnimation();
                }
                this.entityInside = false;
            }
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.construct_arch.assemble_end").thenLoop("animation.construct_arch.idle"));
        });
        registrar.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(5.0);
    }

    public void swing() {
        this.entityInside = true;
    }

    class PosAffinityData {
        BlockPos pos;
        Affinity aff;

        public PosAffinityData(BlockPos pos, Affinity affinity) {
            this.aff = affinity;
            this.pos = pos;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Affinity getAffinity() {
            return this.aff;
        }
    }
}

