/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.tools.MATags;
import com.mna.blocks.tileentities.init.TileEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ScrollShelfTile
extends TileEntityWithInventory {
    private int scrollFlags = 0;
    private int bottleFlags = 0;

    public ScrollShelfTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.SCROLLSHELF.get(), pos, state, 81);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        this.updateScrollFlags();
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("scrollFlags", this.scrollFlags);
        tag.m_128405_("bottleFlags", this.bottleFlags);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("scrollFlags")) {
            this.scrollFlags = tag.m_128451_("scrollFlags");
        }
        if (tag.m_128441_("bottleFlags")) {
            this.bottleFlags = tag.m_128451_("bottleFlags");
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.scrollFlags = 0;
            this.bottleFlags = 0;
            if (compoundtag.m_128441_("scrollFlags")) {
                this.scrollFlags = compoundtag.m_128451_("scrollFlags");
            }
            if (compoundtag.m_128441_("bottleFlags")) {
                this.bottleFlags = compoundtag.m_128451_("bottleFlags");
            }
        }
    }

    public boolean isScrollDisplayable(int index) {
        return (this.scrollFlags & 1 << index) != 0;
    }

    public boolean displayAsBottle(int index) {
        return (this.bottleFlags & 1 << index) != 0;
    }

    private void updateScrollFlags() {
        this.scrollFlags = 0;
        this.bottleFlags = 0;
        for (int i = 0; i < 18; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            this.scrollFlags |= 1 << i;
            if (!MATags.isItemIn(this.m_8020_(i).m_41720_(), MATags.Items.SCROLL_SHELF_POTIONS)) continue;
            this.bottleFlags |= 1 << i;
        }
    }

    @Override
    public int[] m_7071_(Direction side) {
        int[] items = new int[this.m_6643_()];
        for (int i = 0; i < this.m_6643_(); ++i) {
            items[i] = i;
        }
        return items;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82363_(0.0, 1.0, 0.0);
    }
}

