/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TransitoryTunnelTile
extends BlockEntity {
    private int duration = 20;
    private int age;
    private BlockState previousBlockState = Blocks.f_50016_.m_49966_();

    public TransitoryTunnelTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.TRANSITORY_TUNNEL.get(), pos, state);
    }

    public void setDurationAndPreviousState(int duration, BlockState previous) {
        this.duration = duration;
        this.previousBlockState = previous;
    }

    public static void ServerTick(Level level, BlockPos pos, BlockState state, TransitoryTunnelTile tile) {
        ++tile.age;
        if (tile.age > tile.duration) {
            level.m_7731_(pos, tile.previousBlockState, 2);
        }
    }

    public void m_183515_(CompoundTag compound) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("duration", this.duration);
        nbt.m_128405_("age", this.age);
        nbt.m_128359_("blockState", BlockStateParser.m_116769_((BlockState)this.previousBlockState));
        compound.m_128365_("tunnelData", (Tag)nbt);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("tunnelData")) {
            CompoundTag nbt = compound.m_128469_("tunnelData");
            if (nbt.m_128441_("duration")) {
                this.duration = nbt.m_128451_("duration");
            }
            if (nbt.m_128441_("age")) {
                this.age = nbt.m_128451_("age");
            }
            if (nbt.m_128441_("blockState")) {
                try {
                    this.previousBlockState = BlockStateParser.m_245437_((HolderLookup)this.f_58857_.m_246945_(Registries.f_256747_), (String)nbt.m_128461_("blockState"), (boolean)true).f_234748_();
                }
                catch (CommandSyntaxException e) {
                    this.previousBlockState = Blocks.f_50016_.m_49966_();
                    e.printStackTrace();
                }
            }
            if (this.previousBlockState == null) {
                this.previousBlockState = Blocks.f_50016_.m_49966_();
            }
        }
    }
}

