/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.pylon;

import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.init.TileEntityInit;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class FreezePylonTile
extends PylonTileBase {
    private static final ResourceLocation icon = RLoc.create("textures/gui/pylon/freeze.png");

    public FreezePylonTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public FreezePylonTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TileEntityInit.FREEZE_PYLON.get(), pPos, pBlockState);
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, FreezePylonTile tile) {
        if (tile.tick()) {
            int n = tile.powerUpTicks;
            Objects.requireNonNull(tile);
            if (n == 60) {
                tile.forAllBlocks(20, (cPos, cState) -> {
                    FluidState flState;
                    if (cState.m_60713_(Blocks.f_49990_) && (flState = level.m_6425_(cPos)) != null) {
                        if (flState.m_76170_()) {
                            level.m_7731_(cPos, Blocks.f_50126_.m_49966_(), 3);
                        } else {
                            int amt = flState.m_76186_();
                            BlockState snowState = Blocks.f_50125_.m_49966_();
                            if ((snowState = (BlockState)snowState.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(Math.min(Math.max(amt, 1), 8)))).m_60710_((LevelReader)level, cPos)) {
                                level.m_7731_(cPos, snowState, 3);
                            }
                        }
                    }
                });
            }
        }
    }
}

