/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.blocks.artifice.FluidJugBlock;
import com.mna.blocks.tileentities.FluidJugTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class FluidJugRenderer
implements BlockEntityRenderer<FluidJugTile> {
    public FluidJugRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FluidJugTile jug, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = jug.m_58900_();
        FluidStack flStack = jug.getContainedFluid();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((Fluid)flStack.getFluid());
        matrixStackIn.m_85836_();
        if (state.m_61143_((Property)FluidJugBlock.f_54117_) == Direction.WEST || state.m_61143_((Property)FluidJugBlock.f_54117_) == Direction.EAST) {
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrixStackIn.m_85837_(-0.5, 0.1875, 0.3125);
        } else {
            matrixStackIn.m_85837_(0.5, 0.1875, 0.3125);
        }
        this.renderFluidBar(matrixStackIn, bufferIn, combinedLightIn, partialTicks, extension, jug.getFillPct(), jug.isInfinite());
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        if (state.m_61143_((Property)FluidJugBlock.f_54117_) == Direction.WEST || state.m_61143_((Property)FluidJugBlock.f_54117_) == Direction.EAST) {
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrixStackIn.m_85837_(-0.5, 0.1875, 0.6875);
        } else {
            matrixStackIn.m_85837_(0.5, 0.1875, 0.6875);
        }
        this.renderFluidBar(matrixStackIn, bufferIn, combinedLightIn, partialTicks, extension, jug.getFillPct(), jug.isInfinite());
        matrixStackIn.m_85849_();
    }

    private void renderFluidBar(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLight, float partialTicks, IClientFluidTypeExtensions attrs, float fillPct, boolean infinite) {
        float width = infinite ? 0.08f : 0.12f;
        float min = infinite ? 0.02f : 0.0f;
        float height = infinite ? 0.2f : 0.5f;
        ResourceLocation fluidTexBase = attrs.getStillTexture();
        if (fluidTexBase == null) {
            return;
        }
        TextureAtlasSprite sp = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidTexBase);
        RenderType liquid = RenderType.m_110431_((ResourceLocation)TextureAtlas.f_118259_);
        VertexConsumer builder = bufferIn.m_6299_(liquid);
        int color = attrs.getTintColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float[] rgba = new float[]{r, g, b, a};
        Matrix3f normal = ((PoseStack.Pose)matrixStackIn.f_85834_.getLast()).m_252943_();
        Matrix4f pos = ((PoseStack.Pose)matrixStackIn.f_85834_.getLast()).m_252922_();
        Vector3f nrm = new Vector3f(0.0f, 1.0f, 0.0f);
        nrm.mul((Matrix3fc)normal);
        float maxV = sp.m_118411_() + (sp.m_118412_() - sp.m_118411_()) * fillPct;
        float minU = sp.m_118367_(0.0);
        float maxU = sp.m_118367_(8.0);
        builder.m_252986_(pos, -width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(minU, sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(maxU, sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, width, min + height * fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(maxU, maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(pos, -width, min + height * fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(minU, maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
    }
}

