/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.renderers;

import com.mna.api.tools.RLoc;
import com.mna.blocks.artifice.LodestarBlock;
import com.mna.blocks.tileentities.LodestarTile;
import com.mna.blocks.tileentities.models.ModelLodestar;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class LodestarRenderer
extends GeoBlockRenderer<LodestarTile> {
    public static final ResourceLocation delegation_station = RLoc.create("block/delegation_station");
    public static final ResourceLocation base = RLoc.create("block/lodestar_base");
    public static final ResourceLocation small_crystal = RLoc.create("block/lodestar_crystalsmall");
    public static final ResourceLocation big_crystal = RLoc.create("block/lodestar_crystalbig");
    public static final ResourceLocation small_gear = RLoc.create("block/lodestar_gearsmall");
    public static final ResourceLocation stabilizer = RLoc.create("block/lodestar_stabilizer");
    protected Minecraft mc = Minecraft.m_91087_();
    protected boolean low_tier;

    public LodestarRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new ModelLodestar());
    }

    public RenderType getRenderType(LodestarTile animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110476_((ResourceLocation)texture);
    }

    public void renderRecursively(PoseStack poseStack, LodestarTile animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.mc == null) {
            return;
        }
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
        BlockState state = animatable.m_58900_();
        BlockPos pos = animatable.m_58899_();
        if (!bone.isHidden()) {
            boolean low_tier = (Boolean)state.m_61143_((Property)LodestarBlock.LOW_TIER);
            poseStack.m_85836_();
            switch (bone.getName()) {
                case "ROOT": {
                    if (!low_tier) {
                        ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, base, poseStack, packedLight, packedOverlay);
                        break;
                    }
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, delegation_station, poseStack, packedLight, packedOverlay);
                    break;
                }
                case "CRYSTAL_BIG": {
                    if (low_tier) break;
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, big_crystal, poseStack, packedLight, packedOverlay);
                    break;
                }
                case "STABILIZER": {
                    if (low_tier) break;
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, stabilizer, poseStack, packedLight, packedOverlay);
                    break;
                }
                case "GEAR_ROTATION": {
                    if (low_tier) break;
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, small_gear, poseStack, packedLight, packedOverlay);
                    break;
                }
                case "CRYSTAL_SMALL": {
                    if (low_tier) break;
                    ModelUtils.renderModel(bufferSource, (Level)this.mc.f_91073_, pos, state, small_crystal, poseStack, packedLight, packedOverlay);
                }
            }
            poseStack.m_85849_();
            for (GeoBone childBone : bone.getChildBones()) {
                this.renderRecursively(poseStack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }
}

