/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.progression;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.progression.PlayerProgression;
import com.mna.factions.Factions;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerProgressionProvider
implements ICapabilitySerializable<Tag> {
    public static final Capability<IPlayerProgression> PROGRESSION = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerProgression>(){});
    private final LazyOptional<IPlayerProgression> holder = LazyOptional.of(PlayerProgression::new);
    final String KEY_TIER = "tier";
    final String KEY_FACTION = "faction";
    final String KEY_FACTION_STANDING = "faction_standing";
    final String KEY_ALLY_COOLDOWN = "ally_cooldown";
    final String KEY_PROGRESSION = "progression_completion";
    final String KEY_RAID_CHANCE = "raid_chance_";
    final String KEY_RAID_STATS = "raid_stats_";
    final String KEY_CODEX_UNLOCKS = "codex_unlocks";

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return PROGRESSION.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        IPlayerProgression instance = (IPlayerProgression)this.holder.orElse(null);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("tier", instance.getTier());
        nbt.m_128405_("ally_cooldown", instance.getAllyCooldown());
        if (instance.hasAlliedFaction()) {
            nbt.m_128359_("faction", Registries.Factions.get().getKey((Object)instance.getAlliedFaction()).toString());
            nbt.m_128405_("faction_standing", instance.getFactionStanding());
        }
        ListTag progressionSteps = new ListTag();
        for (ResourceLocation rLoc : instance.getCompletedProgressionSteps()) {
            progressionSteps.add((Object)StringTag.m_129297_((String)rLoc.toString()));
        }
        nbt.m_128365_("progression_completion", (Tag)progressionSteps);
        for (Map.Entry f : Registries.Factions.get().getEntries()) {
            String key = "raid_chance_" + ((ResourceKey)f.getKey()).m_135782_().toString();
            nbt.m_128347_(key, instance.getRaidChance((IFaction)f.getValue()));
            key = "raid_stats_" + ((ResourceKey)f.getKey()).m_135782_().toString();
            nbt.m_128365_(key, (Tag)instance.getFactionDifficultyStats((IFaction)f.getValue()).writeToNBT());
        }
        nbt.m_128365_("codex_unlocks", (Tag)instance.saveCodexUnlocks());
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        IPlayerProgression instance = (IPlayerProgression)this.holder.orElse(null);
        if (nbt instanceof CompoundTag) {
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_("tier")) {
                instance.setTier(cnbt.m_128451_("tier"), null);
            }
            if (cnbt.m_128441_("ally_cooldown")) {
                instance.setAllyCooldown(cnbt.m_128451_("ally_cooldown"));
            }
            if (cnbt.m_128441_("faction")) {
                try {
                    ResourceLocation factionID = new ResourceLocation(cnbt.m_128461_("faction"));
                    instance.setAlliedFaction((IFaction)Registries.Factions.get().getValue(factionID), null);
                }
                catch (ResourceLocationException rex) {
                    String oldFaction;
                    ManaAndArtifice.LOGGER.info("Detected old version data, upgrading player NBT.");
                    switch (oldFaction = cnbt.m_128461_("faction")) {
                        case "ANCIENT_WIZARDS": {
                            instance.setAlliedFaction(Factions.COUNCIL, null);
                            break;
                        }
                        case "FEY_COURT": {
                            instance.setAlliedFaction(Factions.FEY, null);
                            break;
                        }
                        case "DEMONS": {
                            instance.setAlliedFaction(Factions.DEMONS, null);
                            break;
                        }
                        case "UNDEAD": {
                            instance.setAlliedFaction(Factions.UNDEAD, null);
                            break;
                        }
                        default: {
                            ManaAndArtifice.LOGGER.warn("NBT upgrade failed, clearing faction to prevent a crash.  Restore with commands.");
                            instance.setAlliedFaction(null, null);
                        }
                    }
                }
            }
            if (cnbt.m_128441_("faction_standing")) {
                instance.setFactionStanding(cnbt.m_128451_("faction_standing"));
            }
            if (cnbt.m_128425_("codex_unlocks", 10)) {
                instance.loadCodexUnlocks(cnbt.m_128469_("codex_unlocks"));
            }
            if (cnbt.m_128441_("progression_completion")) {
                ListTag progressionSteps = cnbt.m_128437_("progression_completion", 8);
                Iterator it = progressionSteps.iterator();
                while (it.hasNext()) {
                    instance.addTierProgressionComplete(new ResourceLocation(((Tag)it.next()).m_7916_()));
                }
            }
            for (Map.Entry f : Registries.Factions.get().getEntries()) {
                String key = "raid_chance_" + ((ResourceKey)f.getKey()).m_135782_().toString();
                if (cnbt.m_128441_(key)) {
                    instance.setRaidChance((IFaction)f.getValue(), cnbt.m_128459_(key));
                }
                if (!cnbt.m_128441_(key = "raid_stats_" + ((ResourceKey)f.getKey()).m_135782_().toString())) continue;
                instance.getFactionDifficultyStats((IFaction)f.getValue()).readFromNBT(cnbt.m_128469_(key));
            }
        } else {
            ManaAndArtifice.LOGGER.error("Progression NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }
}

