/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ai.CastSpellAtTargetGoal;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.tools.RLoc;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.attacks.ThrownWeapon;
import com.mna.entities.boss.effects.DemonReturnPortal;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.spells.components.ComponentFling;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.EntityUtil;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.mutable.MutableBoolean;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class DemonLord
extends BossMonster<DemonLord>
implements IFactionEnemy<DemonLord> {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    protected static final EntityDataAccessor<String> SUMMONER_UUID = SynchedEntityData.m_135353_(DemonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Boolean> IS_JOINING = SynchedEntityData.m_135353_(DemonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> PHASE = SynchedEntityData.m_135353_(DemonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> INCINERATE_ID = SynchedEntityData.m_135353_(DemonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<BlockPos> PULL_POS = SynchedEntityData.m_135353_(DemonLord.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final float LIFT_SPEED = 0.055f;
    private static final int COOLDOWN_LEAP_ID = 1024;
    private static final int COOLDOWN_SPARKS_ID = 1025;
    private static final int COOLDOWN_THUNDER_ID = 1026;
    private static final int COOLDOWN_GRASP_OF_FIRE_ID = 1027;
    private static final int COOLDOWN_HELLBALL_ID = 1028;
    private Player summonedBy;
    private LivingEntity _incinerateTarget;
    @Nullable
    private BlockPos vortexTarget = null;
    private int demonDeathTime;
    private float forceYRot = 0.0f;
    private int globalSpellCooldown = 0;
    private int queuedPhaseTransition = 0;

    public DemonLord(EntityType<? extends DemonLord> type, Level worldIn) {
        super(type, worldIn);
        this.setWeaponState(WeaponState.AXE);
    }

    public DemonLord(Level worldIn) {
        this((EntityType<? extends DemonLord>)((EntityType)EntityInit.DEMON_LORD.get()), worldIn);
    }

    public DemonLord(Level level, Vec3 position) {
        this(level);
        this.m_146884_(position);
    }

    private void lockTargetInPlace(LivingEntity target, boolean raise) {
        int duration = 200;
        target.m_21195_((MobEffect)EffectInit.LIFT.get());
        target.m_7292_(new MobEffectInstance((MobEffect)EffectInit.LIFT.get(), duration, raise ? 1 : 0));
        if (raise && target instanceof Player) {
            EntityUtil.SetLiftSpeed((Player)target, 0.055f);
        }
    }

    private void setupPhase2Transition() {
        this.m_20331_(true);
        this.m_6710_(null);
        this.setAction(Action.PHASE_2_TRANSITION);
        this.setTimer("remove_weapon", 10, () -> {
            this.setWeaponState(WeaponState.NOTHING);
            if (!this.m_9236_().m_5776_()) {
                ThrownWeapon thrown = new ThrownWeapon((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.THROWN_WEAPON.get()), (LivingEntity)this, this.m_9236_(), new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get()));
                thrown.setScale(2.0f);
                Vec3 direction = Vec3.m_82503_((Vec2)new Vec2(0.0f, this.m_146908_()));
                thrown.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.5f, 0.0f);
                this.m_9236_().m_7967_((Entity)thrown);
            }
        });
        this.setTimer("set_swords", 38, () -> {
            this.setWeaponState(WeaponState.SWORDS);
            this.m_5496_(SFX.Entity.DemonLord.DRAW_SWORDS, 1.0f, 1.0f);
        });
        this.setTimer("fire_shield", 80, () -> {
            this.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FIRE_SHIELD.get(), 99999, 2));
            this.m_5496_(SFX.Spell.Buff.FIRE, 1.0f, (float)(0.6 + Math.random() * 0.8));
            this.m_5496_(SFX.Entity.DemonLord.SCREAM, 1.0f, (float)(0.6 + Math.random() * 0.8));
        });
    }

    private void setupPhase3Transition() {
        this.m_20331_(true);
        this.setAction(Action.PHASE_3_TRANSITION);
        this.m_6710_(null);
        this.setTimer("remove_weapon", 10, () -> {
            this.setWeaponState(WeaponState.NOTHING);
            if (!this.m_9236_().m_5776_()) {
                float degreeDifference = -25.0f;
                for (int i = 0; i < 2; ++i) {
                    ThrownWeapon thrown = new ThrownWeapon((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.THROWN_WEAPON.get()), (LivingEntity)this, this.m_9236_(), new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get()));
                    thrown.setScale(2.0f);
                    Vec3 direction = Vec3.m_82503_((Vec2)new Vec2(0.0f, this.m_146908_() + degreeDifference));
                    thrown.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 2.5f, 0.0f);
                    this.m_9236_().m_7967_((Entity)thrown);
                    degreeDifference += 50.0f;
                }
            }
        });
        this.setTimer("set_staff", 64, () -> {
            this.setWeaponState(WeaponState.STAFF);
            this.m_5496_(SFX.Entity.DemonLord.SUMMON_STAFF, 1.0f, 1.0f);
        });
    }

    @Nullable
    private LivingEntity getIncinerateTarget() {
        int id = (Integer)this.f_19804_.m_135370_(INCINERATE_ID);
        if (this._incinerateTarget == null) {
            Entity e;
            if (id > -1 && (e = this.m_9236_().m_6815_(id)) != null && e instanceof LivingEntity) {
                this._incinerateTarget = (LivingEntity)e;
            }
        } else if (id == -1) {
            this._incinerateTarget = null;
        }
        return this._incinerateTarget;
    }

    @Nullable
    private Vec3 getPullPos() {
        BlockPos pos = (BlockPos)this.f_19804_.m_135370_(PULL_POS);
        if (pos == null || BlockPos.f_121853_.equals((Object)pos)) {
            return null;
        }
        return Vec3.m_82512_((Vec3i)pos);
    }

    private UUID getSummonerGuid() {
        try {
            return UUID.fromString((String)this.f_19804_.m_135370_(SUMMONER_UUID));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Player getSummonedBy() {
        if (this.summonedBy == null && this.getSummonerGuid() != null) {
            this.summonedBy = this.m_9236_().m_46003_(this.getSummonerGuid());
        }
        return this.summonedBy;
    }

    private boolean naturalSpawn() {
        return (Boolean)this.f_19804_.m_135370_(IS_JOINING) == false;
    }

    public WeaponState getWeaponState() {
        int ordinal = this.getStateFlag() & 3;
        if (ordinal < WeaponState.values().length) {
            return WeaponState.values()[ordinal];
        }
        return WeaponState.NOTHING;
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    private AttackAction getAttackAction() {
        int ordinal = (this.getStateFlag() & 0xFFFF) >> 12 & 0xF;
        if (ordinal >= AttackAction.values().length) {
            return AttackAction.NONE;
        }
        return AttackAction.values()[ordinal];
    }

    private boolean isPhaseTransitioning() {
        return this.getAction() == Action.PHASE_2_TRANSITION || this.getAction() == Action.PHASE_3_TRANSITION;
    }

    public void setSummoner(Player player) {
        if (player == null || player.m_36316_() == null) {
            return;
        }
        this.f_19804_.m_135381_(IS_JOINING, (Object)true);
        this.f_19804_.m_135381_(SUMMONER_UUID, (Object)player.m_36316_().getId().toString());
        this.summonedBy = player;
        this.m_20331_(true);
        this.f_21345_.f_25345_.clear();
        this.f_21346_.f_25345_.clear();
        this.setAction(Action.FJ_WAITING_ITEM);
    }

    private void setWeaponState(WeaponState state) {
        byte ordinal = (byte)(state.ordinal() & 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFFFFC;
        this.setState(flag |= ordinal);
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    private void setAttackAction(AttackAction action) {
        int ordinal = (action.ordinal() & 0xF) << 12;
        int flag = this.getStateFlag();
        flag &= 0xFFFF0FFF;
        this.setState(flag |= ordinal);
    }

    private void setIncinerateTarget(@Nullable LivingEntity target) {
        this._incinerateTarget = target;
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(INCINERATE_ID, (Object)(target != null ? target.m_19879_() : -1));
        }
    }

    private void setPullPos(@Nullable BlockPos pos) {
        this.f_19804_.m_135381_(PULL_POS, (Object)(pos == null ? BlockPos.f_121853_ : pos));
    }

    @Override
    protected void spawnParticles() {
        Vec3 graspPos;
        for (int i = 0; i < 10; ++i) {
            LivingEntity incinerateTarget = this.getIncinerateTarget();
            if (incinerateTarget == null) continue;
            float bbOffset = incinerateTarget.m_20205_();
            float bbHeightOffset = incinerateTarget.m_20206_() / 2.0f;
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), incinerateTarget.m_20185_() - (double)(bbOffset / 2.0f) + Math.random() * (double)bbOffset, incinerateTarget.m_20186_() - (double)bbHeightOffset, incinerateTarget.m_20189_() - (double)(bbOffset / 2.0f) + Math.random() * (double)bbOffset, 0.0, 0.165 + Math.random() * 0.165, 0.0);
        }
        if (this.getAction() == Action.GRASP_OF_FIRE && (graspPos = this.getPullPos()) != null) {
            for (int i = 0; i < 10; ++i) {
                Vec3 pos = graspPos.m_82520_(-2.0 + Math.random() * 4.0, -2.0 + Math.random() * 4.0, -2.0 + Math.random() * 4.0);
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_LERP.get())).setScale(0.2f).setColor(10, 10, 10).setMaxAge(5 + (int)(Math.random() * 5.0)), pos.f_82479_, pos.f_82480_, pos.f_82481_, graspPos.f_82479_, graspPos.f_82480_, graspPos.f_82481_);
            }
        }
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(80);
        this.m_21153_(this.m_21233_() / 3.0f);
    }

    @Override
    protected int defaultState() {
        int flags = WeaponState.AXE.ordinal() & 3;
        return flags;
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return RLoc.create("faction/boss/demon_arena");
    }

    @Override
    public int getArenaStructureSegment() {
        return 0;
    }

    @Override
    public void m_8119_() {
        if (this.m_21223_() < 1.0f && (this.queuedPhaseTransition > 0 || this.getAction() == Action.PHASE_2_TRANSITION || this.getAction() == Action.PHASE_3_TRANSITION)) {
            this.m_20331_(true);
            this.m_21153_(1.0f);
        }
        if (this.getAction() == Action.IDLE) {
            if (this.queuedPhaseTransition == 2) {
                this.setupPhase2Transition();
                this.queuedPhaseTransition = -1;
            } else if (this.queuedPhaseTransition == 3) {
                this.setupPhase3Transition();
                this.queuedPhaseTransition = -1;
            }
        }
        super.m_8119_();
        if (this.globalSpellCooldown > 0) {
            --this.globalSpellCooldown;
        }
        if (this.getAction() == Action.DEATH) {
            this.m_146922_(this.forceYRot);
        }
        boolean remove = false;
        if (this._incinerateTarget != null && !this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 10L == 0L) {
            float incinerateDamage = this.naturalSpawn() ? 6.0f : (float)(6 + 2 * (Byte)this.f_19804_.m_135370_(PHASE));
            this._incinerateTarget.m_6469_(this.m_269291_().m_269387_(), incinerateDamage);
        }
        if (!this.naturalSpawn()) {
            if (this.getSummonedBy() == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.getSummonedBy().m_146892_());
            if (this.getSummonedBy().m_21224_() || this.getSummonedBy().m_20280_((Entity)this) > 256.0) {
                remove = true;
            } else {
                boolean bl = remove = this.f_19797_ > 700;
            }
            if (remove && !this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else if (this.getAction() == Action.PHASE_2_TRANSITION || this.getAction() == Action.PHASE_3_TRANSITION) {
            this.m_21573_().m_26573_();
            this.m_20256_(Vec3.f_82478_);
            if (this.m_5448_() != null) {
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_20182_());
            }
            this.m_5634_(2.5f);
            if (this.m_21223_() == this.m_21233_()) {
                this.f_19804_.m_135381_(PHASE, (Object)((byte)((Byte)this.f_19804_.m_135370_(PHASE) + 1)));
                this.m_20331_(false);
                this.setAction(Action.IDLE);
            }
        } else if (this.getAction() == Action.IDLE && this.m_20147_()) {
            this.m_20331_(false);
        }
        if (this.m_21223_() < 0.0f) {
            this.setAction(Action.DEATH);
        }
        if (this.getAction() == Action.ATTACKING && this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_5448_().m_20182_());
        }
    }

    protected void m_8099_() {
        ItemStack sparks = new ItemStack((ItemLike)ItemInit.SPELL.get());
        ItemStack thunder = new ItemStack((ItemLike)ItemInit.SPELL.get());
        ItemStack hellball = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe sparksSpell = new SpellRecipe();
        sparksSpell.setShape(Shapes.PROJECTILE);
        ((ModifiedSpellPart)sparksSpell.getShape()).setValue(Attribute.MAGNITUDE, 5.0f);
        sparksSpell.addComponent(Components.LIGHTNING_DAMAGE);
        sparksSpell.addComponent(Components.LIVING_BOMB);
        ((ModifiedSpellPart)sparksSpell.getComponent(0)).setValue(Attribute.DAMAGE, 10.0f);
        ((ModifiedSpellPart)sparksSpell.getComponent(1)).setValue(Attribute.DURATION, 5.0f);
        ((ModifiedSpellPart)sparksSpell.getComponent(1)).setValue(Attribute.MAGNITUDE, 3.0f);
        sparksSpell.writeToNBT(sparks.m_41784_());
        SpellRecipe thunderSpell = new SpellRecipe();
        thunderSpell.setShape(Shapes.SMITE);
        ((ModifiedSpellPart)thunderSpell.getShape()).setValue(Attribute.HEIGHT, 3.0f);
        ((ModifiedSpellPart)thunderSpell.getShape()).setValue(Attribute.RADIUS, 5.0f);
        thunderSpell.addComponent(Components.LIGHTNING_DAMAGE);
        ((ModifiedSpellPart)thunderSpell.getComponent(0)).setValue(Attribute.DAMAGE, 20.0f);
        ((ModifiedSpellPart)thunderSpell.getComponent(0)).setValue(Attribute.LESSER_MAGNITUDE, 10.0f);
        ((ModifiedSpellPart)thunderSpell.getComponent(0)).setValue(Attribute.RADIUS, 10.0f);
        thunderSpell.addComponent(Components.GRAVITY_WELL);
        ((ModifiedSpellPart)thunderSpell.getComponent(1)).setValue(Attribute.DURATION, 5.0f);
        thunderSpell.writeToNBT(thunder.m_41784_());
        SpellRecipe hellballSpell = new SpellRecipe();
        hellballSpell.setShape(Shapes.PROJECTILE);
        ((ModifiedSpellPart)hellballSpell.getShape()).setValue(Attribute.RADIUS, 10.0f);
        hellballSpell.addComponent(Components.EXPLOSION);
        ((ModifiedSpellPart)hellballSpell.getComponent(0)).setValue(Attribute.DAMAGE, 20.0f);
        ((ModifiedSpellPart)hellballSpell.getComponent(0)).setValue(Attribute.RADIUS, 10.0f);
        ((ModifiedSpellPart)hellballSpell.getComponent(0)).setValue(Attribute.PRECISION, 2.0f);
        hellballSpell.addComponent(Components.FLING);
        ((ModifiedSpellPart)hellballSpell.getComponent(1)).setValue(Attribute.SPEED, 3.0f);
        hellballSpell.setOverrideAffinity(Affinity.HELLFIRE);
        hellballSpell.writeToNBT(hellball.m_41784_());
        double moveSpeed = this.m_21133_(Attributes.f_22279_);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PhaseTransitionGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HellballGoal(hellball));
        this.f_21345_.m_25352_(2, (Goal)new GraspOfFireGoal());
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(sparks, moveSpeed, 300, 32.0f, 8.0f, true, 1025, 10, 20, null, () -> {
            this.setAction(Action.IDLE);
            this.setAttackAction(AttackAction.NONE);
            this.globalSpellCooldown = (Byte)this.f_19804_.m_135370_(PHASE) == 3 ? 10 + (int)(Math.random() * 30.0) : 40 + (int)(Math.random() * 60.0);
        }, me -> {
            switch ((Byte)this.f_19804_.m_135370_(PHASE)) {
                case 3: {
                    if (Math.random() < 0.5) {
                        this.setAttackAction(AttackAction.STAFF_CAST_1);
                        break;
                    }
                    this.setAttackAction(AttackAction.STAFF_CAST_2);
                    break;
                }
                default: {
                    this.setAttackAction(AttackAction.CAST_1);
                }
            }
            this.setAction(Action.ATTACKING);
            return true;
        }).setUsePredicate(e -> this.getAction() == Action.IDLE && this.globalSpellCooldown == 0));
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(thunder, moveSpeed, 300, 16.0f, 4.0f, true, 1026, 10, 20, null, () -> {
            this.setAction(Action.IDLE);
            this.setAttackAction(AttackAction.NONE);
            this.globalSpellCooldown = (Byte)this.f_19804_.m_135370_(PHASE) == 3 ? 10 + (int)(Math.random() * 30.0) : 40 + (int)(Math.random() * 60.0);
        }, me -> {
            switch ((Byte)this.f_19804_.m_135370_(PHASE)) {
                case 3: {
                    this.setAttackAction(AttackAction.STAFF_CAST_2);
                    break;
                }
                default: {
                    this.setAttackAction(AttackAction.CAST_2);
                }
            }
            this.setAction(Action.ATTACKING);
            return true;
        }).setUsePredicate(e -> this.getAction() == Action.IDLE && this.globalSpellCooldown == 0));
        this.f_21345_.m_25352_(4, (Goal)new LerpLeap(4.0f, 32.0f, 5));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, moveSpeed, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONER_UUID, (Object)"");
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(INCINERATE_ID, (Object)-1);
        this.f_19804_.m_135372_(PULL_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(IS_JOINING, (Object)false);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.naturalSpawn() && this.m_9236_().m_5776_()) {
            for (int i = 0; i < 75; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.m_20185_() - 0.5 + Math.random(), this.m_20186_() + Math.random() * 1.5, this.m_20189_() - 0.5 + Math.random(), -0.01 + Math.random() * 0.02, (double)0.15f, -0.01 + Math.random() * 0.02);
            }
            Player player = this.getSummonedBy();
            if (player != null && player.m_20270_((Entity)this) < 32.0f) {
                for (int i = 0; i < 75; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), -0.25 + Math.random() * 0.5, (double)0.15f, -0.25 + Math.random() * 0.5);
                }
            }
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.naturalSpawn()) {
            return InteractionResult.FAIL;
        }
        if (player != this.getSummonedBy()) {
            return InteractionResult.FAIL;
        }
        if (this.getAction() == Action.FJ_WAITING_ITEM && player.m_21120_(hand).m_41720_() == ItemInit.MOTE_FIRE.get()) {
            EntityUtil.SetLiftSpeed(player, 0.055f);
            if (!this.m_9236_().m_5776_()) {
                player.m_21211_().m_41774_(1);
                this.setAction(Action.FJ_IMBUING);
                this.m_9236_().m_5594_(null, this.m_20183_(), SFX.Event.Ritual.DEMON_SUMMON_CHANNEL, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.lockTargetInPlace((LivingEntity)player, false);
                this.setTimer("raise", 10, () -> this.lockTargetInPlace((LivingEntity)player, true));
                this.setTimer("advance", 202, () -> {
                    IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    if (progression != null && progression.getTier() < 5) {
                        if (progression.getAlliedFaction() == null) {
                            progression.setAlliedFaction(Factions.DEMONS, player);
                            player.m_213846_((Component)Component.m_237115_((String)"event.mna.faction_ally_demons"));
                        }
                        if (progression.getAlliedFaction() == Factions.DEMONS) {
                            progression.setTier(progression.getTier() + 1, player);
                            player.m_213846_((Component)Component.m_237110_((String)"mna:progresscondition.advanced", (Object[])new Object[]{progression.getTier()}));
                        }
                    }
                    player.m_21195_((MobEffect)EffectInit.LIFT.get());
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                });
            }
            this.setTimer("incinerate", 62, () -> {
                this.lockTargetInPlace((LivingEntity)player, false);
                this.setIncinerateTarget((LivingEntity)player);
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isOnCooldown(1) || this.getAction() != Action.IDLE) {
            return true;
        }
        ArrayList<AttackAction> actionPool = new ArrayList<AttackAction>();
        byte phase = (Byte)this.f_19804_.m_135370_(PHASE);
        if (phase == 1 || phase == 3) {
            actionPool.add(AttackAction.LEFT_OVERHEAD);
            actionPool.add(AttackAction.LEFT_SWEEP);
            actionPool.add(AttackAction.TWOHAND_OVERHEAD);
        } else if (phase == 2) {
            actionPool.add(AttackAction.LEFT_OVERHEAD);
            actionPool.add(AttackAction.LEFT_SWEEP);
            actionPool.add(AttackAction.RIGHT_OVERHEAD);
            actionPool.add(AttackAction.RIGHT_SWEEP);
            actionPool.add(AttackAction.DUALWIELD_OVERHEAD);
            actionPool.add(AttackAction.DUALWIELD_SWEEP);
        }
        AttackAction selected = (AttackAction)((Object)actionPool.get((int)((double)actionPool.size() * Math.random())));
        this.setAction(Action.ATTACKING);
        this.setAttackAction(selected);
        this.setTimer("", selected.animLength, () -> {
            this.damageEntity(entityIn);
            this.m_5496_(SFX.Entity.Odin.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
            this.m_5496_(SFX.Entity.DemonLord.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
        });
        this.setTimer("resetattack", selected.resetTime, () -> {
            this.setAttackAction(AttackAction.NONE);
            this.setAction(Action.IDLE);
            this.setCooldown(1, phase == 2 ? 10 : 20);
        });
        return true;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 375.0).m_22268_(Attributes.f_22279_, (double)0.7f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean damageEntity(Entity entityIn) {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        ArrayList<Entity> targets = new ArrayList<Entity>();
        if (this.getAttackAction() == AttackAction.LEFT_SWEEP || this.getAttackAction() == AttackAction.RIGHT_SWEEP || this.getAttackAction() == AttackAction.DUALWIELD_SWEEP) {
            EntityUtil.getEntitiesWithinCone(this.m_9236_(), this.m_20182_(), Vec3.m_82498_((float)this.m_146909_(), (float)this.m_6080_()), 6.0f, -60.0f, 60.0f, e -> e instanceof LivingEntity && e.m_6084_() && e != this && e != entityIn);
        }
        targets.add(entityIn);
        MutableBoolean hurtTarget = new MutableBoolean(false);
        targets.forEach(t -> {
            boolean hurt = t.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
            if (hurt) {
                hurtTarget.setTrue();
                if (f1 > 0.0f && t instanceof LivingEntity) {
                    ((LivingEntity)t).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (t instanceof Player) {
                    Player playerentity;
                    this.maybeDisableShield(playerentity, (playerentity = (Player)t).m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
                }
                this.m_21335_((Entity)t);
                if (this.f_19796_.m_188501_() < 0.4f && t instanceof Mob) {
                    ((Mob)t).m_6710_((LivingEntity)this);
                }
            }
        });
        return hurtTarget.getValue();
    }

    private void maybeDisableShield(Player player, ItemStack playerItem) {
        if (!playerItem.m_41619_() && playerItem.m_41720_().canPerformAction(playerItem, ToolActions.SHIELD_BLOCK) && (Byte)this.f_19804_.m_135370_(PHASE) == 1) {
            player.m_36335_().m_41524_(Items.f_42740_, 100);
            this.m_9236_().m_7605_((Entity)player, (byte)30);
        }
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (pCause.m_276093_(DamageTypes.f_268724_) && pCause.m_7639_() == null) {
            super.m_6667_(pCause);
            return;
        }
        if (this.queuedPhaseTransition > 0) {
            if (this.m_21223_() < 1.0f) {
                this.m_21153_(1.0f);
            }
            return;
        }
        byte phase = (Byte)this.f_19804_.m_135370_(PHASE);
        if (phase == 1) {
            this.m_20331_(true);
            this.m_21153_(1.0f);
            this.queuedPhaseTransition = 2;
        } else if (phase == 2) {
            this.m_20331_(true);
            this.m_21153_(1.0f);
            this.queuedPhaseTransition = 3;
        } else {
            this.setAction(Action.DEATH);
            if (!this.m_9236_().m_5776_()) {
                this.forceYRot = this.m_146908_();
                Vec3 direction = Vec3.m_82498_((float)0.0f, (float)this.m_6080_()).m_82541_().m_82490_(-11.5);
                Vec3 portalPos = this.m_20182_().m_82520_(direction.f_82479_, 0.25, direction.f_82481_);
                this.setTimer("death_portal", 30, () -> {
                    this.m_5496_(SFX.Entity.DemonLord.DEATH, 1.0f, 1.0f);
                    DemonReturnPortal portal = new DemonReturnPortal((EntityType)EntityInit.DEMON_RETURN_PORTAL.get(), this.m_9236_());
                    portal.m_146884_(portalPos);
                    portal.setFocus(this);
                    this.m_9236_().m_7967_((Entity)portal);
                });
                BlockPos myPos = this.m_20183_();
                for (int i = -4; i <= 4; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        for (int k = -4; k <= 4; ++k) {
                            BlockPos offsetPos = myPos.m_7918_(i, j, k);
                            BlockState bs2 = this.m_9236_().m_8055_(offsetPos);
                            Block block = bs2.m_60734_();
                            if (block != BlockInit.HELLFIRE.get() && block != Blocks.f_50083_) continue;
                            this.m_9236_().m_7731_(offsetPos, Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                }
                this.m_9236_().m_45556_(this.m_20191_().m_82400_(5.0)).forEach(bs -> {});
            }
            this.m_21219_();
            super.m_6667_(pCause);
        }
    }

    protected void m_6153_() {
        ++this.demonDeathTime;
        if (this.demonDeathTime == 155 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected SoundEvent m_7515_() {
        return SFX.Entity.DemonLord.IDLE;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SFX.Entity.DemonLord.HIT;
    }

    @Override
    public boolean m_6469_(DamageSource type, float amount) {
        if (!(type.m_276093_(DamageTypes.f_268724_) || this.getAction() != Action.PHASE_2_TRANSITION && this.getAction() != Action.PHASE_3_TRANSITION && this.queuedPhaseTransition <= 0)) {
            if (this.m_21223_() < 1.0f) {
                this.m_21153_(1.0f);
            }
            return false;
        }
        if (type.m_269533_(DamageTypeTags.f_268745_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 2));
            if (this.m_9236_().m_46467_() % 5L == 0L) {
                this.m_5634_(amount);
            }
            return false;
        }
        return super.m_6469_(type, amount);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("phase", ((Byte)this.f_19804_.m_135370_(PHASE)).byteValue());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setAction(Action.IDLE);
        this.f_19804_.m_135381_(PHASE, (Object)((byte)MathUtils.clamp(nbt.m_128445_("phase"), 1, 3)));
    }

    public boolean m_6051_() {
        return false;
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (!this.naturalSpawn()) {
            if (this.getAction() == Action.FJ_WAITING_ITEM) {
                builder.thenLoop("animation.DemonLord.item_wait");
            } else if (this.getAction() == Action.FJ_IMBUING) {
                builder.thenPlay("animation.DemonLord.grasp_of_fire_no_throw");
                builder.thenLoop("animation.DemonLord.grasp_of_fire_no_throw_end_loop");
            }
        } else if (this.getAction() == Action.DEATH) {
            builder.thenPlay("animation.DemonLord.death");
        } else if (this.getAction() == Action.PHASE_2_TRANSITION) {
            builder.thenPlay("animation.DemonLord.phase_transition_2");
            builder.thenLoop("animation.DemonLord.regenerating");
        } else if (this.getAction() == Action.PHASE_3_TRANSITION) {
            builder.thenPlay("animation.DemonLord.phase_transition_3");
            builder.thenLoop("animation.DemonLord.regenerating");
        } else if (this.getAction() == Action.LEAPING) {
            builder.thenPlay("animation.DemonLord.axe_leap");
            builder.thenLoop("animation.DemonLord.axe_leap_loop");
        } else if (this.getAction() == Action.LEAP_LANDING) {
            builder.thenPlay("animation.DemonLord.axe_leap_land");
        } else if (this.getAction() == Action.SUMMON) {
            builder.thenPlay("animation.DemonLord.summon");
        } else if (this.getAction() == Action.GRASP_OF_FIRE) {
            builder.thenPlay("animation.DemonLord.grasp_of_fire");
        } else if (this.getAction() == Action.ATTACKING) {
            switch (this.getAttackAction()) {
                case CAST_1: {
                    builder.thenPlay("animation.DemonLord.cast");
                    break;
                }
                case CAST_2: {
                    builder.thenPlay("animation.DemonLord.cast_2");
                    break;
                }
                case DUALWIELD_OVERHEAD: {
                    builder.thenPlay("animation.DemonLord.dual_wield_overhead");
                    break;
                }
                case DUALWIELD_SWEEP: {
                    builder.thenPlay("animation.DemonLord.dual_weapon_sweep");
                    break;
                }
                case LEFT_OVERHEAD: {
                    builder.thenPlay("animation.DemonLord.left_weapon_overhead");
                    break;
                }
                case LEFT_SWEEP: {
                    builder.thenPlay("animation.DemonLord.left_weapon_sweep");
                    break;
                }
                case RIGHT_OVERHEAD: {
                    builder.thenPlay("animation.DemonLord.right_weapon_overhead");
                    break;
                }
                case RIGHT_SWEEP: {
                    builder.thenPlay("animation.DemonLord.right_weapon_sweep");
                    break;
                }
                case STAFF_CAST_1: {
                    builder.thenPlay("animation.DemonLord.staff_cast_1");
                    break;
                }
                case STAFF_CAST_2: {
                    builder.thenPlay("animation.DemonLord.staff_cast_2");
                    break;
                }
                case STAFF_CAST_3: {
                    builder.thenPlay("animation.DemonLord.staff_cast_3");
                    break;
                }
                case TWOHAND_OVERHEAD: {
                    builder.thenPlay("animation.DemonLord.two_handed_overhead");
                    break;
                }
                default: {
                    builder.thenLoop("animation.DemonLord.idle");
                    break;
                }
            }
        } else {
            double movementSpeed = this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_();
            if (movementSpeed > 0.1) {
                builder.thenLoop("animation.DemonLord.run");
            } else if (movementSpeed > 0.02) {
                builder.thenLoop("animation.DemonLord.walk");
            } else {
                builder.thenLoop("animation.DemonLord.idle");
            }
        }
        return state.setAndContinue(builder);
    }

    @Override
    public void handle(CustomInstructionKeyframeEvent<BossMonster<?>> event) {
        String instruction = event.getKeyframeData().getInstructions();
        if (instruction == "axe_throw" && (this.getAction() == Action.PHASE_2_TRANSITION || this.getAction() == Action.PHASE_3_TRANSITION)) {
            this.setWeaponState(WeaponState.NOTHING);
        } else if (instruction == "sword_draw") {
            this.setWeaponState(WeaponState.SWORDS);
        } else if (instruction == "staff_draw") {
            this.setWeaponState(WeaponState.STAFF);
        }
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return new HashMap<String, Integer>();
    }

    @Override
    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    @Override
    public Player getRaidTarget() {
        return null;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public void setRaidTarget(Player player) {
    }

    @Override
    public void setTier(int tier) {
    }

    public static enum WeaponState {
        AXE,
        NOTHING,
        SWORDS,
        STAFF;

    }

    public static enum Action {
        IDLE,
        FJ_WAITING_ITEM,
        FJ_IMBUING,
        ATTACKING,
        LEAPING,
        LEAP_LANDING,
        GRASP_OF_FIRE,
        PHASE_2_TRANSITION,
        PHASE_3_TRANSITION,
        SUMMON,
        DEATH;

    }

    public static enum AttackAction {
        NONE(0, 0),
        LEFT_OVERHEAD(10, 14),
        RIGHT_OVERHEAD(10, 14),
        LEFT_SWEEP(12, 16),
        RIGHT_SWEEP(12, 16),
        TWOHAND_OVERHEAD(10, 14),
        DUALWIELD_OVERHEAD(10, 14),
        DUALWIELD_SWEEP(10, 14),
        CAST_1(25, 30),
        CAST_2(16, 20),
        STAFF_CAST_1(22, 26),
        STAFF_CAST_2(16, 20),
        STAFF_CAST_3(72, 80);

        public final int animLength;
        public final int resetTime;

        private AttackAction(int animLength, int resetTime) {
            this.animLength = animLength;
            this.resetTime = resetTime;
        }
    }

    private class PhaseTransitionGoal
    extends Goal {
        private DemonLord entity;

        public PhaseTransitionGoal(DemonLord entity) {
            this.entity = entity;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            return this.entity.getAction() == Action.PHASE_2_TRANSITION || this.entity.getAction() == Action.PHASE_3_TRANSITION;
        }

        public boolean m_8045_() {
            return this.entity.m_21223_() < this.entity.m_21233_();
        }
    }

    public class HellballGoal
    extends CastSpellAtTargetGoal<DemonLord> {
        private boolean casting;
        private int warmupCounter;
        private int resetCounter;
        private ItemStack hellball;

        public HellballGoal(ItemStack hellball) {
            super(DemonLord.this, hellball, 0.6, 300, 32.0f, false);
            this.casting = false;
            this.warmupCounter = 0;
            this.resetCounter = 0;
            this.hellball = hellball;
            this.setPrecastCallback(e -> {
                this.casting = true;
                e.setAction(Action.ATTACKING);
                e.setAttackAction(AttackAction.STAFF_CAST_3);
                return false;
            });
        }

        @Override
        public boolean m_8036_() {
            if ((Byte)((DemonLord)this.entity).f_19804_.m_135370_(PHASE) != 3 || ((DemonLord)this.entity).isOnCooldown(1028) || ((DemonLord)this.entity).globalSpellCooldown > 0) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.target = ((DemonLord)this.entity).getRandomThreatTableTarget(32.0);
            if (this.target == null) {
                this.target = ((DemonLord)this.entity).m_5448_();
            }
            this.casting = false;
            this.warmupCounter = 0;
            this.resetCounter = 0;
        }

        private void fireHellball() {
            SpellProjectile projectile = new SpellProjectile((LivingEntity)this.entity, DemonLord.this.m_9236_());
            projectile.setSpellRecipe(this.hellball.m_41783_());
            projectile.setHellball((Entity)this.target, 0.1f);
            projectile.shoot((Entity)this.entity, ((DemonLord)this.entity).m_20156_(), 0.1f, 0.0f);
            DemonLord.this.m_9236_().m_7967_((Entity)projectile);
        }

        @Override
        public void m_8037_() {
            if (!this.casting) {
                super.m_8037_();
            } else {
                ++this.warmupCounter;
                if (this.warmupCounter == 55) {
                    this.fireHellball();
                } else if (this.warmupCounter > 55 && this.resetCounter++ >= 20) {
                    ((DemonLord)this.entity).setAction(Action.IDLE);
                    ((DemonLord)this.entity).setAttackAction(AttackAction.NONE);
                    ((DemonLord)this.entity).setCooldown(1028, 600);
                    this.hasCast = true;
                }
            }
        }
    }

    public class GraspOfFireGoal
    extends Goal {
        private static final float pullStrength = 0.2f;
        private Optional<LivingEntity> grabbed = Optional.empty();
        private int tickCount = 0;

        public GraspOfFireGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            boolean isCorrectPhase = (Byte)DemonLord.this.f_19804_.m_135370_(PHASE) == 1 || (Byte)DemonLord.this.f_19804_.m_135370_(PHASE) == 3;
            boolean isOffCD = !DemonLord.this.isOnCooldown(1027);
            boolean isIdle = DemonLord.this.getAction() == Action.IDLE;
            boolean hasTarget = DemonLord.this.m_5448_() != null;
            boolean onGround = DemonLord.this.m_20096_();
            return isOffCD && isIdle && hasTarget && onGround && isCorrectPhase;
        }

        public boolean m_8045_() {
            boolean actionIsGraspOfFire = DemonLord.this.getAction() == Action.GRASP_OF_FIRE;
            boolean hasTarget = DemonLord.this.m_5448_() != null;
            return actionIsGraspOfFire && hasTarget;
        }

        public boolean m_6767_() {
            return !DemonLord.this.isPhaseTransitioning();
        }

        public void m_8056_() {
            LivingEntity target = DemonLord.this.m_5448_();
            BlockPos targetPos = BlockPos.m_274446_((Position)target.m_146892_());
            DemonLord.this.setPullPos(targetPos);
            DemonLord.this.setAction(Action.GRASP_OF_FIRE);
            DemonLord.this.m_21573_().m_26573_();
            this.tickCount = 0;
            this.grabbed = Optional.empty();
        }

        public void m_8041_() {
            if (!DemonLord.this.isPhaseTransitioning()) {
                DemonLord.this.setAction(Action.IDLE);
            }
            DemonLord.this.setCooldown(1027, 300);
        }

        public void m_8037_() {
            if (DemonLord.this.m_5448_() == null) {
                return;
            }
            ++this.tickCount;
            DemonLord.this.m_7618_(EntityAnchorArgument.Anchor.FEET, DemonLord.this.m_5448_().m_20182_());
            if (this.tickCount < 46) {
                this.pullEntities();
            } else if (this.tickCount == 46 && this.grabbed.isEmpty()) {
                this.grabbed = this.tryGrab();
                DemonLord.this.setPullPos(null);
                if (this.grabbed.isEmpty()) {
                    this.m_8041_();
                    return;
                }
                LivingEntity living = this.grabbed.get();
                DemonLord.this.lockTargetInPlace(living, true);
                DemonLord.this.setTimer("burn", 10, () -> DemonLord.this.setIncinerateTarget(living));
            } else if (this.tickCount == 108) {
                LivingEntity living = this.grabbed.get();
                living.m_21195_((MobEffect)EffectInit.LIFT.get());
                Vec3 direction = Vec3.m_82503_((Vec2)new Vec2(0.0f, DemonLord.this.m_146908_())).m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                ComponentFling.flingTarget(living, direction, 3.0f, 3.0f, 0.0f);
                DemonLord.this.setIncinerateTarget(null);
            } else if (this.tickCount == 118) {
                this.m_8041_();
            }
        }

        private void pullEntities() {
            Vec3 graspPoint = DemonLord.this.getPullPos();
            if (graspPoint == null) {
                return;
            }
            DemonLord.this.m_9236_().m_6249_((Entity)DemonLord.this, new AABB(BlockPos.m_274446_((Position)graspPoint)).m_82400_(256.0), e -> {
                if (!(e instanceof LivingEntity) || !e.m_6084_() || e.m_20238_(graspPoint) > 256.0) {
                    return false;
                }
                return !(e instanceof Player) || !((Player)e).m_7500_() && !((Player)e).m_5833_();
            }).stream().map(e -> (LivingEntity)e).forEach(e -> {
                Vec3 delta = graspPoint.m_82546_(e.m_20182_()).m_82541_();
                ComponentFling.flingTarget(e, delta, 0.04f, 0.2f, 0.5f);
            });
        }

        private Optional<LivingEntity> tryGrab() {
            Vec3 graspPoint = DemonLord.this.getPullPos();
            if (graspPoint == null) {
                return Optional.empty();
            }
            return DemonLord.this.m_9236_().m_6249_((Entity)DemonLord.this, new AABB(BlockPos.m_274446_((Position)graspPoint)).m_82400_(16.0), e -> {
                if (!(e instanceof LivingEntity) || !e.m_6084_() || e.m_20238_(graspPoint) > 6.25) {
                    return false;
                }
                if (!DemonLord.this.m_21574_().m_148306_(e)) {
                    return false;
                }
                return DemonLord.this.m_5448_() == e || DemonLord.this.threat.isOn((LivingEntity)e);
            }).stream().map(e -> (LivingEntity)e).sorted((a, b) -> (int)(a.m_20238_(graspPoint) - b.m_20238_(graspPoint))).findFirst();
        }
    }

    public class LerpLeap
    extends Goal {
        private float minDist;
        private float maxDist;
        private int lerpTicks;
        private int initialDelay;
        private int phaseTicks = 0;
        private int phase = 0;
        private Vec3 start;
        private Vec3 end;
        private Vec3 control_1;
        private Vec3 control_2;

        public LerpLeap(float minDist, float maxDist, int initialDelay) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.minDist = minDist;
            this.maxDist = maxDist;
            this.initialDelay = initialDelay;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            if (DemonLord.this.m_5448_() == null || !DemonLord.this.m_6084_() || !DemonLord.this.m_5448_().m_6084_() || DemonLord.this.isOnCooldown(1024) || (Byte)DemonLord.this.f_19804_.m_135370_(PHASE) == 3 || DemonLord.this.getAction() != Action.IDLE) {
                return false;
            }
            double dist = DemonLord.this.m_20280_((Entity)DemonLord.this.m_5448_());
            return dist >= (double)(this.minDist * this.minDist) && dist <= (double)(this.maxDist * this.maxDist);
        }

        public void m_8041_() {
            this.setPhase(0);
            DemonLord.this.m_20242_(false);
            DemonLord.this.setCooldown(1024, 300);
            if (!DemonLord.this.isPhaseTransitioning()) {
                DemonLord.this.setAction(Action.IDLE);
            }
        }

        public boolean m_8045_() {
            return DemonLord.this.m_5448_() != null && DemonLord.this.getAction() != Action.IDLE && this.phase < 4;
        }

        public void m_8056_() {
            DemonLord.this.m_20242_(true);
            DemonLord.this.m_21573_().m_26573_();
            DemonLord.this.m_20256_(Vec3.f_82478_);
            DemonLord.this.setAction(Action.LEAPING);
            this.setPhase(0);
        }

        private void setPhase(int phase) {
            this.phase = phase;
            this.phaseTicks = 0;
        }

        public void m_8037_() {
            if (DemonLord.this.m_5448_() == null) {
                return;
            }
            ++this.phaseTicks;
            switch (this.phase) {
                case 0: {
                    if (this.phaseTicks < this.initialDelay) break;
                    Vec3 direction = DemonLord.this.m_5448_().m_20182_().m_82546_(DemonLord.this.m_20182_()).m_82541_();
                    this.start = DemonLord.this.m_20182_();
                    this.end = DemonLord.this.m_5448_().m_20182_().m_82546_(direction);
                    float speed = 2.0f;
                    double distance = this.start.m_82554_(this.end);
                    this.lerpTicks = (int)(distance / (double)speed);
                    Vec3 difference = this.end.m_82546_(this.start);
                    this.control_1 = this.start.m_82549_(difference.m_82490_(0.3)).m_82520_(0.0, 3.0, 0.0);
                    this.control_2 = this.start.m_82549_(difference.m_82490_(0.6)).m_82520_(0.0, 3.0, 0.0);
                    DemonLord.this.m_5496_(SFX.Entity.DemonLord.LEAP, 1.0f, (float)(0.9 + Math.random() * 0.2));
                    this.setPhase(1);
                    break;
                }
                case 1: {
                    if (this.phaseTicks <= this.lerpTicks) {
                        if (this.lerpTicks < 5 || this.phaseTicks == this.lerpTicks - 5) {
                            DemonLord.this.setAction(Action.LEAP_LANDING);
                        }
                        float lerpPct = (float)this.phaseTicks / (float)this.lerpTicks;
                        Vec3 position = MathUtils.bezierVector3d(this.start, this.end, this.control_1, this.control_2, lerpPct);
                        DemonLord.this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.end);
                        DemonLord.this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
                        break;
                    }
                    this.setPhase(2);
                    break;
                }
                case 2: {
                    double dist = DemonLord.this.m_20280_((Entity)DemonLord.this.m_5448_());
                    if (dist < 16.0) {
                        DemonLord.this.damageEntity((Entity)DemonLord.this.m_5448_());
                    }
                    this.setPhase(3);
                    break;
                }
                case 3: {
                    if (this.phaseTicks < 10) break;
                    this.setPhase(4);
                }
            }
        }
    }
}

