/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.entities.EntityInit;
import com.mna.entities.IAnimPacketSync;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.attacks.PumpkinKingEntangle;
import com.mna.entities.boss.attacks.PumpkinKingIncinerate;
import com.mna.network.ServerMessageDispatcher;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PumpkinKing
extends BossMonster<PumpkinKing>
implements IEntityAdditionalSpawnData,
IAnimPacketSync<PumpkinKing> {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    private static final Predicate<Player> randomPlayerFlyable = p -> p.m_150110_().f_35935_ || !p.m_20096_();
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_ENTANGLE = "entangle";
    private static final String INSTRUCTION_INCINERATE = "incinerate";
    private static final int ENTANGLE_CD = 300;
    private static final int INCINERATE_CD = 300;
    private static final int ATTACK_CD = 20;
    private int entangleCooldown = 0;
    private int incinerateCooldown = 0;
    private int attackCooldown = 0;
    private boolean isAttacking = false;
    private boolean leftHandPunch = false;
    private boolean isEntangling = false;
    private boolean isIncinerating = false;

    public PumpkinKing(EntityType<? extends PumpkinKing> type, Level world) {
        super(type, world);
    }

    public PumpkinKing(Level world) {
        this((EntityType<? extends PumpkinKing>)((EntityType)EntityInit.PUMPKIN_KING.get()), world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BossMonster.DoNothingGoal());
        this.f_21345_.m_25352_(1, (Goal)new EntangleGoal());
        this.f_21345_.m_25352_(1, (Goal)new IncinerateGoal());
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.entangleCooldown;
        --this.incinerateCooldown;
        --this.attackCooldown;
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isAttacking || this.attackCooldown > 0) {
            return true;
        }
        this.m_5496_(SFX.Entity.PumpkinKing.ATTACK, this.m_6121_(), this.m_6100_());
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 10, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 15, "", this::handleDelayCallback));
        this.isAttacking = true;
        this.leftHandPunch = Math.random() < 0.5;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        return true;
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            block5 : switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                    break;
                }
                case "incinerate": {
                    Player player;
                    ArrayList<Player> attacked = new ArrayList<Player>();
                    for (int i = 0; i < 10 && (player = this.getRandomNearbyPlayer(null)) != null; ++i) {
                        if (!attacked.contains(player)) {
                            this.spawnIncinerate(player);
                            attacked.add(player);
                        }
                        if (attacked.size() >= 4 || attacked.size() == this.m_9236_().m_6907_().size()) break block5;
                    }
                    break;
                }
                case "entangle": {
                    Player player = this.getRandomNearbyPlayer(randomPlayerFlyable);
                    if (player == null) break;
                    this.spawnEntangle(player);
                }
            }
        }
    }

    private void spawnIncinerate(Player player) {
        PumpkinKingIncinerate incinerate = new PumpkinKingIncinerate(this.m_9236_());
        incinerate.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        this.m_9236_().m_7967_((Entity)incinerate);
    }

    private void spawnEntangle(Player player) {
        BlockPos spawnPos = player.m_20183_();
        int offsetAmount = 10;
        spawnPos = spawnPos.m_7918_(-offsetAmount + (int)(Math.random() * (double)offsetAmount * 2.0), 0, -offsetAmount + (int)(Math.random() * (double)offsetAmount * 2.0));
        while (spawnPos.m_123342_() > 0 && this.m_9236_().m_46859_(spawnPos)) {
            spawnPos = spawnPos.m_7495_();
        }
        spawnPos = spawnPos.m_7494_();
        PumpkinKingEntangle entangle = new PumpkinKingEntangle(this.m_9236_());
        entangle.m_6034_((float)spawnPos.m_123341_() + 0.5f, spawnPos.m_123342_(), (float)spawnPos.m_123343_() + 0.5f);
        entangle.setTarget(player);
        this.m_9236_().m_7967_((Entity)entangle);
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity;
                this.maybeDisableShield(playerentity, (playerentity = (Player)entityIn).m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.4f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void maybeDisableShield(Player player, ItemStack playerItem) {
        if (!playerItem.m_41619_() && playerItem.m_41720_().canPerformAction(playerItem, ToolActions.SHIELD_BLOCK)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isAttacking = false;
            if (this.isEntangling) {
                this.entangleCooldown = 300;
                if (this.incinerateCooldown <= 0) {
                    this.incinerateCooldown = 37;
                }
                this.isEntangling = false;
            } else if (this.isIncinerating) {
                this.incinerateCooldown = 300;
                this.isIncinerating = false;
            } else {
                this.attackCooldown = 20;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isAttacking);
        nbt.m_128379_("entangling", this.isEntangling);
        nbt.m_128379_("incinerating", this.isIncinerating);
        nbt.m_128379_("left_hand_punch", this.leftHandPunch);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isAttacking = nbt.m_128471_("attacking");
        this.isEntangling = nbt.m_128471_("entangling");
        this.isIncinerating = nbt.m_128471_("incinerating");
        this.leftHandPunch = nbt.m_128471_("left_hand_punch");
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(79);
        this.m_21153_(this.m_21233_() / 3.0f);
        this.m_5496_(SFX.Entity.PumpkinKing.SPAWN, this.m_6121_(), this.m_6100_());
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return null;
    }

    @Override
    public int getArenaStructureSegment() {
        return -1;
    }

    protected SoundEvent m_7515_() {
        return SFX.Entity.PumpkinKing.IDLE;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.PumpkinKing.DEATH;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SFX.Entity.PumpkinKing.HURT;
    }

    @Override
    public boolean m_6469_(DamageSource type, float amount) {
        if (this.getInvulnerableTicks() > 0 && type.m_276093_(DamageTypes.f_268724_)) {
            return false;
        }
        if (this.isDamageCheaty(type)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return false;
        }
        if (type.m_269533_(DamageTypeTags.f_268419_)) {
            amount *= 2.0f;
        }
        if (type.m_269533_(DamageTypeTags.f_268745_)) {
            amount = (float)((double)amount * 0.5);
        }
        return super.m_6469_(type, amount);
    }

    @Override
    protected void m_8024_() {
        if (this.getInvulnerableTicks() > 0) {
            int j1 = this.getInvulnerableTicks() - 1;
            if (j1 <= 0) {
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
                this.m_5634_(this.m_21233_());
            }
            this.setInvulnerableTicks(j1);
            if (this.f_19797_ % 10 == 0) {
                this.m_5634_(25.0f);
            }
        }
        super.m_8024_();
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        if (this.getInvulnerableTicks() > 0) {
            state.getController().transitionLength(0);
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.PumpkinKing.spawn"));
        }
        state.getController().transitionLength(2);
        if (!this.isAttacking) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.PumpkinKing.walk"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.PumpkinKing.idle"));
        }
        if (this.isIncinerating) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.PumpkinKing.incinerate"));
        }
        if (this.isEntangling) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.PumpkinKing.entangle"));
        }
        if (this.leftHandPunch) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.PumpkinKing.swipe_left").thenLoop("animation.PumpkinKing.idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.PumpkinKing.swipe_right").thenLoop("animation.PumpkinKing.idle"));
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_146922_(additionalData.readFloat());
        this.f_19859_ = additionalData.readFloat();
        this.m_146926_(additionalData.readFloat());
        this.f_19860_ = additionalData.readFloat();
        this.f_20883_ = this.m_146908_();
        this.f_20884_ = this.f_19859_;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.m_146908_());
        buffer.writeFloat(this.f_19859_);
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.f_19860_);
    }

    public class EntangleGoal
    extends Goal {
        public EntangleGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return PumpkinKing.this.entangleCooldown <= 0 && PumpkinKing.this.m_5448_() != null && !PumpkinKing.this.isAttacking && PumpkinKing.this.incinerateCooldown <= 0;
        }

        public void m_8056_() {
            PumpkinKing.this.m_21573_().m_26573_();
            PumpkinKing.this.isEntangling = true;
            PumpkinKing.this.isAttacking = true;
            PumpkinKing.this.m_5496_(SFX.Entity.PumpkinKing.ENTANGLE, PumpkinKing.this.m_6121_(), PumpkinKing.this.m_6100_());
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(PumpkinKing.INSTRUCTION_ENTANGLE, 15, (LivingEntity)PumpkinKing.this, PumpkinKing.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(PumpkinKing.INSTRUCTION_ENTANGLE, 25, (LivingEntity)PumpkinKing.this, PumpkinKing.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(PumpkinKing.INSTRUCTION_ENTANGLE, 35, (LivingEntity)PumpkinKing.this, PumpkinKing.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(PumpkinKing.INSTRUCTION_ENTANGLE, 45, (LivingEntity)PumpkinKing.this, PumpkinKing.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 60, "", PumpkinKing.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(PumpkinKing.this);
        }

        public boolean m_8045_() {
            return PumpkinKing.this.isEntangling;
        }
    }

    public class IncinerateGoal
    extends Goal {
        public IncinerateGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return PumpkinKing.this.incinerateCooldown <= 0 && PumpkinKing.this.m_5448_() != null && !PumpkinKing.this.isAttacking;
        }

        public void m_8056_() {
            PumpkinKing.this.m_21573_().m_26573_();
            PumpkinKing.this.isIncinerating = true;
            PumpkinKing.this.isAttacking = true;
            PumpkinKing.this.m_5496_(SFX.Entity.PumpkinKing.INCINERATE, PumpkinKing.this.m_6121_(), PumpkinKing.this.m_6100_());
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(PumpkinKing.INSTRUCTION_INCINERATE, 65, (LivingEntity)PumpkinKing.this, PumpkinKing.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(PumpkinKing.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 82, "", PumpkinKing.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(PumpkinKing.this);
        }

        public boolean m_8045_() {
            return PumpkinKing.this.isIncinerating;
        }
    }
}

